/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.impl.ClientBackupAwareResponse;
import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.ClientEndpointManager;
import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.MessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeExtension;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.tpcengine.iobuffer.IOBufferAllocator;
import com.hazelcast.internal.tpcengine.net.AsyncSocket;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import java.lang.reflect.Field;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractMessageTask<P>
implements MessageTask,
SecureRequest {
    private static final List<Class<? extends Throwable>> NON_PEELABLE_EXCEPTIONS = List.of(Error.class, MemberLeftException.class);
    protected AsyncSocket asyncSocket;
    protected IOBufferAllocator responseBufAllocator;
    protected final ClientMessage clientMessage;
    protected final ServerConnection connection;
    protected final ClientEndpoint endpoint;
    protected final NodeEngine nodeEngine;
    protected final InternalSerializationService serializationService;
    protected final ILogger logger;
    protected final ClientEngine clientEngine;
    protected P parameters;
    private final ClientEndpointManager endpointManager;
    private final NodeExtension nodeExtension;
    private final BuildInfo buildInfo;
    private final Config config;
    private final ClusterServiceImpl clusterService;

    protected AbstractMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        this.clientMessage = clientMessage;
        this.logger = node.getLogger(this.getClass());
        this.nodeEngine = node.getNodeEngine();
        this.serializationService = node.getSerializationService();
        this.connection = (ServerConnection)connection;
        this.clientEngine = node.getClientEngine();
        this.endpointManager = this.clientEngine.getEndpointManager();
        this.endpoint = this.initEndpoint();
        this.nodeExtension = node.getNodeExtension();
        this.buildInfo = node.getBuildInfo();
        this.config = node.getConfig();
        this.clusterService = node.getClusterService();
    }

    protected AbstractMessageTask(ClientMessage clientMessage, ILogger logger, NodeEngine nodeEngine, InternalSerializationService serializationService, ClientEngine clientEngine, Connection connection, NodeExtension nodeExtension, BuildInfo buildInfo, Config config, ClusterServiceImpl clusterService) {
        this.clientMessage = clientMessage;
        this.logger = logger;
        this.nodeEngine = nodeEngine;
        this.serializationService = serializationService;
        this.clientEngine = clientEngine;
        this.connection = (ServerConnection)connection;
        this.endpointManager = clientEngine.getEndpointManager();
        this.endpoint = this.initEndpoint();
        this.nodeExtension = nodeExtension;
        this.buildInfo = buildInfo;
        this.config = config;
        this.clusterService = clusterService;
    }

    public void setAsyncSocket(AsyncSocket asyncSocket) {
        this.asyncSocket = asyncSocket;
    }

    public void setResponseBufAllocator(IOBufferAllocator responseBufAllocator) {
        this.responseBufAllocator = responseBufAllocator;
    }

    public <S> S getService(String serviceName) {
        return (S)this.nodeEngine.getService(serviceName);
    }

    private ClientEndpoint initEndpoint() {
        ClientEndpoint endpoint = this.endpointManager.getEndpoint(this.connection);
        if (endpoint != null) {
            return endpoint;
        }
        return new ClientEndpointImpl(this.clientEngine, this.nodeEngine, this.connection);
    }

    protected abstract P decodeClientMessage(ClientMessage var1);

    protected abstract ClientMessage encodeResponse(Object var1);

    @Override
    public final void run() {
        try {
            Address address = this.connection.getRemoteAddress();
            if (this.isManagementTask() && !this.clientEngine.getManagementTasksChecker().isTrusted(address)) {
                String message = "The client address " + address + " is not allowed for management task " + this.getClass().getName();
                this.logger.info(message);
                throw new AccessControlException(message);
            }
            if (this.requiresAuthentication() && !this.endpoint.isAuthenticated()) {
                this.handleAuthenticationFailure();
            } else {
                this.initializeAndProcessMessage();
            }
        }
        catch (Throwable e) {
            this.handleProcessingFailure(e);
        }
    }

    protected boolean requiresAuthentication() {
        return true;
    }

    protected boolean acceptOnIncompleteStart() {
        return false;
    }

    protected boolean validateNodeStartBeforeDecode() {
        return true;
    }

    private void initializeAndProcessMessage() throws Throwable {
        if (this.validateNodeStartBeforeDecode()) {
            this.validateNodeStart();
        }
        this.parameters = this.decodeClientMessage(this.clientMessage);
        assert (this.addressesDecodedWithTranslation()) : this.formatWrongAddressInDecodedMessage();
        Credentials credentials = this.endpoint.getCredentials();
        this.interceptBefore(credentials);
        this.checkPermissions(this.endpoint);
        this.processMessage();
        this.interceptAfter(credentials);
    }

    protected final void validateNodeStart() {
        boolean acceptOnIncompleteStart;
        boolean bl = acceptOnIncompleteStart = this.acceptOnIncompleteStart() && "MCJVM".equals(this.endpoint.getClientType());
        if (!acceptOnIncompleteStart && !this.nodeExtension.isStartCompleted()) {
            throw new HazelcastInstanceNotActiveException("Hazelcast instance is not ready yet!");
        }
    }

    private void handleAuthenticationFailure() {
        RuntimeException exception;
        Object closeReason;
        if (this.nodeEngine.isRunning()) {
            String message = "Client " + this.endpoint + " must authenticate before any operation.";
            String secureMessage = "Client " + this.endpoint.toSecureString() + " must authenticate before any operation.";
            this.logger.severe(message);
            closeReason = message;
            exception = new RetryableHazelcastException(new AuthenticationException(secureMessage));
        } else {
            exception = new HazelcastInstanceNotActiveException();
            closeReason = exception.getMessage();
        }
        this.sendClientMessage(exception);
        this.connection.close("Authentication failed. " + (String)closeReason, null);
    }

    private void logProcessingFailure(Throwable throwable) {
        if (this.logger.isFinestEnabled()) {
            if (this.parameters == null) {
                this.logger.finest(throwable.getMessage(), throwable);
            } else {
                this.logger.finest("While executing request: " + this.parameters + " -> " + throwable.getMessage(), throwable);
            }
        }
    }

    protected void handleProcessingFailure(Throwable throwable) {
        this.logProcessingFailure(throwable);
        this.sendClientMessage(throwable);
    }

    private void interceptBefore(Credentials credentials) {
        SecurityContext securityContext = this.clientEngine.getSecurityContext();
        String methodName = this.getMethodName();
        if (securityContext != null && methodName != null) {
            String objectType = this.getDistributedObjectType();
            String objectName = this.getDistributedObjectName();
            securityContext.interceptBefore(credentials, objectType, objectName, methodName, this.getParameters());
        }
    }

    private void interceptAfter(Credentials credentials) {
        SecurityContext securityContext = this.clientEngine.getSecurityContext();
        String methodName = this.getMethodName();
        if (securityContext != null && methodName != null) {
            String objectType = this.getDistributedObjectType();
            String objectName = this.getDistributedObjectName();
            securityContext.interceptAfter(credentials, objectType, objectName, methodName);
        }
    }

    private void checkPermissions(ClientEndpoint endpoint) {
        SecurityContext securityContext = this.clientEngine.getSecurityContext();
        if (securityContext != null) {
            AbstractMessageTask.checkPermissions(endpoint, securityContext, this.getRequiredPermission());
            AbstractMessageTask.checkPermissions(endpoint, securityContext, this.getUserCodeNamespacePermission());
        }
    }

    private static void checkPermissions(ClientEndpoint endpoint, SecurityContext securityContext, Permission permission) {
        if (permission != null) {
            securityContext.checkPermission(endpoint.getSubject(), permission);
        }
    }

    protected abstract void processMessage() throws Throwable;

    protected void sendResponse(Object response) {
        try {
            ClientMessage clientMessage;
            int numberOfBackups = 0;
            if (response instanceof ClientBackupAwareResponse) {
                ClientBackupAwareResponse backupAwareResponse = (ClientBackupAwareResponse)response;
                response = backupAwareResponse.getResponse();
                numberOfBackups = backupAwareResponse.getNumberOfBackups();
            } else if (response instanceof NormalResponse) {
                NormalResponse normalResponse = (NormalResponse)response;
                response = normalResponse.getValue();
            }
            if (response instanceof Throwable) {
                Throwable throwable = (Throwable)response;
                clientMessage = this.encodeException(throwable);
            } else {
                clientMessage = this.encodeResponse(response);
            }
            assert (numberOfBackups >= 0 && numberOfBackups < 127);
            clientMessage.setNumberOfBackupAcks((byte)numberOfBackups);
            this.sendClientMessage(clientMessage);
        }
        catch (Exception e) {
            this.handleProcessingFailure(e);
        }
    }

    protected void sendClientMessage(ClientMessage resultClientMessage) {
        resultClientMessage.setCorrelationId(this.clientMessage.getCorrelationId());
        if (this.asyncSocket == null) {
            this.connection.write(resultClientMessage);
        } else if (!this.asyncSocket.writeAndFlush(resultClientMessage)) {
            this.connection.close("Response could not be send due to congested socket " + this.asyncSocket, null);
        }
    }

    protected void sendClientMessage(Object key, ClientMessage resultClientMessage) {
        int partitionId = key == null ? -1 : this.nodeEngine.getPartitionService().getPartitionId(key);
        resultClientMessage.setPartitionId(partitionId);
        this.sendClientMessage(resultClientMessage);
    }

    private void sendClientMessage(Throwable throwable) {
        ClientMessage message = this.encodeException(throwable);
        this.sendClientMessage(message);
    }

    protected ClientMessage encodeException(Throwable throwable) {
        ClientExceptionFactory exceptionFactory = this.clientEngine.getExceptionFactory();
        return exceptionFactory.createExceptionMessage(this.peelIfNeeded(throwable));
    }

    public abstract String getServiceName();

    @Override
    public String getDistributedObjectType() {
        return this.getServiceName();
    }

    protected final BuildInfo getMemberBuildInfo() {
        return this.buildInfo;
    }

    protected boolean isAdvancedNetworkEnabled() {
        return this.config.getAdvancedNetworkConfig().isEnabled();
    }

    final boolean addressesDecodedWithTranslation() {
        if (!this.isAdvancedNetworkEnabled()) {
            return true;
        }
        if (this.parameters == null) {
            return true;
        }
        Class<Address> addressClass = Address.class;
        Field[] fields = this.parameters.getClass().getDeclaredFields();
        HashSet<Address> addresses = new HashSet<Address>();
        try {
            for (Field field : fields) {
                if (!addressClass.isAssignableFrom(field.getType())) continue;
                addresses.add((Address)field.get(this.parameters));
            }
        }
        catch (IllegalAccessException e) {
            this.logger.info("Could not reflectively access parameter fields", e);
        }
        if (!addresses.isEmpty()) {
            Collection<Address> allMemberAddresses = this.clusterService.getMemberAddresses();
            for (Address address : addresses) {
                if (allMemberAddresses.contains(address)) continue;
                return false;
            }
        }
        return true;
    }

    private String formatWrongAddressInDecodedMessage() {
        return "Decoded message of type " + this.parameters.getClass() + " contains untranslated addresses. Use ClientEngine.memberAddressOf to translate addresses while decoding this client message.";
    }

    protected Throwable peelIfNeeded(Throwable t) {
        if (t == null) {
            return null;
        }
        for (Class<? extends Throwable> clazz : NON_PEELABLE_EXCEPTIONS) {
            if (!clazz.isAssignableFrom(t.getClass())) continue;
            return t;
        }
        return ExceptionUtil.peel(t, null, null, (throwable, message) -> throwable);
    }

    @Override
    public boolean isManagementTask() {
        return false;
    }
}

