/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jqplot.lib.chart;

import org.wicketstuff.jqplot.lib.ChartConfiguration;
import org.wicketstuff.jqplot.lib.JqPlotResources;
import org.wicketstuff.jqplot.lib.chart.AbstractChart;
import org.wicketstuff.jqplot.lib.data.PieData;
import org.wicketstuff.jqplot.lib.data.item.LabeledItem;
import org.wicketstuff.jqplot.lib.elements.Legend;
import org.wicketstuff.jqplot.lib.elements.Location;
import org.wicketstuff.jqplot.lib.elements.Title;
import org.wicketstuff.jqplot.lib.metadata.JqPlotPlugin;

@JqPlotPlugin(values={JqPlotResources.PieRenderer})
public class PieChart<T extends Number>
extends AbstractChart<PieData<T>, String> {
    private static final long serialVersionUID = -9078771567964143651L;
    private final ChartConfiguration<String> chartConfig;
    private PieData<T> data = new PieData();

    public PieChart() {
        this(null);
    }

    public PieChart(String title) {
        this.chartConfig = new ChartConfiguration();
        this.chartConfig.setTitle(new Title(title)).setLegend(new Legend(true, Location.e)).seriesDefaultsInstance().setRenderer(JqPlotResources.PieRenderer).rendererOptionsInstance().setShowLables(true);
    }

    public void addValue(String label, T value) {
        this.data.addValue(new LabeledItem<T>(label, value));
    }

    public void addValue(LabeledItem<T> value) {
        this.data.addValue(value);
    }

    public void addValues(LabeledItem<T> ... values) {
        this.data.addValues(values);
    }

    @Override
    public PieData<T> getChartData() {
        return this.data;
    }

    @Override
    public ChartConfiguration<String> getChartConfiguration() {
        return this.chartConfig;
    }
}

