/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jqplot.lib.chart;

import java.util.Collection;
import org.wicketstuff.jqplot.lib.ChartConfiguration;
import org.wicketstuff.jqplot.lib.JqPlotResources;
import org.wicketstuff.jqplot.lib.chart.AbstractChart;
import org.wicketstuff.jqplot.lib.data.LineSeriesData;
import org.wicketstuff.jqplot.lib.data.item.LineSeriesItem;
import org.wicketstuff.jqplot.lib.elements.Title;
import org.wicketstuff.jqplot.lib.metadata.JqPlotPlugin;

@JqPlotPlugin(values={JqPlotResources.CategoryAxisRenderer, JqPlotResources.BarRenderer, JqPlotResources.PointLabels, JqPlotResources.CanvasTextRenderer, JqPlotResources.CanvasAxisLabelRenderer, JqPlotResources.CanvasAxisTickRenderer, JqPlotResources.CanvasOverlay, JqPlotResources.DateAxisRenderer})
public class BarSeriesChart<I extends Number, V extends Number>
extends AbstractChart<LineSeriesData<I, V>, String> {
    private static final long serialVersionUID = 3650210485517566138L;
    private final ChartConfiguration<String> chartConfig;
    private LineSeriesData<I, V> barData = new LineSeriesData();

    public BarSeriesChart() {
        this(null, null, null);
    }

    public BarSeriesChart(String title) {
        this(title, null, null);
    }

    public BarSeriesChart(String title, String labelX, String labelY) {
        this.chartConfig = new ChartConfiguration();
        this.chartConfig.setTitle(new Title(title)).setLabelX(labelX).setLabelY(labelY).seriesDefaultsInstance().pointLabelsInstance();
        this.chartConfig.seriesDefaultsInstance().setRenderer(JqPlotResources.BarRenderer).setFill(true);
    }

    public void addValue(Collection<LineSeriesItem<I, V>> value) {
        this.barData.addValue(value);
    }

    public void addValues(Collection<LineSeriesItem<I, V>> ... values) {
        this.barData.addValues(values);
    }

    @Override
    public LineSeriesData<I, V> getChartData() {
        return this.barData;
    }

    @Override
    public ChartConfiguration<String> getChartConfiguration() {
        return this.chartConfig;
    }
}

