/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jqplot.behavior;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jqplot.behavior.JqPlotCssResourceReference;
import org.wicketstuff.jqplot.behavior.JqPlotJavascriptResourceReference;
import org.wicketstuff.jqplot.lib.Chart;
import org.wicketstuff.jqplot.lib.JqPlotUtils;

public class JqPlotBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final List<String> resources;
    private Chart<?> chart;
    private String divId;

    public JqPlotBehavior(Chart<?> chart, String divId) {
        this.chart = chart;
        this.divId = divId;
        this.resources = JqPlotUtils.retriveJavaScriptResources(chart);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JqPlotJavascriptResourceReference.get()));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)JqPlotCssResourceReference.get()));
        for (String resource : this.resources) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(JqPlotBehavior.class, this.removeMinified(resource))));
        }
        String json = JqPlotUtils.createJquery(this.chart, (String)this.divId);
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)json, null));
    }

    private String removeMinified(String name_) {
        Object name = name_;
        int idxOfExtension = ((String)name).lastIndexOf(46);
        if (idxOfExtension > -1) {
            String extension = ((String)name).substring(idxOfExtension);
            if (((String)(name = ((String)name).substring(0, ((String)name).length() - extension.length() + 1))).endsWith(".min.")) {
                name = ((String)name).substring(0, ((String)name).length() - 5) + extension;
            }
        }
        return name;
    }
}

