/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal;

import java.nio.file.Path;
import org.kurento.client.internal.KmsProvider;
import org.kurento.commons.UrlServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsUrlLoader
extends UrlServiceLoader<KmsProvider> {
    private static final Logger log = LoggerFactory.getLogger(KmsUrlLoader.class);
    public static final String KMS_URL_PROPERTY = "kms.url";
    public static final String KMS_URL_PROVIDER_PROPERTY = "kms.url.provider";
    public static final String DEFAULT_KMS_URL = "ws://127.0.0.1:8888/kurento";

    public KmsUrlLoader(Path configFile) {
        super(configFile, KMS_URL_PROPERTY, KMS_URL_PROVIDER_PROPERTY, DEFAULT_KMS_URL);
    }

    public String getKmsUrl(String id) {
        log.debug("Executing getKmsUrlLoad({}) in KmsUrlLoader", (Object)id);
        if (this.getStaticUrl() == null) {
            log.debug("Obtaining kmsUrl from provider");
            return this.loadKmsUrlFromProvider(id, -1);
        }
        log.debug("Obtaining kmsUrl={} from config file or system property", (Object)this.getStaticUrl());
        return this.getStaticUrl();
    }

    public String getKmsUrlLoad(String id, int loadPoints) {
        log.debug("Executing getKmsUrlLoad({},{}) in KmsUrlLoader", (Object)id, (Object)loadPoints);
        if (this.getStaticUrl() == null) {
            log.debug("Obtaining kmsUrl from provider");
            return this.loadKmsUrlFromProvider(id, loadPoints);
        }
        log.debug("Obtaining kmsUrl={} from config file or system property", (Object)this.getStaticUrl());
        return this.getStaticUrl();
    }

    private synchronized String loadKmsUrlFromProvider(String id, int loadPoints) {
        log.debug("Executing loadKmsUrlFromProvider({},{}) in KmsUrlLoader", (Object)id, (Object)loadPoints);
        KmsProvider kmsProvider = (KmsProvider)this.getServiceProvider();
        if (loadPoints == -1) {
            String kmsUrl = kmsProvider.reserveKms(id);
            log.debug("Executed reserveKms({}) in serviceProvider with result={}", (Object)id, (Object)kmsUrl);
            return kmsUrl;
        }
        String kmsUrl = kmsProvider.reserveKms(id, loadPoints);
        log.debug("Executed reserveKms({},{}) in serviceProvider with result={}", new Object[]{id, loadPoints, kmsUrl});
        return kmsUrl;
    }

    public void clientDestroyed(String id) {
        log.debug("Executing clientDestroyed({}) in KmsUrlLoader", (Object)id);
        if (this.getStaticUrl() == null) {
            ((KmsProvider)this.getServiceProvider()).releaseKms(id);
            log.debug("Executed releaseKms({}) in serviceProvider", (Object)id);
        }
    }
}

