/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.MutationObserver;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import javax.annotation.Nonnull;

public class IndexingMutationObserver<R extends Record>
implements MutationObserver<R> {
    private final int partitionId;
    private final MapContainer mapContainer;
    private final SerializationService ss;
    private final RecordStore recordStore;

    public IndexingMutationObserver(RecordStore recordStore, SerializationService ss) {
        this.partitionId = recordStore.getPartitionId();
        this.mapContainer = recordStore.getMapContainer();
        this.recordStore = recordStore;
        this.ss = ss;
    }

    @Override
    public void onPutRecord(@Nonnull Data key, @Nonnull R record, Object oldValue, boolean backup) {
        if (!backup) {
            this.saveIndex(key, (Record)record, oldValue, Index.OperationSource.USER);
        }
    }

    @Override
    public void onReplicationPutRecord(@Nonnull Data key, @Nonnull R record, boolean populateIndex) {
        if (populateIndex) {
            this.saveIndex(key, (Record)record, null, Index.OperationSource.SYSTEM);
        }
    }

    @Override
    public void onUpdateRecord(@Nonnull Data key, @Nonnull R record, Object oldValue, Object newValue, boolean backup) {
        if (!backup) {
            this.saveIndex(key, (Record)record, oldValue, Index.OperationSource.USER);
        }
    }

    @Override
    public void onRemoveRecord(@Nonnull Data key, R record, boolean backup) {
        if (!backup) {
            this.removeIndex(key, (Record)record, Index.OperationSource.USER);
        }
    }

    @Override
    public void onEvictRecord(@Nonnull Data key, @Nonnull R record, boolean backup) {
        if (!backup) {
            this.removeIndex(key, (Record)record, Index.OperationSource.USER);
        }
    }

    @Override
    public void onLoadRecord(@Nonnull Data key, @Nonnull R record, boolean backup) {
        if (!backup) {
            this.saveIndex(key, (Record)record, null, Index.OperationSource.USER);
        }
    }

    @Override
    public void onReset() {
        this.clearGlobalIndexes();
    }

    @Override
    public void onClear() {
        this.onReset();
    }

    @Override
    public void onDestroy(boolean isDuringShutdown, boolean internal) {
        this.clearGlobalIndexes();
        this.clearPartitionedIndexes(true);
    }

    private void clearGlobalIndexes() {
        if (!this.mapContainer.shouldUseGlobalIndex()) {
            return;
        }
        IndexRegistry indexRegistry = this.mapContainer.getGlobalIndexRegistry();
        if (indexRegistry.haveAtLeastOneIndex()) {
            this.fullScanLocalDataToClear(indexRegistry);
        }
    }

    private void clearPartitionedIndexes(boolean destroy) {
        IndexRegistry indexRegistry = this.mapContainer.getOrNullPartitionedIndexRegistry(this.partitionId);
        if (indexRegistry == null) {
            return;
        }
        if (destroy) {
            indexRegistry.destroyIndexes();
            return;
        }
        indexRegistry.clearAll();
    }

    private void fullScanLocalDataToClear(IndexRegistry indexRegistry) {
        InternalIndex[] indexesSnapshot = indexRegistry.getIndexes();
        IndexRegistry.beginPartitionUpdate(indexesSnapshot);
        CachedQueryEntry entry = new CachedQueryEntry(this.ss, this.mapContainer.getExtractors());
        this.recordStore.forEach((dataKey, record) -> {
            Object value = Records.getValueOrCachedValue(record, this.ss);
            entry.init(dataKey, value);
            indexRegistry.removeEntry(entry, Index.OperationSource.SYSTEM);
        }, false);
        IndexRegistry.markPartitionAsUnindexed(this.partitionId, indexesSnapshot);
    }

    private void saveIndex(Data dataKey, Record record, Object oldValue, Index.OperationSource operationSource) {
        IndexRegistry indexRegistry = this.mapContainer.getOrCreateIndexRegistry(this.partitionId);
        if (!indexRegistry.haveAtLeastOneIndex()) {
            return;
        }
        QueryableEntry queryableEntry = this.mapContainer.newQueryEntry(this.toBackingKeyFormat(dataKey), Records.getValueOrCachedValue(record, this.ss));
        queryableEntry.setRecord(record);
        indexRegistry.putEntry(queryableEntry, oldValue, operationSource);
    }

    private void removeIndex(Data dataKey, Record record, Index.OperationSource operationSource) {
        IndexRegistry indexRegistry = this.mapContainer.getOrCreateIndexRegistry(this.partitionId);
        if (!indexRegistry.haveAtLeastOneIndex()) {
            return;
        }
        Data backingKey = this.toBackingKeyFormat(dataKey);
        Object valueOrCachedValue = Records.getValueOrCachedValue(record, this.ss);
        indexRegistry.removeEntry(backingKey, valueOrCachedValue, operationSource);
    }

    private Data toBackingKeyFormat(Data key) {
        return this.recordStore.getStorage().toBackingDataKeyFormat(key);
    }
}

