/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.server.Server;
import com.hazelcast.internal.util.EmptyStatement;

public final class OutOfMemoryHandlerHelper {
    private OutOfMemoryHandlerHelper() {
    }

    public static void tryCloseConnections(HazelcastInstance hazelcastInstance) {
        if (hazelcastInstance == null) {
            return;
        }
        HazelcastInstanceImpl factory = (HazelcastInstanceImpl)hazelcastInstance;
        OutOfMemoryHandlerHelper.closeSockets(factory);
    }

    private static void closeSockets(HazelcastInstanceImpl factory) {
        Server server = factory.node.getServer();
        if (server != null) {
            try {
                server.shutdown();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
    }

    public static void tryShutdown(HazelcastInstance hazelcastInstance) {
        if (hazelcastInstance == null) {
            return;
        }
        HazelcastInstanceImpl factory = (HazelcastInstanceImpl)hazelcastInstance;
        OutOfMemoryHandlerHelper.closeSockets(factory);
        try {
            factory.node.shutdown(true);
        }
        catch (Throwable ignored) {
            EmptyStatement.ignore(ignored);
        }
    }
}

