/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.instance.impl.ClusterTopologyIntent;
import com.hazelcast.instance.impl.ClusterTopologyIntentTracker;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeExtension;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.utils.RetryUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class KubernetesTopologyIntentTracker
implements ClusterTopologyIntentTracker {
    private final AtomicReference<ClusterTopologyIntent> clusterTopologyIntent = new AtomicReference<ClusterTopologyIntent>(ClusterTopologyIntent.NOT_IN_MANAGED_CONTEXT);
    private final ExecutorService clusterTopologyExecutor;
    private final ClusterState clusterStateForMissingMembers;
    private final ILogger logger;
    private final Node node;
    private volatile int currentClusterSpecSize = -1;
    private volatile int lastKnownStableClusterSpecSize = -1;
    private volatile int currentClusterSize;
    private volatile boolean enabled;

    public KubernetesTopologyIntentTracker(Node node) {
        this.clusterStateForMissingMembers = node.getProperties().getEnum(ClusterProperty.PERSISTENCE_AUTO_CLUSTER_STATE_STRATEGY, ClusterState.class);
        if (this.clusterStateForMissingMembers != ClusterState.FROZEN && this.clusterStateForMissingMembers != ClusterState.NO_MIGRATION) {
            throw new InvalidConfigurationException("Value of property " + ClusterProperty.PERSISTENCE_AUTO_CLUSTER_STATE_STRATEGY.getName() + " was " + this.clusterStateForMissingMembers + " but should be one of FROZEN, NO_MIGRATION.");
        }
        this.clusterTopologyExecutor = Executors.newSingleThreadExecutor();
        this.logger = node.getLogger(ClusterTopologyIntentTracker.class);
        this.node = node;
    }

    @Override
    public void initialize() {
        this.enabled = true;
    }

    @Override
    public void destroy() {
        this.clusterTopologyExecutor.shutdown();
    }

    @Override
    public void update(int previousSpecifiedReplicas, int updatedSpecifiedReplicas, int previousReadyReplicas, int updatedReadyReplicas, int previousCurrentReplicas, int updatedCurrentReplicas) {
        ClusterTopologyIntent newTopologyIntent;
        int previousClusterSpecSizeValue = this.currentClusterSpecSize;
        this.currentClusterSpecSize = updatedSpecifiedReplicas;
        if (previousSpecifiedReplicas == -1) {
            this.handleInitialUpdate(updatedSpecifiedReplicas, updatedReadyReplicas);
            return;
        }
        ClusterTopologyIntent previous = this.clusterTopologyIntent.get();
        Runnable postUpdateActionOnMaster = null;
        if (updatedSpecifiedReplicas == 0) {
            newTopologyIntent = this.handleShutdownUpdate(previousClusterSpecSizeValue, previous);
        } else if (previousSpecifiedReplicas == updatedSpecifiedReplicas) {
            if (this.ignoreUpdateWhenClusterSpecEqual(previous, updatedReadyReplicas)) {
                return;
            }
            BiTuple<ClusterTopologyIntent, Runnable> t = this.nextIntentWhenClusterSpecEqual(previous, previousReadyReplicas, updatedReadyReplicas, previousCurrentReplicas, updatedCurrentReplicas);
            newTopologyIntent = (ClusterTopologyIntent)((Object)t.element1);
            postUpdateActionOnMaster = (Runnable)t.element2;
        } else {
            newTopologyIntent = ClusterTopologyIntent.SCALING;
            postUpdateActionOnMaster = () -> this.changeClusterState(ClusterState.ACTIVE);
        }
        if (this.clusterTopologyIntent.compareAndSet(previous, newTopologyIntent)) {
            this.onClusterTopologyIntentUpdate(previous, newTopologyIntent, postUpdateActionOnMaster);
        }
    }

    private void handleInitialUpdate(int currentSpecifiedReplicaCount, int readyReplicasCount) {
        if (currentSpecifiedReplicaCount > 0 && (readyReplicasCount == -1 || readyReplicasCount == 0)) {
            this.logger.info("Cluster starting in managed context");
            this.clusterTopologyIntent.set(ClusterTopologyIntent.CLUSTER_START);
        } else {
            this.logger.info("Member starting in managed context");
            this.clusterTopologyIntent.set(ClusterTopologyIntent.IN_MANAGED_CONTEXT_UNKNOWN);
        }
    }

    private ClusterTopologyIntent handleShutdownUpdate(int previousClusterSpecSizeValue, ClusterTopologyIntent previous) {
        if (previousClusterSpecSizeValue > 0) {
            this.lastKnownStableClusterSpecSize = previousClusterSpecSizeValue;
        }
        ClusterTopologyIntent newTopologyIntent = this.nextIntentWhenShuttingDown(previous);
        return newTopologyIntent;
    }

    private void onClusterTopologyIntentUpdate(ClusterTopologyIntent previous, ClusterTopologyIntent newTopologyIntent, @Nullable Runnable actionOnMaster) {
        this.logger.info("Cluster topology intent: " + previous + " -> " + newTopologyIntent);
        this.clusterTopologyExecutor.submit(() -> {
            this.node.getNodeExtension().getInternalHotRestartService().onClusterTopologyIntentChange();
            if (!this.node.isMaster()) {
                return;
            }
            if (actionOnMaster != null) {
                actionOnMaster.run();
            }
        });
    }

    private ClusterTopologyIntent nextIntentWhenShuttingDown(ClusterTopologyIntent previous) {
        return previous == ClusterTopologyIntent.CLUSTER_STABLE_WITH_MISSING_MEMBERS || previous == ClusterTopologyIntent.CLUSTER_SHUTDOWN_WITH_MISSING_MEMBERS ? ClusterTopologyIntent.CLUSTER_SHUTDOWN_WITH_MISSING_MEMBERS : ClusterTopologyIntent.CLUSTER_SHUTDOWN;
    }

    private boolean ignoreUpdateWhenClusterSpecEqual(ClusterTopologyIntent previous, int readyNodesCount) {
        if (readyNodesCount != this.currentClusterSpecSize && (previous == ClusterTopologyIntent.SCALING || previous == ClusterTopologyIntent.IN_MANAGED_CONTEXT_UNKNOWN || previous == ClusterTopologyIntent.CLUSTER_START)) {
            this.logger.info("Ignoring update because readyNodesCount is " + readyNodesCount + ", while spec requires " + this.currentClusterSpecSize + " and previous cluster topology intent is " + previous);
            return true;
        }
        return false;
    }

    private BiTuple<ClusterTopologyIntent, Runnable> nextIntentWhenClusterSpecEqual(ClusterTopologyIntent previous, int previousReadyReplicas, int updatedReadyReplicas, int previousCurrentReplicas, int updatedCurrentReplicas) {
        ClusterTopologyIntent next = previous;
        Runnable action = null;
        if (updatedReadyReplicas == this.currentClusterSpecSize) {
            if (updatedCurrentReplicas < previousCurrentReplicas) {
                if (updatedReadyReplicas == previousReadyReplicas) {
                    next = ClusterTopologyIntent.CLUSTER_STABLE_WITH_MISSING_MEMBERS;
                } else if (updatedReadyReplicas > previousReadyReplicas) {
                    next = ClusterTopologyIntent.CLUSTER_STABLE_WITH_MISSING_MEMBERS;
                    action = this.clusterStateForMissingMembers == ClusterState.NO_MIGRATION ? () -> this.changeClusterState(ClusterState.ACTIVE) : null;
                }
            } else if (previous != ClusterTopologyIntent.CLUSTER_STABLE) {
                next = ClusterTopologyIntent.CLUSTER_STABLE;
                action = () -> {
                    if (this.getClusterService().getClusterState() != ClusterState.ACTIVE) {
                        this.tryExecuteOrSetDeferredClusterStateChange(ClusterState.ACTIVE);
                    } else if (!this.getPartitionService().isPartitionTableSafe()) {
                        this.getPartitionService().getMigrationManager().triggerControlTask();
                    }
                };
            }
        } else if (previous == ClusterTopologyIntent.CLUSTER_STABLE && updatedCurrentReplicas < this.currentClusterSpecSize) {
            next = ClusterTopologyIntent.CLUSTER_STABLE_WITH_MISSING_MEMBERS;
        }
        return BiTuple.of(next, action);
    }

    @Override
    public ClusterTopologyIntent getClusterTopologyIntent() {
        return this.clusterTopologyIntent.get();
    }

    @Override
    public void initializeClusterTopologyIntent(ClusterTopologyIntent clusterTopologyIntent) {
        ClusterTopologyIntent current = this.clusterTopologyIntent.get();
        this.logger.info("Current node cluster topology intent is " + current);
        if (current == ClusterTopologyIntent.IN_MANAGED_CONTEXT_UNKNOWN) {
            this.logger.info("Initializing this node's cluster topology to " + clusterTopologyIntent);
            this.clusterTopologyIntent.set(clusterTopologyIntent);
        }
    }

    @Override
    public void shutdownWithIntent(ClusterTopologyIntent shutdownIntent) {
        if (shutdownIntent == ClusterTopologyIntent.CLUSTER_STABLE || shutdownIntent == ClusterTopologyIntent.CLUSTER_STABLE_WITH_MISSING_MEMBERS) {
            try {
                this.waitCallableWithShutdownTimeout(() -> this.getPartitionService().isPartitionTableSafe());
                this.changeClusterState(this.clusterStateForMissingMembers);
            }
            catch (Throwable t) {
                this.logger.warning("Could not switch to transient " + this.clusterStateForMissingMembers + " state while clustershutdown intent was " + shutdownIntent, t);
            }
        } else if (shutdownIntent == ClusterTopologyIntent.CLUSTER_SHUTDOWN) {
            this.clusterWideShutdown();
        } else if (shutdownIntent == ClusterTopologyIntent.CLUSTER_SHUTDOWN_WITH_MISSING_MEMBERS) {
            long remainingNanosForShutdown = this.waitForMissingMember();
            this.clusterWideShutdownWithMissingMember(shutdownIntent, remainingNanosForShutdown);
        }
    }

    private void clusterWideShutdownWithMissingMember(ClusterTopologyIntent shutdownIntent, long remainingNanosForShutdown) {
        try {
            do {
                this.logger.info("Waiting for partition table to be healthy");
                if (!this.getPartitionService().isPartitionTableSafe()) {
                    this.logger.warning("Switching to ACTIVE state in order to allow for partition table to be healthy");
                    this.changeClusterState(ClusterState.ACTIVE);
                    this.waitCallableWithShutdownTimeout(() -> this.getPartitionService().isPartitionTableSafe());
                }
                this.changeClusterState(ClusterState.PASSIVE);
            } while (!this.getPartitionService().isPartitionTableSafe());
        }
        catch (Throwable t) {
            this.logger.warning("Could not switch to transient PASSIVE state while clustershutdown intent was " + shutdownIntent, t);
        }
        try {
            this.getNodeExtension().getInternalHotRestartService().waitPartitionReplicaSyncOnCluster(remainingNanosForShutdown, TimeUnit.NANOSECONDS);
        }
        catch (IllegalStateException e) {
            this.logger.severe("Failure while waiting for partition replica sync before shutdown", e);
        }
    }

    private void clusterWideShutdown() {
        Instant start = Instant.now();
        this.logger.info("cluster-wide-shutdown, Starting");
        try {
            this.changeClusterState(ClusterState.PASSIVE);
        }
        catch (Throwable t) {
            this.logger.warning("cluster-wide-shutdown, Could not switch to transient PASSIVE state while cluster shutdown intent was CLUSTER_SHUTDOWN.", t);
        }
        long timeoutNanos = this.node.getProperties().getNanos(ClusterProperty.CLUSTER_SHUTDOWN_TIMEOUT_SECONDS);
        this.logger.info("cluster-wide-shutdown, Starting partition replica sync, Timeout(s): " + this.node.getProperties().getSeconds(ClusterProperty.CLUSTER_SHUTDOWN_TIMEOUT_SECONDS));
        Instant partitionSyncStart = Instant.now();
        try {
            this.getNodeExtension().getInternalHotRestartService().waitPartitionReplicaSyncOnCluster(timeoutNanos, TimeUnit.NANOSECONDS);
            this.logger.info("cluster-wide-shutdown, Completed partition replica sync, Took(ms): " + Duration.between(partitionSyncStart, Instant.now()).toMillis());
        }
        catch (IllegalStateException e) {
            this.logger.severe("cluster-wide-shutdown, Failure while waiting for partition replica sync before shutdown, Took(ms): " + Duration.between(partitionSyncStart, Instant.now()).toMillis(), e);
        }
        this.logger.info("cluster-wide-shutdown, Completed, Took(ms): " + Duration.between(start, Instant.now()).toMillis());
    }

    long waitForMissingMember() {
        long nanosRemaining = this.node.getProperties().getNanos(ClusterProperty.CLUSTER_SHUTDOWN_TIMEOUT_SECONDS);
        if (this.getClusterService().getClusterState() == ClusterState.PASSIVE) {
            return nanosRemaining;
        }
        if (this.lastKnownStableClusterSpecSize == this.currentClusterSize) {
            return nanosRemaining;
        }
        this.logger.info("Waiting for missing members: lastKnownStableClusterSpecSize: " + this.lastKnownStableClusterSpecSize + ", currentClusterSize " + this.currentClusterSize);
        return this.waitCallableWithTimeout(() -> this.lastKnownStableClusterSpecSize == this.currentClusterSize, nanosRemaining);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getCurrentSpecifiedReplicaCount() {
        return this.currentClusterSpecSize;
    }

    @Override
    public void onMembershipChange() {
        this.currentClusterSize = this.getClusterService().getSize();
    }

    private void tryExecuteOrSetDeferredClusterStateChange(ClusterState newClusterState) {
        if (!this.getNodeExtension().getInternalHotRestartService().trySetDeferredClusterState(newClusterState)) {
            this.changeClusterState(newClusterState);
        }
    }

    private long waitCallableWithShutdownTimeout(Callable<Boolean> callable) {
        return this.waitCallableWithTimeout(callable, this.node.getProperties().getNanos(ClusterProperty.CLUSTER_SHUTDOWN_TIMEOUT_SECONDS));
    }

    long waitCallableWithTimeout(Callable<Boolean> callable, long timeoutNanos) {
        boolean callableCompleted;
        long start = System.nanoTime();
        do {
            try {
                callableCompleted = callable.call();
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while (!callableCompleted && (timeoutNanos -= System.nanoTime() - start) > 0L);
        return timeoutNanos;
    }

    private void changeClusterState(ClusterState newClusterState) {
        RetryUtils.retry(() -> {
            this.getClusterService().changeClusterState(newClusterState, true);
            return null;
        }, 3);
    }

    private NodeExtension getNodeExtension() {
        return this.node.getNodeExtension();
    }

    private InternalPartitionServiceImpl getPartitionService() {
        return this.node.partitionService;
    }

    private ClusterServiceImpl getClusterService() {
        return this.node.getClusterService();
    }
}

