/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftServiceSerializerConstants;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class RaftGroupId
implements CPGroupId,
IdentifiedDataSerializable,
Serializable {
    private static final long serialVersionUID = -2381010126931378167L;
    private String name;
    private long seed;
    private long groupId;

    public RaftGroupId() {
    }

    public RaftGroupId(String name, long seed, long groupId) {
        assert (name != null);
        this.name = name;
        this.seed = seed;
        this.groupId = groupId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public long getSeed() {
        return this.seed;
    }

    @Override
    public long getId() {
        return this.groupId;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeLong(this.seed);
        out.writeLong(this.groupId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.seed = in.readLong();
        this.groupId = in.readLong();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.name);
        out.writeLong(this.seed);
        out.writeLong(this.groupId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.name = in.readUTF();
        this.seed = in.readLong();
        this.groupId = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return RaftServiceSerializerConstants.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaftGroupId that = (RaftGroupId)o;
        if (this.seed != that.seed) {
            return false;
        }
        if (this.groupId != that.groupId) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (int)(this.seed ^ this.seed >>> 32);
        result = 31 * result + (int)(this.groupId ^ this.groupId >>> 32);
        return result;
    }

    public String toString() {
        return "CPGroupId{name='" + this.name + "', seed=" + this.seed + ", groupId=" + this.groupId + "}";
    }
}

