/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.security.AccessControlServiceConfig;
import com.hazelcast.config.security.AuthenticationConfig;
import com.hazelcast.config.security.CredentialsIdentityConfig;
import com.hazelcast.config.security.DefaultAuthenticationConfig;
import com.hazelcast.config.security.IdentityConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.KerberosAuthenticationConfig;
import com.hazelcast.config.security.KerberosIdentityConfig;
import com.hazelcast.config.security.LdapAuthenticationConfig;
import com.hazelcast.config.security.SimpleAuthenticationConfig;
import com.hazelcast.config.security.TlsAuthenticationConfig;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.config.security.UsernamePasswordIdentityConfig;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.ICredentialsFactory;
import java.util.Objects;

public class RealmConfig {
    public static final RealmConfig DEFAULT_REALM = new RealmConfig();
    private AuthenticationConfig authenticationConfig = DefaultAuthenticationConfig.INSTANCE;
    private IdentityConfig identityConfig;
    private AccessControlServiceConfig accessControlServiceConfig;

    public JaasAuthenticationConfig getJaasAuthenticationConfig() {
        return this.getIfType(this.authenticationConfig, JaasAuthenticationConfig.class);
    }

    public RealmConfig setJaasAuthenticationConfig(JaasAuthenticationConfig authenticationConfig) {
        this.authenticationConfig = Objects.requireNonNull(authenticationConfig, "Authentication config can't be null");
        return this;
    }

    public TlsAuthenticationConfig getTlsAuthenticationConfig() {
        return this.getIfType(this.authenticationConfig, TlsAuthenticationConfig.class);
    }

    public RealmConfig setTlsAuthenticationConfig(TlsAuthenticationConfig authenticationConfig) {
        this.authenticationConfig = Objects.requireNonNull(authenticationConfig, "Authentication config can't be null");
        return this;
    }

    public LdapAuthenticationConfig getLdapAuthenticationConfig() {
        return this.getIfType(this.authenticationConfig, LdapAuthenticationConfig.class);
    }

    public RealmConfig setLdapAuthenticationConfig(LdapAuthenticationConfig authenticationConfig) {
        this.authenticationConfig = Objects.requireNonNull(authenticationConfig, "Authentication config can't be null");
        return this;
    }

    public KerberosAuthenticationConfig getKerberosAuthenticationConfig() {
        return this.getIfType(this.authenticationConfig, KerberosAuthenticationConfig.class);
    }

    public RealmConfig setKerberosAuthenticationConfig(KerberosAuthenticationConfig authenticationConfig) {
        this.authenticationConfig = Objects.requireNonNull(authenticationConfig, "Authentication config can't be null");
        return this;
    }

    public SimpleAuthenticationConfig getSimpleAuthenticationConfig() {
        return this.getIfType(this.authenticationConfig, SimpleAuthenticationConfig.class);
    }

    public RealmConfig setSimpleAuthenticationConfig(SimpleAuthenticationConfig authenticationConfig) {
        this.authenticationConfig = Objects.requireNonNull(authenticationConfig, "Authentication config can't be null");
        return this;
    }

    public UsernamePasswordIdentityConfig getUsernamePasswordIdentityConfig() {
        return this.getIfType(this.identityConfig, UsernamePasswordIdentityConfig.class);
    }

    public RealmConfig setUsernamePasswordIdentityConfig(UsernamePasswordIdentityConfig identityConfig) {
        this.identityConfig = identityConfig;
        return this;
    }

    public RealmConfig setUsernamePasswordIdentityConfig(String username, String password) {
        this.identityConfig = new UsernamePasswordIdentityConfig(username, password);
        return this;
    }

    public TokenIdentityConfig getTokenIdentityConfig() {
        return this.getIfType(this.identityConfig, TokenIdentityConfig.class);
    }

    public RealmConfig setTokenIdentityConfig(TokenIdentityConfig identityConfig) {
        this.identityConfig = identityConfig;
        return this;
    }

    public CredentialsFactoryConfig getCredentialsFactoryConfig() {
        return this.getIfType(this.identityConfig, CredentialsFactoryConfig.class);
    }

    public RealmConfig setCredentialsFactoryConfig(CredentialsFactoryConfig identityConfig) {
        this.identityConfig = identityConfig;
        return this;
    }

    public CredentialsIdentityConfig getCredentialsIdentityConfig() {
        return this.getIfType(this.identityConfig, CredentialsIdentityConfig.class);
    }

    public RealmConfig setCredentialsIdentityConfig(CredentialsIdentityConfig identity) {
        this.identityConfig = identity;
        return this;
    }

    public RealmConfig setCredentials(Credentials credentials) {
        this.identityConfig = new CredentialsIdentityConfig(credentials);
        return this;
    }

    public KerberosIdentityConfig getKerberosIdentityConfig() {
        return this.getIfType(this.identityConfig, KerberosIdentityConfig.class);
    }

    public RealmConfig setKerberosIdentityConfig(KerberosIdentityConfig identityConfig) {
        this.identityConfig = identityConfig;
        return this;
    }

    public AccessControlServiceConfig getAccessControlServiceConfig() {
        return this.accessControlServiceConfig;
    }

    public RealmConfig setAccessControlServiceConfig(AccessControlServiceConfig accessControlServiceConfig) {
        this.accessControlServiceConfig = accessControlServiceConfig;
        return this;
    }

    public boolean isAuthenticationConfigured() {
        return this.authenticationConfig != null && this.authenticationConfig != DefaultAuthenticationConfig.INSTANCE;
    }

    public boolean isIdentityConfigured() {
        return this.identityConfig != null;
    }

    public LoginModuleConfig[] asLoginModuleConfigs() {
        if (this.authenticationConfig == null) {
            return null;
        }
        return this.authenticationConfig.asLoginModuleConfigs();
    }

    public ICredentialsFactory asCredentialsFactory() {
        return this.identityConfig != null ? this.identityConfig.asCredentialsFactory(null) : null;
    }

    public int hashCode() {
        return Objects.hash(this.authenticationConfig, this.identityConfig, this.accessControlServiceConfig);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RealmConfig other = (RealmConfig)obj;
        return Objects.equals(this.authenticationConfig, other.authenticationConfig) && Objects.equals(this.identityConfig, other.identityConfig) && Objects.equals(this.accessControlServiceConfig, other.accessControlServiceConfig);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RealmConfig [authenticationConfig=").append(this.authenticationConfig).append(", identityConfig=").append(this.identityConfig).append(", accessControlServiceConfig=").append(this.accessControlServiceConfig).append("]");
        return builder.toString();
    }

    private <T> T getIfType(Object inst, Class<T> clazz) {
        return clazz.isInstance(inst) ? (T)clazz.cast(inst) : null;
    }
}

