/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapReplaceAllCodec;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapPartitionMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.map.impl.MapEntryReplacingEntryProcessor;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.query.Predicates;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import java.security.Permission;
import java.util.function.BiFunction;

public class MapReplaceAllMessageTask
extends AbstractMapPartitionMessageTask<MapReplaceAllCodec.RequestParameters> {
    private BiFunction function;

    public MapReplaceAllMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
        this.setNamespaceAware();
    }

    @Override
    protected Operation prepareOperation() {
        OperationFactory operationFactory = this.createOperationFactory();
        return operationFactory.createOperation();
    }

    protected OperationFactory createOperationFactory() {
        MapOperationProvider operationProvider = this.getMapOperationProvider(((MapReplaceAllCodec.RequestParameters)this.parameters).name);
        return operationProvider.createPartitionWideEntryWithPredicateOperationFactory(((MapReplaceAllCodec.RequestParameters)this.parameters).name, new MapEntryReplacingEntryProcessor(this.function), Predicates.alwaysTrue());
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected MapReplaceAllCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        MapReplaceAllCodec.RequestParameters parameters = MapReplaceAllCodec.decodeRequest(clientMessage);
        this.function = (BiFunction)this.serializationService.toObject(parameters.function);
        return parameters;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapReplaceAllCodec.encodeResponse();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.getDistributedObjectName(), "put");
    }

    @Override
    public String getMethodName() {
        return "replaceAll";
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapReplaceAllCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.parameters};
    }
}

