/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.dynamicconfig;

import com.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.SplitBrainProtectionListenerConfig;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.namespace.impl.NodeEngineThreadLocalContext;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionListener;
import java.util.EventListener;
import javax.annotation.Nullable;

public class ListenerConfigHolder {
    private final String className;
    private final Data listenerImplementation;
    private final boolean includeValue;
    private final boolean local;
    private final ListenerConfigType listenerType;

    public ListenerConfigHolder(int listenerType, Data listenerImplementation, String className, boolean includeValue, boolean local) {
        this(ListenerConfigType.fromType(listenerType), listenerImplementation, className, includeValue, local);
    }

    public ListenerConfigHolder(ListenerConfigType listenerType, Data listenerImplementation, String className, boolean includeValue, boolean local) {
        this.listenerType = listenerType;
        this.className = className;
        this.listenerImplementation = listenerImplementation;
        this.includeValue = includeValue;
        this.local = local;
    }

    public String getClassName() {
        return this.className;
    }

    public Data getListenerImplementation() {
        return this.listenerImplementation;
    }

    public int getListenerType() {
        return this.listenerType.getType();
    }

    public boolean isIncludeValue() {
        return this.includeValue;
    }

    public boolean isLocal() {
        return this.local;
    }

    public <T extends ListenerConfig> T asListenerConfig(SerializationService serializationService, @Nullable String namespace) {
        this.validate();
        ListenerConfig listenerConfig = null;
        if (this.className != null) {
            switch (this.listenerType) {
                case GENERIC: {
                    listenerConfig = new ListenerConfig(this.className);
                    break;
                }
                case ITEM: {
                    listenerConfig = new ItemListenerConfig(this.className, this.includeValue);
                    break;
                }
                case ENTRY: {
                    listenerConfig = new EntryListenerConfig(this.className, this.local, this.includeValue);
                    break;
                }
                case SPLIT_BRAIN_PROTECTION: {
                    listenerConfig = new SplitBrainProtectionListenerConfig(this.className);
                    break;
                }
                case CACHE_PARTITION_LOST: {
                    listenerConfig = new CachePartitionLostListenerConfig(this.className);
                    break;
                }
                case MAP_PARTITION_LOST: {
                    listenerConfig = new MapPartitionLostListenerConfig(this.className);
                    break;
                }
            }
        } else {
            NodeEngine engine = NodeEngineThreadLocalContext.getNodeEngineThreadLocalContextOrNull();
            EventListener eventListener = engine == null ? (EventListener)serializationService.toObject(this.listenerImplementation) : NamespaceUtil.callWithNamespace(namespace, () -> (EventListener)serializationService.toObject(this.listenerImplementation));
            switch (this.listenerType) {
                case GENERIC: {
                    listenerConfig = new ListenerConfig(eventListener);
                    break;
                }
                case ITEM: {
                    listenerConfig = new ItemListenerConfig((ItemListener)eventListener, this.includeValue);
                    break;
                }
                case ENTRY: {
                    listenerConfig = new EntryListenerConfig((MapListener)eventListener, this.local, this.includeValue);
                    break;
                }
                case SPLIT_BRAIN_PROTECTION: {
                    listenerConfig = new SplitBrainProtectionListenerConfig((SplitBrainProtectionListener)eventListener);
                    break;
                }
                case CACHE_PARTITION_LOST: {
                    listenerConfig = new CachePartitionLostListenerConfig((CachePartitionLostListener)eventListener);
                    break;
                }
                case MAP_PARTITION_LOST: {
                    listenerConfig = new MapPartitionLostListenerConfig((MapPartitionLostListener)eventListener);
                    break;
                }
            }
        }
        return (T)listenerConfig;
    }

    void validate() {
        if (this.className == null && this.listenerImplementation == null) {
            throw new IllegalArgumentException("Either class name or listener implementation must be not null");
        }
    }

    public static ListenerConfigHolder of(ListenerConfig config, SerializationService serializationService, @Nullable String namespace) {
        ListenerConfigType listenerType = ListenerConfigHolder.listenerTypeOf(config);
        Data implementationData = null;
        if (config.getImplementation() != null) {
            NodeEngine engine = NodeEngineThreadLocalContext.getNodeEngineThreadLocalContextOrNull();
            implementationData = engine != null ? NamespaceUtil.callWithNamespace(engine, namespace, () -> serializationService.toData(config.getImplementation())) : (Data)serializationService.toData(config.getImplementation());
        }
        return new ListenerConfigHolder(listenerType, implementationData, config.getClassName(), config.isIncludeValue(), config.isLocal());
    }

    public static ListenerConfigHolder of(ListenerConfig config, SerializationService serializationService) {
        return ListenerConfigHolder.of(config, serializationService, null);
    }

    private static ListenerConfigType listenerTypeOf(ListenerConfig config) {
        if (config instanceof ItemListenerConfig) {
            return ListenerConfigType.ITEM;
        }
        if (config instanceof CachePartitionLostListenerConfig) {
            return ListenerConfigType.CACHE_PARTITION_LOST;
        }
        if (config instanceof SplitBrainProtectionListenerConfig) {
            return ListenerConfigType.SPLIT_BRAIN_PROTECTION;
        }
        if (config instanceof EntryListenerConfig) {
            return ListenerConfigType.ENTRY;
        }
        if (config instanceof MapPartitionLostListenerConfig) {
            return ListenerConfigType.MAP_PARTITION_LOST;
        }
        return ListenerConfigType.GENERIC;
    }

    public static enum ListenerConfigType {
        GENERIC(0),
        ITEM(1),
        ENTRY(2),
        SPLIT_BRAIN_PROTECTION(3),
        CACHE_PARTITION_LOST(4),
        MAP_PARTITION_LOST(5);

        private static final ListenerConfigType[] CACHED_VALUES;
        private final int type;

        private ListenerConfigType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static ListenerConfigType fromType(int type) {
            for (ListenerConfigType configType : CACHED_VALUES) {
                if (configType.type != type) continue;
                return configType;
            }
            throw new HazelcastSerializationException("Unrecognized listener type " + type);
        }

        static {
            CACHED_VALUES = ListenerConfigType.values();
        }
    }
}

