/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.util.Objects;
import org.apache.nifi.nar.NarManifest;
import org.apache.nifi.nar.NarSource;

public class NarPersistenceContext {
    private final NarManifest manifest;
    private final NarSource source;
    private final String sourceIdentifier;
    private final boolean clusterCoordinator;

    private NarPersistenceContext(Builder builder) {
        this.manifest = Objects.requireNonNull(builder.manifest, "NAR Manifest is required");
        this.source = Objects.requireNonNull(builder.source, "NAR Source is required");
        this.sourceIdentifier = Objects.requireNonNull(builder.sourceIdentifier, "Source Identifier is required");
        this.clusterCoordinator = builder.clusterCoordinator;
    }

    public NarManifest getManifest() {
        return this.manifest;
    }

    public NarSource getSource() {
        return this.source;
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public boolean isClusterCoordinator() {
        return this.clusterCoordinator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private NarManifest manifest;
        private NarSource source;
        private String sourceIdentifier;
        private boolean clusterCoordinator;

        public Builder manifest(NarManifest manifest) {
            this.manifest = manifest;
            return this;
        }

        public Builder source(NarSource source) {
            this.source = source;
            return this;
        }

        public Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public Builder clusterCoordinator(boolean clusterCoordinator) {
            this.clusterCoordinator = clusterCoordinator;
            return this;
        }

        public NarPersistenceContext build() {
            return new NarPersistenceContext(this);
        }
    }
}

