/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.flow.git;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.nifi.registry.provider.flow.git.Flow;

class Bucket {
    private final String bucketId;
    private String bucketDirName;
    private Map<String, Flow> flows = new HashMap<String, Flow>();

    public Bucket(String bucketId) {
        this.bucketId = bucketId;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getBucketDirName() {
        return this.bucketDirName;
    }

    public void setBucketDirName(String bucketDirName) {
        this.bucketDirName = bucketDirName;
    }

    public Flow getFlowOrCreate(String flowId) {
        return this.flows.computeIfAbsent(flowId, k -> new Flow(flowId));
    }

    public Optional<Flow> getFlow(String flowId) {
        return Optional.ofNullable(this.flows.get(flowId));
    }

    public void removeFlow(String flowId) {
        this.flows.remove(flowId);
    }

    public boolean isEmpty() {
        return this.flows.isEmpty();
    }

    Map<String, Flow> getFlows() {
        return this.flows;
    }

    Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("layoutVer", 1);
        map.put("bucketId", this.bucketId);
        map.put("flows", this.flows.keySet().stream().collect(Collectors.toMap(k -> k, k -> this.flows.get(k).serialize())));
        return map;
    }
}

