/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.context.ExternalContext;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.DefaultFacesConfigResourceProvider;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.FacesConfigResourceProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.util.lang.ClassUtils;

public class DefaultFacesConfigResourceProviderFactory
extends FacesConfigResourceProviderFactory {
    public static final String FACES_CONFIG_PROVIDER = FacesConfigResourceProvider.class.getName();
    public static final String FACES_CONFIG_PROVIDER_LIST = FacesConfigResourceProvider.class.getName() + ".LIST";

    private Logger getLogger() {
        return Logger.getLogger(DefaultFacesConfigResourceProviderFactory.class.getName());
    }

    @Override
    public FacesConfigResourceProvider createFacesConfigResourceProvider(ExternalContext externalContext) {
        FacesConfigResourceProvider instance = null;
        try {
            instance = this.resolveFacesConfigResourceProviderFromService(externalContext);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        return instance;
    }

    private FacesConfigResourceProvider resolveFacesConfigResourceProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException {
        List<String> classList = (List<String>)externalContext.getApplicationMap().get(FACES_CONFIG_PROVIDER_LIST);
        if (classList == null) {
            classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(FACES_CONFIG_PROVIDER);
            externalContext.getApplicationMap().put(FACES_CONFIG_PROVIDER_LIST, classList);
        }
        return ClassUtils.buildApplicationObject(FacesConfigResourceProvider.class, classList, new DefaultFacesConfigResourceProvider());
    }
}

