/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.client.StageStats;
import java.util.Objects;
import java.util.OptionalDouble;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StatementStats {
    private final String state;
    private final boolean queued;
    private final boolean scheduled;
    private final int nodes;
    private final int totalSplits;
    private final int queuedSplits;
    private final int runningSplits;
    private final int completedSplits;
    private final long cpuTimeMillis;
    private final long wallTimeMillis;
    private final long queuedTimeMillis;
    private final long elapsedTimeMillis;
    private final long processedRows;
    private final long processedBytes;
    private final long physicalInputBytes;
    private final long peakMemoryBytes;
    private final long spilledBytes;
    private final StageStats rootStage;

    @JsonCreator
    public StatementStats(@JsonProperty(value="state") String state, @JsonProperty(value="queued") boolean queued, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="nodes") int nodes, @JsonProperty(value="totalSplits") int totalSplits, @JsonProperty(value="queuedSplits") int queuedSplits, @JsonProperty(value="runningSplits") int runningSplits, @JsonProperty(value="completedSplits") int completedSplits, @JsonProperty(value="cpuTimeMillis") long cpuTimeMillis, @JsonProperty(value="wallTimeMillis") long wallTimeMillis, @JsonProperty(value="queuedTimeMillis") long queuedTimeMillis, @JsonProperty(value="elapsedTimeMillis") long elapsedTimeMillis, @JsonProperty(value="processedRows") long processedRows, @JsonProperty(value="processedBytes") long processedBytes, @JsonProperty(value="physicalInputBytes") long physicalInputBytes, @JsonProperty(value="peakMemoryBytes") long peakMemoryBytes, @JsonProperty(value="spilledBytes") long spilledBytes, @JsonProperty(value="rootStage") StageStats rootStage) {
        this.state = Objects.requireNonNull(state, "state is null");
        this.queued = queued;
        this.scheduled = scheduled;
        this.nodes = nodes;
        this.totalSplits = totalSplits;
        this.queuedSplits = queuedSplits;
        this.runningSplits = runningSplits;
        this.completedSplits = completedSplits;
        this.cpuTimeMillis = cpuTimeMillis;
        this.wallTimeMillis = wallTimeMillis;
        this.queuedTimeMillis = queuedTimeMillis;
        this.elapsedTimeMillis = elapsedTimeMillis;
        this.processedRows = processedRows;
        this.processedBytes = processedBytes;
        this.physicalInputBytes = physicalInputBytes;
        this.peakMemoryBytes = peakMemoryBytes;
        this.spilledBytes = spilledBytes;
        this.rootStage = rootStage;
    }

    @JsonProperty
    public String getState() {
        return this.state;
    }

    @JsonProperty
    public boolean isQueued() {
        return this.queued;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public int getNodes() {
        return this.nodes;
    }

    @JsonProperty
    public int getTotalSplits() {
        return this.totalSplits;
    }

    @JsonProperty
    public int getQueuedSplits() {
        return this.queuedSplits;
    }

    @JsonProperty
    public int getRunningSplits() {
        return this.runningSplits;
    }

    @JsonProperty
    public int getCompletedSplits() {
        return this.completedSplits;
    }

    @JsonProperty
    public long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    @JsonProperty
    public long getWallTimeMillis() {
        return this.wallTimeMillis;
    }

    @JsonProperty
    public long getQueuedTimeMillis() {
        return this.queuedTimeMillis;
    }

    @JsonProperty
    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    @JsonProperty
    public long getProcessedRows() {
        return this.processedRows;
    }

    @JsonProperty
    public long getProcessedBytes() {
        return this.processedBytes;
    }

    @JsonProperty
    public long getPhysicalInputBytes() {
        return this.physicalInputBytes;
    }

    @JsonProperty
    public long getPeakMemoryBytes() {
        return this.peakMemoryBytes;
    }

    @Nullable
    @JsonProperty
    public StageStats getRootStage() {
        return this.rootStage;
    }

    @JsonProperty
    public OptionalDouble getProgressPercentage() {
        if (!this.scheduled || this.totalSplits == 0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Math.min(100.0, (double)this.completedSplits * 100.0 / (double)this.totalSplits));
    }

    @JsonProperty
    public long getSpilledBytes() {
        return this.spilledBytes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).add("queued", this.queued).add("scheduled", this.scheduled).add("nodes", this.nodes).add("totalSplits", this.totalSplits).add("queuedSplits", this.queuedSplits).add("runningSplits", this.runningSplits).add("completedSplits", this.completedSplits).add("cpuTimeMillis", this.cpuTimeMillis).add("wallTimeMillis", this.wallTimeMillis).add("queuedTimeMillis", this.queuedTimeMillis).add("elapsedTimeMillis", this.elapsedTimeMillis).add("processedRows", this.processedRows).add("processedBytes", this.processedBytes).add("physicalInputBytes", this.physicalInputBytes).add("peakMemoryBytes", this.peakMemoryBytes).add("spilledBytes", this.spilledBytes).add("rootStage", (Object)this.rootStage).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String state;
        private boolean queued;
        private boolean scheduled;
        private int nodes;
        private int totalSplits;
        private int queuedSplits;
        private int runningSplits;
        private int completedSplits;
        private long cpuTimeMillis;
        private long wallTimeMillis;
        private long queuedTimeMillis;
        private long elapsedTimeMillis;
        private long processedRows;
        private long processedBytes;
        private long physicalInputBytes;
        private long peakMemoryBytes;
        private long spilledBytes;
        private StageStats rootStage;

        private Builder() {
        }

        public Builder setState(String state) {
            this.state = Objects.requireNonNull(state, "state is null");
            return this;
        }

        public Builder setNodes(int nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder setQueued(boolean queued) {
            this.queued = queued;
            return this;
        }

        public Builder setScheduled(boolean scheduled) {
            this.scheduled = scheduled;
            return this;
        }

        public Builder setTotalSplits(int totalSplits) {
            this.totalSplits = totalSplits;
            return this;
        }

        public Builder setQueuedSplits(int queuedSplits) {
            this.queuedSplits = queuedSplits;
            return this;
        }

        public Builder setRunningSplits(int runningSplits) {
            this.runningSplits = runningSplits;
            return this;
        }

        public Builder setCompletedSplits(int completedSplits) {
            this.completedSplits = completedSplits;
            return this;
        }

        public Builder setCpuTimeMillis(long cpuTimeMillis) {
            this.cpuTimeMillis = cpuTimeMillis;
            return this;
        }

        public Builder setWallTimeMillis(long wallTimeMillis) {
            this.wallTimeMillis = wallTimeMillis;
            return this;
        }

        public Builder setQueuedTimeMillis(long queuedTimeMillis) {
            this.queuedTimeMillis = queuedTimeMillis;
            return this;
        }

        public Builder setElapsedTimeMillis(long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
            return this;
        }

        public Builder setProcessedRows(long processedRows) {
            this.processedRows = processedRows;
            return this;
        }

        public Builder setProcessedBytes(long processedBytes) {
            this.processedBytes = processedBytes;
            return this;
        }

        public Builder setPhysicalInputBytes(long physicalInputBytes) {
            this.physicalInputBytes = physicalInputBytes;
            return this;
        }

        public Builder setPeakMemoryBytes(long peakMemoryBytes) {
            this.peakMemoryBytes = peakMemoryBytes;
            return this;
        }

        public Builder setSpilledBytes(long spilledBytes) {
            this.spilledBytes = spilledBytes;
            return this;
        }

        public Builder setRootStage(StageStats rootStage) {
            this.rootStage = rootStage;
            return this;
        }

        public StatementStats build() {
            return new StatementStats(this.state, this.queued, this.scheduled, this.nodes, this.totalSplits, this.queuedSplits, this.runningSplits, this.completedSplits, this.cpuTimeMillis, this.wallTimeMillis, this.queuedTimeMillis, this.elapsedTimeMillis, this.processedRows, this.processedBytes, this.physicalInputBytes, this.peakMemoryBytes, this.spilledBytes, this.rootStage);
        }
    }
}

