/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.kyuubi.client.IRestClient;
import org.apache.kyuubi.client.KyuubiRestClient;
import org.apache.kyuubi.client.api.v1.dto.ExecPoolStatistic;
import org.apache.kyuubi.client.api.v1.dto.GetColumnsRequest;
import org.apache.kyuubi.client.api.v1.dto.GetCrossReferenceRequest;
import org.apache.kyuubi.client.api.v1.dto.GetFunctionsRequest;
import org.apache.kyuubi.client.api.v1.dto.GetPrimaryKeysRequest;
import org.apache.kyuubi.client.api.v1.dto.GetSchemasRequest;
import org.apache.kyuubi.client.api.v1.dto.GetTablesRequest;
import org.apache.kyuubi.client.api.v1.dto.InfoDetail;
import org.apache.kyuubi.client.api.v1.dto.KyuubiSessionEvent;
import org.apache.kyuubi.client.api.v1.dto.OperationHandle;
import org.apache.kyuubi.client.api.v1.dto.SessionData;
import org.apache.kyuubi.client.api.v1.dto.SessionHandle;
import org.apache.kyuubi.client.api.v1.dto.SessionOpenCount;
import org.apache.kyuubi.client.api.v1.dto.SessionOpenRequest;
import org.apache.kyuubi.client.api.v1.dto.StatementRequest;
import org.apache.kyuubi.client.util.JsonUtils;

public class SessionRestApi {
    private KyuubiRestClient client;
    private static final String API_BASE_PATH = "sessions";

    private SessionRestApi() {
    }

    public SessionRestApi(KyuubiRestClient client) {
        this.client = client;
    }

    public List<SessionData> listSessions() {
        SessionData[] result = this.getClient().get(API_BASE_PATH, new HashMap<String, Object>(), SessionData[].class, this.client.getAuthHeader());
        return Arrays.asList(result);
    }

    public SessionHandle openSession(SessionOpenRequest sessionOpenRequest) {
        return this.getClient().post(API_BASE_PATH, JsonUtils.toJson(sessionOpenRequest), SessionHandle.class, this.client.getAuthHeader());
    }

    public String closeSession(String sessionHandleStr) {
        String path = String.format("%s/%s", API_BASE_PATH, sessionHandleStr);
        return this.getClient().delete(path, new HashMap<String, Object>(), this.client.getAuthHeader());
    }

    public KyuubiSessionEvent getSessionEvent(String sessionHandleStr) {
        String path = String.format("%s/%s", API_BASE_PATH, sessionHandleStr);
        return this.getClient().get(path, new HashMap<String, Object>(), KyuubiSessionEvent.class, this.client.getAuthHeader());
    }

    public InfoDetail getSessionInfo(String sessionHandleStr, int infoType) {
        String path = String.format("%s/%s/info/%s", API_BASE_PATH, sessionHandleStr, infoType);
        return this.getClient().get(path, new HashMap<String, Object>(), InfoDetail.class, this.client.getAuthHeader());
    }

    public int getOpenSessionCount() {
        String path = String.format("%s/count", API_BASE_PATH);
        return this.getClient().get(path, new HashMap<String, Object>(), SessionOpenCount.class, this.client.getAuthHeader()).getOpenSessionCount();
    }

    public ExecPoolStatistic getExecPoolStatistic() {
        String path = String.format("%s/execPool/statistic", API_BASE_PATH);
        return this.getClient().get(path, new HashMap<String, Object>(), ExecPoolStatistic.class, this.client.getAuthHeader());
    }

    public OperationHandle executeStatement(String sessionHandleStr, StatementRequest request) {
        String path = String.format("%s/%s/operations/statement", API_BASE_PATH, sessionHandleStr);
        return this.getClient().post(path, JsonUtils.toJson(request), OperationHandle.class, this.client.getAuthHeader());
    }

    public OperationHandle getTypeInfo(String sessionHandleStr) {
        String path = String.format("%s/%s/operations/typeInfo", API_BASE_PATH, sessionHandleStr);
        return this.getClient().post(path, "", OperationHandle.class, this.client.getAuthHeader());
    }

    public OperationHandle getCatalogs(String sessionHandleStr) {
        String path = String.format("%s/%s/operations/catalogs", API_BASE_PATH, sessionHandleStr);
        return this.getClient().post(path, "", OperationHandle.class, this.client.getAuthHeader());
    }

    public OperationHandle getSchemas(String sessionHandleStr, GetSchemasRequest request) {
        String path = String.format("%s/%s/operations/schemas", API_BASE_PATH, sessionHandleStr);
        return this.getClient().post(path, JsonUtils.toJson(request), OperationHandle.class, this.client.getAuthHeader());
    }

    public OperationHandle getTables(String sessionHandleStr, GetTablesRequest request) {
        String path = String.format("%s/%s/operations/tables", API_BASE_PATH, sessionHandleStr);
        return this.getClient().post(path, JsonUtils.toJson(request), OperationHandle.class, this.client.getAuthHeader());
    }

    public OperationHandle getTableTypes(String sessionHandleStr) {
        String path = String.format("%s/%s/operations/tableTypes", API_BASE_PATH, sessionHandleStr);
        return this.getClient().post(path, "", OperationHandle.class, this.client.getAuthHeader());
    }

    public OperationHandle getColumns(String sessionHandleStr, GetColumnsRequest request) {
        String path = String.format("%s/%s/operations/columns", API_BASE_PATH, sessionHandleStr);
        return this.getClient().post(path, JsonUtils.toJson(request), OperationHandle.class, this.client.getAuthHeader());
    }

    public OperationHandle getFunctions(String sessionHandleStr, GetFunctionsRequest request) {
        String path = String.format("%s/%s/operations/functions", API_BASE_PATH, sessionHandleStr);
        return this.getClient().post(path, JsonUtils.toJson(request), OperationHandle.class, this.client.getAuthHeader());
    }

    public OperationHandle getPrimaryKeys(String sessionHandleStr, GetPrimaryKeysRequest request) {
        String path = String.format("%s/%s/operations/primaryKeys", API_BASE_PATH, sessionHandleStr);
        return this.getClient().post(path, JsonUtils.toJson(request), OperationHandle.class, this.client.getAuthHeader());
    }

    public OperationHandle getCrossReference(String sessionHandleStr, GetCrossReferenceRequest request) {
        String path = String.format("%s/%s/operations/crossReference", API_BASE_PATH, sessionHandleStr);
        return this.getClient().post(path, JsonUtils.toJson(request), OperationHandle.class, this.client.getAuthHeader());
    }

    private IRestClient getClient() {
        return this.client.getHttpClient();
    }
}

