/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.impl.FileRangeImpl;

public class CombinedFileRange
extends FileRangeImpl {
    private List<FileRange> underlying = new ArrayList<FileRange>();

    public CombinedFileRange(long offset, long end, FileRange original) {
        super(offset, (int)(end - offset), null);
        this.underlying.add(original);
    }

    public List<FileRange> getUnderlying() {
        return this.underlying;
    }

    public boolean merge(long otherOffset, long otherEnd, FileRange other, int minSeek, int maxSize) {
        long end = this.getOffset() + (long)this.getLength();
        long newEnd = Math.max(end, otherEnd);
        if (otherOffset - end >= (long)minSeek || newEnd - this.getOffset() > (long)maxSize) {
            return false;
        }
        this.setLength((int)(newEnd - this.getOffset()));
        this.underlying.add(other);
        return true;
    }
}

