/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.impl;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.Txn;
import io.etcd.jetcd.api.CompactionRequest;
import io.etcd.jetcd.api.DeleteRangeResponse;
import io.etcd.jetcd.api.RangeResponse;
import io.etcd.jetcd.api.TxnResponse;
import io.etcd.jetcd.api.VertxKVGrpc;
import io.etcd.jetcd.impl.ClientConnectionManager;
import io.etcd.jetcd.impl.Impl;
import io.etcd.jetcd.kv.CompactResponse;
import io.etcd.jetcd.kv.DeleteResponse;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import io.etcd.jetcd.op.TxnImpl;
import io.etcd.jetcd.options.CompactOption;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.support.Errors;
import io.etcd.jetcd.support.Requests;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class KVImpl
extends Impl
implements KV {
    private final VertxKVGrpc.KVVertxStub stub;
    private final ByteSequence namespace;

    KVImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxKVGrpc::newVertxStub);
        this.namespace = connectionManager.getNamespace();
    }

    @Override
    public CompletableFuture<PutResponse> put(ByteSequence key, ByteSequence value) {
        return this.put(key, value, PutOption.DEFAULT);
    }

    @Override
    public CompletableFuture<PutResponse> put(ByteSequence key, ByteSequence value, PutOption option) {
        Objects.requireNonNull(key, "key should not be null");
        Objects.requireNonNull(value, "value should not be null");
        Objects.requireNonNull(option, "option should not be null");
        return this.execute(() -> this.stub.put(Requests.mapPutRequest(key, value, option, this.namespace)), response -> new PutResponse((io.etcd.jetcd.api.PutResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<GetResponse> get(ByteSequence key) {
        return this.get(key, GetOption.DEFAULT);
    }

    @Override
    public CompletableFuture<GetResponse> get(ByteSequence key, GetOption option) {
        Objects.requireNonNull(key, "key should not be null");
        Objects.requireNonNull(option, "option should not be null");
        return this.execute(() -> this.stub.range(Requests.mapRangeRequest(key, option, this.namespace)), response -> new GetResponse((RangeResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<DeleteResponse> delete(ByteSequence key) {
        return this.delete(key, DeleteOption.DEFAULT);
    }

    @Override
    public CompletableFuture<DeleteResponse> delete(ByteSequence key, DeleteOption option) {
        Objects.requireNonNull(key, "key should not be null");
        Objects.requireNonNull(option, "option should not be null");
        return this.execute(() -> this.stub.deleteRange(Requests.mapDeleteRequest(key, option, this.namespace)), response -> new DeleteResponse((DeleteRangeResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<CompactResponse> compact(long rev) {
        return this.compact(rev, CompactOption.DEFAULT);
    }

    @Override
    public CompletableFuture<CompactResponse> compact(long rev, CompactOption option) {
        Objects.requireNonNull(option, "option should not be null");
        CompactionRequest request = CompactionRequest.newBuilder().setRevision(rev).setPhysical(option.isPhysical()).build();
        return this.execute(() -> this.stub.compact(request), CompactResponse::new, Errors::isRetryable);
    }

    @Override
    public Txn txn() {
        return TxnImpl.newTxn(request -> this.execute(() -> this.stub.txn(request), response -> new io.etcd.jetcd.kv.TxnResponse((TxnResponse)response, this.namespace), Errors::isRetryable), this.namespace);
    }
}

