/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.common.cli.EscapeCRLFHelper;

abstract class Rows
implements Iterator {
    protected final BeeLine beeLine;
    final ResultSetMetaData rsMeta;
    final Boolean[] primaryKeys;
    final NumberFormat numberFormat;
    private boolean convertBinaryArray;
    private final String nullStr;

    Rows(BeeLine beeLine, ResultSet rs) throws SQLException {
        this.beeLine = beeLine;
        this.nullStr = beeLine.getOpts().getNullString();
        this.rsMeta = rs.getMetaData();
        int count = this.rsMeta.getColumnCount();
        this.primaryKeys = new Boolean[count];
        this.numberFormat = beeLine.getOpts().getNumberFormat().equals("default") ? null : new DecimalFormat(beeLine.getOpts().getNumberFormat());
        this.convertBinaryArray = beeLine.getOpts().getConvertBinaryArrayToString();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    abstract void normalizeWidths();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isPrimaryKey(int col) {
        if (this.primaryKeys[col] != null) {
            return this.primaryKeys[col];
        }
        try {
            String table = this.rsMeta.getTableName(col + 1);
            String column = this.rsMeta.getColumnName(col + 1);
            if (table == null || table.length() == 0 || column == null || column.length() == 0) {
                this.primaryKeys[col] = new Boolean(false);
                return this.primaryKeys[col];
            }
            try (ResultSet pks = this.beeLine.getDatabaseConnection().getDatabaseMetaData().getPrimaryKeys(this.beeLine.getDatabaseConnection().getDatabaseMetaData().getConnection().getCatalog(), null, table);){
                while (pks.next()) {
                    if (!column.equalsIgnoreCase(pks.getString("COLUMN_NAME"))) continue;
                    this.primaryKeys[col] = new Boolean(true);
                    boolean bl = this.primaryKeys[col];
                    return bl;
                }
            }
            this.primaryKeys[col] = new Boolean(false);
            return this.primaryKeys[col];
        }
        catch (SQLException sqle) {
            this.primaryKeys[col] = new Boolean(false);
            return this.primaryKeys[col];
        }
    }

    class Row {
        final String[] values;
        final boolean isMeta;
        boolean deleted;
        boolean inserted;
        boolean updated;
        int[] sizes;

        Row(int size) throws SQLException {
            this.isMeta = true;
            this.values = new String[size];
            this.sizes = new int[size];
            for (int i = 0; i < size; ++i) {
                this.values[i] = Rows.this.rsMeta.getColumnLabel(i + 1);
                this.sizes[i] = this.values[i] == null ? 1 : this.values[i].length();
            }
            this.deleted = false;
            this.updated = false;
            this.inserted = false;
        }

        public String toString() {
            return Arrays.asList(this.values).toString();
        }

        Row(int size, ResultSet rs) throws SQLException {
            this.isMeta = false;
            this.values = new String[size];
            this.sizes = new int[size];
            try {
                this.deleted = rs.rowDeleted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.updated = rs.rowUpdated();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.inserted = rs.rowInserted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (int i = 0; i < size; ++i) {
                Object o = rs.getObject(i + 1);
                String value = null;
                value = o == null ? Rows.this.nullStr : (o instanceof Number ? (Rows.this.numberFormat != null ? Rows.this.numberFormat.format(o) : o.toString()) : (o instanceof byte[] ? (Rows.this.convertBinaryArray ? new String((byte[])o) : Arrays.toString((byte[])o)) : o.toString()));
                if (Rows.this.beeLine.getOpts().getEscapeCRLF()) {
                    value = EscapeCRLFHelper.escapeCRLF(value);
                }
                this.values[i] = value.intern();
                this.sizes[i] = value.length();
            }
        }
    }
}

