/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.http.impl;

import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kyuubi.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.kyuubi.shade.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.kyuubi.shade.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import org.apache.kyuubi.shade.io.netty.handler.codec.http.HttpRequest;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.kyuubi.shade.io.netty.util.CharsetUtil;
import org.apache.kyuubi.shade.io.netty.util.collection.CharObjectMap;
import org.apache.kyuubi.shade.io.vertx.core.buffer.Buffer;
import org.apache.kyuubi.shade.io.vertx.core.http.Http2Settings;
import org.apache.kyuubi.shade.io.vertx.core.http.impl.HttpUtils;

public class VertxHttp2ClientUpgradeCodec
implements HttpClientUpgradeHandler.UpgradeCodec {
    private static final List<CharSequence> UPGRADE_HEADERS = Collections.singletonList(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
    private final Http2Settings settings;

    public VertxHttp2ClientUpgradeCodec(Http2Settings settings) {
        this.settings = settings;
    }

    @Override
    public CharSequence protocol() {
        return "h2c";
    }

    @Override
    public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
        org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2Settings nettySettings = new org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2Settings();
        HttpUtils.fromVertxInitialSettings(false, this.settings, nettySettings);
        Buffer buf = Buffer.buffer();
        for (CharObjectMap.PrimitiveEntry entry : nettySettings.entries()) {
            buf.appendUnsignedShort(entry.key());
            buf.appendUnsignedInt((Long)entry.value());
        }
        String encodedSettings = new String(Base64.getUrlEncoder().encode(buf.getBytes()), CharsetUtil.UTF_8);
        upgradeRequest.headers().set(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER, (Object)encodedSettings);
        return UPGRADE_HEADERS;
    }

    @Override
    public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
    }
}

