/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.datagram;

import java.util.Base64;
import java.util.Map;
import org.apache.kyuubi.shade.io.vertx.core.datagram.DatagramSocketOptions;
import org.apache.kyuubi.shade.io.vertx.core.json.JsonObject;
import org.apache.kyuubi.shade.io.vertx.core.json.impl.JsonUtil;

public class DatagramSocketOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, DatagramSocketOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "broadcast": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBroadcast((Boolean)member.getValue());
                    break;
                }
                case "ipV6": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setIpV6((Boolean)member.getValue());
                    break;
                }
                case "loopbackModeDisabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setLoopbackModeDisabled((Boolean)member.getValue());
                    break;
                }
                case "multicastNetworkInterface": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMulticastNetworkInterface((String)member.getValue());
                    break;
                }
                case "multicastTimeToLive": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMulticastTimeToLive(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(DatagramSocketOptions obj, JsonObject json) {
        DatagramSocketOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(DatagramSocketOptions obj, Map<String, Object> json) {
        json.put("broadcast", obj.isBroadcast());
        json.put("ipV6", obj.isIpV6());
        json.put("loopbackModeDisabled", obj.isLoopbackModeDisabled());
        if (obj.getMulticastNetworkInterface() != null) {
            json.put("multicastNetworkInterface", obj.getMulticastNetworkInterface());
        }
        json.put("multicastTimeToLive", obj.getMulticastTimeToLive());
    }
}

