/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.dev.failsafe.spi;

import java.time.Duration;
import org.apache.kyuubi.shade.dev.failsafe.DelayablePolicyConfig;
import org.apache.kyuubi.shade.dev.failsafe.ExecutionContext;
import org.apache.kyuubi.shade.dev.failsafe.Policy;
import org.apache.kyuubi.shade.dev.failsafe.PolicyConfig;
import org.apache.kyuubi.shade.dev.failsafe.internal.util.Durations;

public interface DelayablePolicy<R>
extends Policy<R> {
    @Override
    public DelayablePolicyConfig<R> getConfig();

    default public Duration computeDelay(ExecutionContext<R> context) {
        PolicyConfig config = this.getConfig();
        Duration computed = null;
        if (context != null && ((DelayablePolicyConfig)config).getDelayFn() != null) {
            boolean delayExceptionMatched;
            R result = context.getLastResult();
            Object exception = context.getLastException();
            Object delayResult = ((DelayablePolicyConfig)config).getDelayResult();
            Class<Throwable> delayFailure = ((DelayablePolicyConfig)config).getDelayException();
            boolean delayResultMatched = delayResult == null || delayResult.equals(result);
            boolean bl = delayExceptionMatched = delayFailure == null || exception != null && delayFailure.isAssignableFrom(exception.getClass());
            if (delayResultMatched && delayExceptionMatched) {
                try {
                    computed = Durations.ofSafeNanos(((DelayablePolicyConfig)config).getDelayFn().get(context));
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        }
        return computed != null && !computed.isNegative() ? computed : null;
    }
}

