/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.dev.failsafe;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.kyuubi.shade.dev.failsafe.CallImpl;
import org.apache.kyuubi.shade.dev.failsafe.ExecutionImpl;
import org.apache.kyuubi.shade.dev.failsafe.FailsafeException;
import org.apache.kyuubi.shade.dev.failsafe.FailsafeExecutor;
import org.apache.kyuubi.shade.dev.failsafe.Policy;
import org.apache.kyuubi.shade.dev.failsafe.spi.ExecutionResult;
import org.apache.kyuubi.shade.dev.failsafe.spi.PolicyExecutor;
import org.apache.kyuubi.shade.dev.failsafe.spi.Scheduler;
import org.apache.kyuubi.shade.dev.failsafe.spi.SyncExecutionInternal;

final class SyncExecutionImpl<R>
extends ExecutionImpl<R>
implements SyncExecutionInternal<R> {
    private final FailsafeExecutor<R> executor;
    private final CallImpl<R> call;
    private Function<SyncExecutionInternal<R>, ExecutionResult<R>> outerFn;
    private final Thread executionThread;
    private final AtomicBoolean interruptable;
    private final AtomicBoolean interrupted;
    private volatile long delayNanos;

    SyncExecutionImpl(List<? extends Policy<R>> policies) {
        super(policies);
        this.executor = null;
        this.call = null;
        this.interruptable = new AtomicBoolean();
        this.interrupted = new AtomicBoolean();
        this.executionThread = Thread.currentThread();
        this.preExecute();
    }

    SyncExecutionImpl(FailsafeExecutor<R> executor, Scheduler scheduler, CallImpl<R> call, Function<SyncExecutionInternal<R>, ExecutionResult<R>> innerFn) {
        super(executor.policies);
        this.executor = executor;
        this.call = call;
        this.interruptable = new AtomicBoolean();
        this.interrupted = new AtomicBoolean();
        this.executionThread = Thread.currentThread();
        if (call != null) {
            call.setExecution(this);
        }
        this.outerFn = innerFn;
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            this.outerFn = policyExecutor.apply(this.outerFn, scheduler);
        }
    }

    private SyncExecutionImpl(SyncExecutionImpl<R> execution) {
        super(execution);
        this.executor = execution.executor;
        this.call = execution.call;
        this.interruptable = execution.interruptable;
        this.interrupted = execution.interrupted;
        this.executionThread = execution.executionThread;
        if (this.call != null) {
            this.call.setExecution(this);
        }
    }

    @Override
    public void complete() {
        this.postExecute(ExecutionResult.none());
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public Duration getDelay() {
        return Duration.ofNanos(this.delayNanos);
    }

    @Override
    public void record(R result, Throwable exception) {
        this.preExecute();
        this.postExecute(new ExecutionResult<R>(result, exception));
    }

    @Override
    public void recordResult(R result) {
        this.preExecute();
        this.postExecute(new ExecutionResult<R>(result, null));
    }

    @Override
    public void recordException(Throwable exception) {
        this.preExecute();
        this.postExecute(new ExecutionResult<Object>(null, exception));
    }

    @Override
    public synchronized void preExecute() {
        if (this.isStandalone()) {
            this.attemptRecorded = false;
            this.cancelledIndex = Integer.MIN_VALUE;
            this.interrupted.set(false);
        }
        super.preExecute();
        this.interruptable.set(true);
    }

    @Override
    synchronized ExecutionResult<R> postExecute(ExecutionResult<R> result) {
        result = super.postExecute(result);
        this.delayNanos = result.getDelay();
        return result;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted.get();
    }

    @Override
    public void setInterruptable(boolean interruptable) {
        this.interruptable.set(interruptable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.interruptable.get()) {
                this.interrupted.set(true);
                this.executionThread.interrupt();
            }
        }
    }

    private boolean isStandalone() {
        return this.executor == null;
    }

    @Override
    public SyncExecutionImpl<R> copy() {
        return this.isStandalone() ? this : new SyncExecutionImpl<R>(this);
    }

    R executeSync() {
        ExecutionResult<R> result = this.outerFn.apply(this);
        this.completed = result.isComplete();
        this.executor.completionHandler.accept(result, this);
        Throwable exception = result.getException();
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof Error) {
                throw (Error)exception;
            }
            throw new FailsafeException(exception);
        }
        return result.getResult();
    }
}

