/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.impl;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.kyuubi.shade.io.vertx.core.impl.WorkerExecutor;
import org.apache.kyuubi.shade.io.vertx.core.impl.logging.Logger;
import org.apache.kyuubi.shade.io.vertx.core.impl.logging.LoggerFactory;

public class TaskQueue {
    static final Logger log = LoggerFactory.getLogger(TaskQueue.class);
    private final LinkedList<Task> tasks = new LinkedList();
    private Executor currentExecutor;
    private Thread currentThread;
    private final Runnable runner = this::run;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (true) {
            ExecuteTask execute;
            LinkedList<Task> linkedList = this.tasks;
            synchronized (linkedList) {
                Task task = this.tasks.poll();
                if (task == null) {
                    this.currentExecutor = null;
                    return;
                }
                if (task instanceof ResumeTask) {
                    ResumeTask resume = (ResumeTask)task;
                    this.currentExecutor = resume.executor;
                    this.currentThread = resume.thread;
                    resume.latch.run();
                    return;
                }
                execute = (ExecuteTask)task;
                if (execute.exec != this.currentExecutor) {
                    this.tasks.addFirst(execute);
                    execute.exec.execute(this.runner);
                    this.currentExecutor = execute.exec;
                    return;
                }
            }
            try {
                this.currentThread = Thread.currentThread();
                execute.runnable.run();
                continue;
            }
            catch (Throwable t) {
                log.error("Caught unexpected Throwable", t);
                continue;
            }
            finally {
                this.currentThread = null;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerExecutor.TaskController current() {
        Executor executor;
        Thread thread;
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            if (Thread.currentThread() != this.currentThread) {
                throw new IllegalStateException();
            }
            thread = this.currentThread;
            executor = this.currentExecutor;
        }
        return new WorkerExecutor.TaskController(){
            final CountDownLatch latch = new CountDownLatch(1);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resume(Runnable callback) {
                Runnable task = () -> {
                    callback.run();
                    this.latch.countDown();
                };
                LinkedList linkedList = TaskQueue.this.tasks;
                synchronized (linkedList) {
                    if (TaskQueue.this.currentExecutor != null) {
                        TaskQueue.this.tasks.addFirst(new ResumeTask(task, executor, thread));
                        return;
                    }
                    TaskQueue.this.currentExecutor = executor;
                    TaskQueue.this.currentThread = thread;
                }
                task.run();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CountDownLatch suspend() {
                if (Thread.currentThread() != thread) {
                    throw new IllegalStateException();
                }
                LinkedList linkedList = TaskQueue.this.tasks;
                synchronized (linkedList) {
                    if (TaskQueue.this.currentThread == null || TaskQueue.this.currentThread != Thread.currentThread()) {
                        throw new IllegalStateException();
                    }
                    TaskQueue.this.currentThread = null;
                }
                executor.execute(TaskQueue.this.runner);
                return this.latch;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task, Executor executor) {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            if (this.currentExecutor == null) {
                this.currentExecutor = executor;
                try {
                    executor.execute(this.runner);
                }
                catch (RejectedExecutionException e) {
                    this.currentExecutor = null;
                    throw e;
                }
            }
            this.tasks.add(new ExecuteTask(task, executor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList<Task> linkedList = this.tasks;
        synchronized (linkedList) {
            return this.tasks.isEmpty() && this.currentExecutor == null;
        }
    }

    private static class ResumeTask
    implements Task {
        private final Runnable latch;
        private final Executor executor;
        private final Thread thread;

        ResumeTask(Runnable latch, Executor executor, Thread thread) {
            this.latch = latch;
            this.executor = executor;
            this.thread = thread;
        }
    }

    private static class ExecuteTask
    implements Task {
        private final Runnable runnable;
        private final Executor exec;

        public ExecuteTask(Runnable runnable, Executor exec) {
            this.runnable = runnable;
            this.exec = exec;
        }
    }

    private static interface Task {
    }
}

