/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.kyuubi.shade.io.etcd.jetcd.ByteSequence;
import org.apache.kyuubi.shade.io.etcd.jetcd.KV;
import org.apache.kyuubi.shade.io.etcd.jetcd.Txn;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.CompactionRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.DeleteRangeResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.PutResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.RangeResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.TxnRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.VertxKVGrpc;
import org.apache.kyuubi.shade.io.etcd.jetcd.impl.ClientConnectionManager;
import org.apache.kyuubi.shade.io.etcd.jetcd.impl.Impl;
import org.apache.kyuubi.shade.io.etcd.jetcd.kv.CompactResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.kv.DeleteResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.kv.GetResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.kv.TxnResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.op.TxnImpl;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.CompactOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.DeleteOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.GetOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.PutOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.support.Errors;
import org.apache.kyuubi.shade.io.etcd.jetcd.support.Requests;

final class KVImpl
extends Impl
implements KV {
    private final VertxKVGrpc.KVVertxStub stub;
    private final ByteSequence namespace;

    KVImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxKVGrpc::newVertxStub);
        this.namespace = connectionManager.getNamespace();
    }

    @Override
    public CompletableFuture<org.apache.kyuubi.shade.io.etcd.jetcd.kv.PutResponse> put(ByteSequence key, ByteSequence value) {
        return this.put(key, value, PutOption.DEFAULT);
    }

    @Override
    public CompletableFuture<org.apache.kyuubi.shade.io.etcd.jetcd.kv.PutResponse> put(ByteSequence key, ByteSequence value, PutOption option) {
        Objects.requireNonNull(key, "key should not be null");
        Objects.requireNonNull(value, "value should not be null");
        Objects.requireNonNull(option, "option should not be null");
        return this.execute(() -> this.stub.put(Requests.mapPutRequest(key, value, option, this.namespace)), response -> new org.apache.kyuubi.shade.io.etcd.jetcd.kv.PutResponse((PutResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<GetResponse> get(ByteSequence key) {
        return this.get(key, GetOption.DEFAULT);
    }

    @Override
    public CompletableFuture<GetResponse> get(ByteSequence key, GetOption option) {
        Objects.requireNonNull(key, "key should not be null");
        Objects.requireNonNull(option, "option should not be null");
        return this.execute(() -> this.stub.range(Requests.mapRangeRequest(key, option, this.namespace)), response -> new GetResponse((RangeResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<DeleteResponse> delete(ByteSequence key) {
        return this.delete(key, DeleteOption.DEFAULT);
    }

    @Override
    public CompletableFuture<DeleteResponse> delete(ByteSequence key, DeleteOption option) {
        Objects.requireNonNull(key, "key should not be null");
        Objects.requireNonNull(option, "option should not be null");
        return this.execute(() -> this.stub.deleteRange(Requests.mapDeleteRequest(key, option, this.namespace)), response -> new DeleteResponse((DeleteRangeResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<CompactResponse> compact(long rev) {
        return this.compact(rev, CompactOption.DEFAULT);
    }

    @Override
    public CompletableFuture<CompactResponse> compact(long rev, CompactOption option) {
        Objects.requireNonNull(option, "option should not be null");
        CompactionRequest request = CompactionRequest.newBuilder().setRevision(rev).setPhysical(option.isPhysical()).build();
        return this.execute(() -> this.stub.compact(request), CompactResponse::new, Errors::isRetryable);
    }

    @Override
    public Txn txn() {
        return TxnImpl.newTxn(request -> this.execute(() -> this.stub.txn((TxnRequest)request), response -> new TxnResponse((org.apache.kyuubi.shade.io.etcd.jetcd.api.TxnResponse)response, this.namespace), Errors::isRetryable), this.namespace);
    }
}

