/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.util;

import java.io.FileInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class SSLUtils$
implements Logging {
    public static SSLUtils$ MODULE$;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new SSLUtils$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private Option<Object> getKeyStoreExpirationTime(String keyStorePath, String keyStorePassword, Option<String> keyStoreType) {
        None$ none$;
        try {
            KeyStore keyStore = KeyStore.getInstance((String)keyStoreType.getOrElse((Function0 & Serializable & scala.Serializable)() -> KeyStore.getDefaultType()));
            keyStore.load(new FileInputStream(keyStorePath), keyStorePassword.toCharArray());
            none$ = ((TraversableLike)((SeqLike)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(keyStore.aliases()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)alias -> BoxesRunTime.boxToLong((long)SSLUtils$.$anonfun$getKeyStoreExpirationTime$2(keyStore, alias)), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$)).headOption();
        }
        catch (Throwable e) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error getting keystore expiration time.", e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void tracingThriftSSLCertExpiration(Option<String> keyStorePath, Option<String> keyStorePassword, Option<String> keyStoreType) {
        if (keyStorePath.isDefined() && keyStorePassword.isDefined()) {
            this.getKeyStoreExpirationTime((String)keyStorePath.get(), (String)keyStorePassword.get(), keyStoreType).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)expiration -> {
                MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Thrift SSL Server KeyStore ").append(keyStorePath.get()).append(" will expire at:").append(" ").append(Utils$.MODULE$.getDateFromTimestamp(expiration)).toString());
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                    SSLUtils$.$anonfun$tracingThriftSSLCertExpiration$3(expiration, ms);
                    return BoxedUnit.UNIT;
                });
            });
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$getKeyStoreExpirationTime$2(KeyStore keyStore$1, String alias) {
        return ((X509Certificate)keyStore$1.getCertificate(alias)).getNotAfter().getTime();
    }

    public static final /* synthetic */ void $anonfun$tracingThriftSSLCertExpiration$3(long expiration$1, MetricsSystem ms) {
        if (ms.getGauge("kyuubi.thrift.ssl.cert.expiration").isEmpty()) {
            ms.registerGauge("kyuubi.thrift.ssl.cert.expiration", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> expiration$1 - System.currentTimeMillis(), (Object)BoxesRunTime.boxToLong((long)0L));
            return;
        }
    }

    private SSLUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

