/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.http.authentication;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.server.http.authentication.AuthSchemes$;
import org.apache.kyuubi.server.http.authentication.AuthenticationHandler;
import org.apache.kyuubi.server.http.util.HttpAuthUtils$;
import org.apache.kyuubi.service.authentication.AnonymousAuthenticationProviderImpl;
import org.apache.kyuubi.service.authentication.AuthenticationProviderFactory$;
import org.apache.kyuubi.service.authentication.DefaultTokenCredential;
import org.apache.kyuubi.service.authentication.TokenAuthenticationProvider;
import org.apache.kyuubi.service.authentication.TokenCredential;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001\u0002\t\u0012\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006s\u0001!\tA\u000f\u0005\n{\u0001\u0001\r\u00111A\u0005\nyB\u0011\"\u0012\u0001A\u0002\u0003\u0007I\u0011\u0002$\t\u00131\u0003\u0001\u0019!A!B\u0013y\u0004bB'\u0001\u0005\u0004%IA\u0014\u0005\u0007%\u0002\u0001\u000b\u0011B(\t\u000fM\u0003!\u0019!C!)\"1\u0001\u000e\u0001Q\u0001\nUCQ!\u001b\u0001\u0005B)DQ\u0001\u001c\u0001\u0005B9CQ!\u001c\u0001\u0005B9DQ!\u001d\u0001\u0005BIDQA \u0001\u0005B}Dq!!\u0004\u0001\t\u0003\nyAA\u000eCK\u0006\u0014XM]!vi\",g\u000e^5dCRLwN\u001c%b]\u0012dWM\u001d\u0006\u0003%M\ta\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002\u0015+\u0005!\u0001\u000e\u001e;q\u0015\t1r#\u0001\u0004tKJ4XM\u001d\u0006\u00031e\taa[=vk\nL'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001?\u0015J\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'O5\t\u0011#\u0003\u0002)#\t)\u0012)\u001e;iK:$\u0018nY1uS>t\u0007*\u00198eY\u0016\u0014\bC\u0001\u0016,\u001b\u00059\u0012B\u0001\u0017\u0018\u0005\u001daunZ4j]\u001e\fQ\u0002\u001d:pm&$WM]\"mCN\u001c\bCA\u00187\u001d\t\u0001D\u0007\u0005\u00022C5\t!G\u0003\u00024;\u00051AH]8pizJ!!N\u0011\u0002\rA\u0013X\rZ3g\u0013\t9\u0004H\u0001\u0004TiJLgn\u001a\u0006\u0003k\u0005\na\u0001P5oSRtDCA\u001e=!\t1\u0003\u0001C\u0003.\u0005\u0001\u0007a&\u0001\u0003d_:4W#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t;\u0012AB2p]\u001aLw-\u0003\u0002E\u0003\nQ1*_;vE&\u001cuN\u001c4\u0002\u0011\r|gNZ0%KF$\"a\u0012&\u0011\u0005\u0001B\u0015BA%\"\u0005\u0011)f.\u001b;\t\u000f-#\u0011\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010J\u0019\u0002\u000b\r|gN\u001a\u0011\u0002\u001d\u0005dGn\\<B]>t\u00170\\8vgV\tq\n\u0005\u0002!!&\u0011\u0011+\t\u0002\b\u0005>|G.Z1o\u0003=\tG\u000e\\8x\u0003:|g._7pkN\u0004\u0013AC1vi\"\u001c6\r[3nKV\tQ\u000b\u0005\u0002WK:\u0011qk\u0019\b\u00031\nt!!W1\u000f\u0005i\u0003gBA.`\u001d\tafL\u0004\u00022;&\tA$\u0003\u0002\u001b7%\u0011\u0001$G\u0005\u0003-]I!\u0001F\u000b\n\u0005I\u0019\u0012B\u00013\u0012\u0003-\tU\u000f\u001e5TG\",W.Z:\n\u0005\u0019<'AC!vi\"\u001c6\r[3nK*\u0011A-E\u0001\fCV$\bnU2iK6,\u0007%\u0001\u0003j]&$HCA$l\u0011\u0015i$\u00021\u0001@\u0003]\tW\u000f\u001e5f]RL7-\u0019;j_:\u001cV\u000f\u001d9peR,G-A\bnCR\u001c\u0007.Q;uQN\u001b\u0007.Z7f)\tyu\u000eC\u0003q\u0019\u0001\u0007a&A\u0007bkRDwN]5{CRLwN\\\u0001\u0011O\u0016$\u0018)\u001e;i_JL'0\u0019;j_:$\"AL:\t\u000bQl\u0001\u0019A;\u0002\u000fI,\u0017/^3tiB\u0011a\u000f`\u0007\u0002o*\u0011A\u0003\u001f\u0006\u0003sj\fqa]3sm2,GOC\u0001|\u0003\u0015Q\u0017M^1y\u0013\tixO\u0001\nIiR\u00048+\u001a:wY\u0016$(+Z9vKN$\u0018\u0001D1vi\",g\u000e^5dCR,G#\u0002\u0018\u0002\u0002\u0005\r\u0001\"\u0002;\u000f\u0001\u0004)\bbBA\u0003\u001d\u0001\u0007\u0011qA\u0001\te\u0016\u001c\bo\u001c8tKB\u0019a/!\u0003\n\u0007\u0005-qOA\nIiR\u00048+\u001a:wY\u0016$(+Z:q_:\u001cX-A\u0004eKN$(o\\=\u0015\u0003\u001d\u0003")
public class BearerAuthenticationHandler
implements AuthenticationHandler,
Logging {
    private final String providerClass;
    private KyuubiConf conf;
    private final boolean allowAnonymous;
    private final Enumeration.Value authScheme;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private KyuubiConf conf() {
        return this.conf;
    }

    private void conf_$eq(KyuubiConf x$1) {
        this.conf = x$1;
    }

    private boolean allowAnonymous() {
        return this.allowAnonymous;
    }

    @Override
    public Enumeration.Value authScheme() {
        return this.authScheme;
    }

    @Override
    public void init(KyuubiConf conf) {
        this.conf_$eq(conf);
    }

    @Override
    public boolean authenticationSupported() {
        return Option$.MODULE$.apply((Object)this.providerClass).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BearerAuthenticationHandler.$anonfun$authenticationSupported$1(this, x$1)));
    }

    @Override
    public boolean matchAuthScheme(String authorization) {
        if (authorization == null || authorization.isEmpty()) {
            return this.allowAnonymous();
        }
        return AuthenticationHandler.matchAuthScheme$(this, authorization);
    }

    @Override
    public String getAuthorization(HttpServletRequest request) {
        String authHeader = request.getHeader(HttpAuthUtils$.MODULE$.AUTHORIZATION_HEADER());
        if (this.allowAnonymous() && (authHeader == null || authHeader.isEmpty())) {
            return "";
        }
        return AuthenticationHandler.getAuthorization$(this, request);
    }

    @Override
    public String authenticate(HttpServletRequest request, HttpServletResponse response) {
        String principal = null;
        String inputToken = this.getAuthorization(request);
        if (!this.allowAnonymous() && StringUtils.isBlank((CharSequence)inputToken)) {
            response.setHeader(HttpAuthUtils$.MODULE$.WWW_AUTHENTICATE_HEADER(), this.authScheme().toString());
            response.setStatus(401);
        } else {
            DefaultTokenCredential credential = new DefaultTokenCredential(inputToken, HttpAuthUtils$.MODULE$.getCredentialExtraInfo());
            principal = AuthenticationProviderFactory$.MODULE$.getHttpBearerAuthenticationProvider(this.providerClass, this.conf()).authenticate((TokenCredential)credential).getName();
            response.setStatus(200);
        }
        return principal;
    }

    @Override
    public void destroy() {
    }

    public static final /* synthetic */ boolean $anonfun$authenticationSupported$1(BearerAuthenticationHandler $this, String x$1) {
        boolean bl;
        try {
            Class.forName($this.providerClass).isAssignableFrom(TokenAuthenticationProvider.class);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public BearerAuthenticationHandler(String providerClass) {
        this.providerClass = providerClass;
        AuthenticationHandler.$init$(this);
        Logging.$init$((Logging)this);
        String string = AnonymousAuthenticationProviderImpl.class.getName();
        String string2 = providerClass;
        this.allowAnonymous = !(string != null ? !string.equals(string2) : string2 != null);
        this.authScheme = AuthSchemes$.MODULE$.BEARER();
    }
}

