/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.client.api.v1.dto.ColumnDesc;
import org.apache.kyuubi.client.api.v1.dto.Field;
import org.apache.kyuubi.client.api.v1.dto.KyuubiOperationEvent;
import org.apache.kyuubi.client.api.v1.dto.OpActionRequest;
import org.apache.kyuubi.client.api.v1.dto.OperationLog;
import org.apache.kyuubi.client.api.v1.dto.ResultRowSet;
import org.apache.kyuubi.client.api.v1.dto.ResultSetMetaData;
import org.apache.kyuubi.client.api.v1.dto.Row;
import org.apache.kyuubi.operation.FetchOrientation$;
import org.apache.kyuubi.operation.KyuubiOperation;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.OperationHandle$;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.server.api.ApiUtils$;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TBoolValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TByteValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TColumn;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TColumnValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TDoubleValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TFetchResultsResp;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TI16Value;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TI32Value;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TI64Value;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TStringValue;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeEntry;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TTypeQualifierValue;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@Tag(name="Operation")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\t=a!B\u0004\t\u0001!!\u0002\"B\u0012\u0001\t\u0003)\u0003\"\u0002\u0015\u0001\t\u0003I\u0003bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!a.\u0001\t\u0003\tIL\u0001\nPa\u0016\u0014\u0018\r^5p]N\u0014Vm]8ve\u000e,'BA\u0005\u000b\u0003\t1\u0018G\u0003\u0002\f\u0019\u0005\u0019\u0011\r]5\u000b\u00055q\u0011AB:feZ,'O\u0003\u0002\u0010!\u000511._;vE&T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sON!\u0001!F\u000e !\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011A$H\u0007\u0002\u0015%\u0011aD\u0003\u0002\u0012\u0003BL'+Z9vKN$8i\u001c8uKb$\bC\u0001\u0011\"\u001b\u0005q\u0011B\u0001\u0012\u000f\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002MA\u0011q\u0005A\u0007\u0002\u0011\u0005\tr-\u001a;Pa\u0016\u0014\u0018\r^5p]\u00163XM\u001c;\u0015\u0005)\"\u0004CA\u00163\u001b\u0005a#BA\u0017/\u0003\r!Go\u001c\u0006\u0003\u0013=R!a\u0003\u0019\u000b\u0005Er\u0011AB2mS\u0016tG/\u0003\u00024Y\t!2*_;vE&|\u0005/\u001a:bi&|g.\u0012<f]RDQ!\u000e\u0002A\u0002Y\n!c\u001c9fe\u0006$\u0018n\u001c8IC:$G.Z*ueB\u0011qG\u0010\b\u0003qq\u0002\"!O\f\u000e\u0003iR!a\u000f\u0013\u0002\rq\u0012xn\u001c;?\u0013\tit#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f\u0018Q\u0011!$\tT'\u0011\u0005\rSU\"\u0001#\u000b\u0005\u00153\u0015A\u0001:t\u0015\t9\u0005*\u0001\u0002xg*\t\u0011*A\u0003kCZ\f\u00070\u0003\u0002L\t\nI\u0001+\u0019;i!\u0006\u0014\u0018-\\\u0001\u0006m\u0006dW/Z\u0011\u0002\u001d\u0006yq\u000e]3sCRLwN\u001c%b]\u0012dW\r\u000b\u0003\u0003!2\u001b\u0006CA\"R\u0013\t\u0011FI\u0001\u0003QCRD\u0017%\u0001+\u0002/m|\u0007/\u001a:bi&|g\u000eS1oI2,WpL3wK:$\bF\u0001\u0002W!\t\u0019u+\u0003\u0002Y\t\n\u0019q)\u0012+)\u0015\tQ&n[7o\u0003\u0003\t\u0019\u0001\u0005\u0002\\Q6\tAL\u0003\u0002^=\u0006I!/Z:q_:\u001cXm\u001d\u0006\u0003?\u0002\f1\"\u00198o_R\fG/[8og*\u0011\u0011MY\u0001\u0004_\u0006\u001c(BA2e\u0003\t18G\u0003\u0002fM\u000691o^1hO\u0016\u0014(\"A4\u0002\u0005%|\u0017BA5]\u0005-\t\u0005/\u001b*fgB|gn]3\u0002\u0019I,7\u000f]8og\u0016\u001cu\u000eZ3\"\u00031\f1A\r\u00191\u0003\u001d\u0019wN\u001c;f]Rd\u0013a\\\u0016\u0006aZ<\u0018P\u001f\t\u0003cRl\u0011A\u001d\u0006\u0003gz\u000bQ!\\3eS\u0006L!!\u001e:\u0003\u000f\r{g\u000e^3oi\u0006IQ.\u001a3jCRK\b/Z\u0011\u0002q\u0006\u0001\u0012\r\u001d9mS\u000e\fG/[8o_)\u001cxN\\\u0001\u0007g\u000eDW-\\1,\u0007mtx\u0010\u0005\u0002ry&\u0011QP\u001d\u0002\u0007'\u000eDW-\\1\u0002\u001d%l\u0007\u000f\\3nK:$\u0018\r^5p]\u000e\n!&A\u0006eKN\u001c'/\u001b9uS>t\u0017EAA\u0003\u0003Y9U\r\u001e\u0011b]\u0002z\u0007/\u001a:bi&|g\u000eI3wK:$\u0018!D1qa2Lx\n]!di&|g\u000e\u0006\u0004\u0002\f\u0005]\u0011\u0011\u0005\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003#\u0002\t\r|'/Z\u0005\u0005\u0003+\tyA\u0001\u0005SKN\u0004xN\\:f\u0011\u001d\tIb\u0001a\u0001\u00037\tqA]3rk\u0016\u001cH\u000fE\u0002,\u0003;I1!a\b-\u0005=y\u0005/Q2uS>t'+Z9vKN$\b\"B\u001b\u0004\u0001\u00041\u0004&BA\u0011\u00052k\u0005&B\u0002Q\u0019\u0006\u001d\u0012EAA\u0015\u0003EYx\u000e]3sCRLwN\u001c%b]\u0012dW- \u0015\u0004\u0007\u00055\u0002cA\"\u00020%\u0019\u0011\u0011\u0007#\u0003\u0007A+F\u000bK\u0006\u00045*\\W.!\u000e\u0002\u0002\u0005eBFAA\u001cW\r\u0001ho^\u0011\u0003\u0003w\t\u0001%\u00199qYf\u0004\u0013M\u001c\u0011bGRLwN\u001c\u0011g_J\u0004\u0013M\u001c\u0011pa\u0016\u0014\u0018\r^5p]\u0006!r-\u001a;SKN,H\u000e^*fi6+G/\u00193bi\u0006$B!!\u0011\u0002HA\u00191&a\u0011\n\u0007\u0005\u0015CFA\tSKN,H\u000e^*fi6+G/\u0019#bi\u0006DQ!\u000e\u0003A\u0002YBS!a\u0012C\u00196CS\u0001\u0002)M\u0003\u001b\n#!a\u0014\u0002Gm|\u0007/\u001a:bi&|g\u000eS1oI2,Wp\f:fgVdGo]3u[\u0016$\u0018\rZ1uC\"\u0012AA\u0016\u0015\f\tiS7.\\A+\u0003\u0003\ti\u0006\f\u0002\u0002X-2\u0001O^<z\u00033ZCa\u001f@\u0002\\\r\u0012\u0011\u0011I\u0011\u0003\u0003?\nqcZ3uAI,7/\u001e7uAM,G\u000fI7fi\u0006$\u0017\r^1\u0002\u001f\u001d,Go\u00149fe\u0006$\u0018n\u001c8M_\u001e$\u0002\"!\u001a\u0002l\u0005=\u0014\u0011\u0013\t\u0004W\u0005\u001d\u0014bAA5Y\taq\n]3sCRLwN\u001c'pO\")Q'\u0002a\u0001m!*\u00111\u000e\"M\u001b\"9\u0011\u0011O\u0003A\u0002\u0005M\u0014aB7bqJ{wo\u001d\t\u0004-\u0005U\u0014bAA</\t\u0019\u0011J\u001c;)\u000f\u0005=\u00141\u0010'\u0002\u0002B\u00191)! \n\u0007\u0005}DI\u0001\u0007EK\u001a\fW\u000f\u001c;WC2,X-\t\u0002\u0002\u0004\u0006\u0019\u0011\u0007\r\u0019)\u000f\u0005=\u0014q\u0011'\u0002\u000eB\u00191)!#\n\u0007\u0005-EI\u0001\u0006Rk\u0016\u0014\u0018\u0010U1sC6\f#!a$\u0002\u000f5\f\u0007P]8xg\"1\u00111S\u0003A\u0002Y\n\u0001CZ3uG\"|%/[3oi\u0006$\u0018n\u001c8)\u000f\u0005E\u00151\u0010'\u0002\u0018\u0006\u0012\u0011\u0011T\u0001\u000b\r\u0016#6\tS0O\u000bb#\u0006fBAI\u0003\u000fc\u0015QT\u0011\u0003\u0003?\u000b\u0001CZ3uG\"|'/[3oi\u0006$\u0018n\u001c8)\u000b\u0015\u0001F*a)\"\u0005\u0005\u0015\u0016!F>pa\u0016\u0014\u0018\r^5p]\"\u000bg\u000e\u001a7f{>bwn\u001a\u0015\u0003\u000bYC3\"\u0002.kW6\fY+!\u0001\u000242\u0012\u0011QV\u0016\u0007aZ<\u00180a,,\tmt\u0018\u0011W\u0012\u0003\u0003K\n#!!.\u0002#\u001d,G\u000fI8qKJ\fG/[8oA1|w-A\u0007hKRtU\r\u001f;S_^\u001cV\r\u001e\u000b\t\u0003w\u000b\t-!2\u0002LB\u00191&!0\n\u0007\u0005}FF\u0001\u0007SKN,H\u000e\u001e*poN+G\u000fC\u00036\r\u0001\u0007a\u0007K\u0003\u0002B\ncU\nC\u0004\u0002r\u0019\u0001\r!a\u001d)\u000f\u0005\u0015\u00171\u0010'\u0002\u0002\":\u0011QYAD\u0019\u00065\u0005BBAJ\r\u0001\u0007a\u0007K\u0004\u0002L\u0006mD*a&)\u000f\u0005-\u0017q\u0011'\u0002\u001e\"*a\u0001\u0015'\u0002T\u0006\u0012\u0011Q[\u0001\u0019w>\u0004XM]1uS>t\u0007*\u00198eY\u0016lxF]8xg\u0016$\bF\u0001\u0004WQ-1!L[6n\u00037\f\t!a9-\u0005\u0005u7F\u00029wof\fyn\u000b\u0003|}\u0006\u00058EAA^C\t\t)/\u0001\nhKR\u0004#/Z:vYR\u0004#o\\<!g\u0016$\bF\u0002\u0001\u0002j2\u000by\u000fE\u0002D\u0003WL1!!<E\u0005!\u0019uN\\:v[\u0016\u001cH&A<)\r\u0001\t\u0019\u0010TA}!\r\u0019\u0015Q_\u0005\u0004\u0003o$%\u0001\u0003)s_\u0012,8-Z:-\u0003]Ds\u0001AA\u007f\u0005\u0013\u0011Y\u0001\u0005\u0003\u0002\u0000\n\u0015QB\u0001B\u0001\u0015\r\u0011\u0019AX\u0001\u0005i\u0006<7/\u0003\u0003\u0003\b\t\u0005!a\u0001+bO\u0006!a.Y7fC\t\u0011i!A\u0005Pa\u0016\u0014\u0018\r^5p]\u0002")
public class OperationsResource
implements ApiRequestContext,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=KyuubiOperationEvent.class))}, description="Get an operation event")
    @GET
    @Path(value="{operationHandle}/event")
    public KyuubiOperationEvent getOperationEvent(@PathParam(value="operationHandle") String operationHandleStr) {
        KyuubiOperationEvent kyuubiOperationEvent;
        try {
            OperationHandle opHandle = OperationHandle$.MODULE$.apply(operationHandleStr);
            Operation operation = this.fe().be().sessionManager().operationManager().getOperation(opHandle);
            kyuubiOperationEvent = ApiUtils$.MODULE$.operationEvent((KyuubiOperation)operation);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting an operation event";
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return kyuubiOperationEvent;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="apply an action for an operation")
    @PUT
    @Path(value="{operationHandle}")
    public Response applyOpAction(OpActionRequest request, @PathParam(value="operationHandle") String operationHandleStr) {
        Response response;
        try {
            OperationHandle operationHandle = OperationHandle$.MODULE$.apply(operationHandleStr);
            String string = request.getAction().toLowerCase();
            if ("cancel".equals(string)) {
                this.fe().be().cancelOperation(operationHandle);
            } else if ("close".equals(string)) {
                this.fe().be().closeOperation(operationHandle);
            } else {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(15).append("Invalid action ").append(request.getAction()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            response = Response.ok().build();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(37).append("Error applying ").append(request.getAction()).append(" for operation handle ").append(operationHandleStr).toString();
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return response;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResultSetMetaData.class))}, description="get result set metadata")
    @GET
    @Path(value="{operationHandle}/resultsetmetadata")
    public ResultSetMetaData getResultSetMetadata(@PathParam(value="operationHandle") String operationHandleStr) {
        ResultSetMetaData resultSetMetaData;
        try {
            OperationHandle operationHandle = OperationHandle$.MODULE$.apply(operationHandleStr);
            resultSetMetaData = new ResultSetMetaData((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.fe().be().getResultSetMetadata(operationHandle).getSchema().getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)c -> {
                TPrimitiveTypeEntry tPrimitiveTypeEntry = ((TTypeEntry)c.getTypeDesc().getTypes().get(0)).getPrimitiveEntry();
                int precision = 0;
                int scale = 0;
                if (tPrimitiveTypeEntry.getTypeQualifiers() != null) {
                    Map qualifiers = tPrimitiveTypeEntry.getTypeQualifiers().getQualifiers();
                    TTypeQualifierValue defaultValue = TTypeQualifierValue.i32Value((int)0);
                    precision = qualifiers.getOrDefault("precision", defaultValue).getI32Value();
                    scale = qualifiers.getOrDefault("scale", defaultValue).getI32Value();
                }
                return new ColumnDesc(c.getColumnName(), tPrimitiveTypeEntry.getType().toString(), c.getPosition(), precision, scale, c.getComment());
            }, Buffer$.MODULE$.canBuildFrom())).asJava());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(55).append("Error getting result set metadata for operation handle ").append(operationHandleStr).toString();
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return resultSetMetaData;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationLog.class))}, description="get operation log")
    @GET
    @Path(value="{operationHandle}/log")
    public OperationLog getOperationLog(@PathParam(value="operationHandle") String operationHandleStr, @QueryParam(value="maxrows") @DefaultValue(value="100") int maxRows, @QueryParam(value="fetchorientation") @DefaultValue(value="FETCH_NEXT") String fetchOrientation) {
        OperationLog operationLog;
        try {
            TFetchResultsResp fetchResultsResp;
            TRowSet rowSet;
            String string = fetchOrientation;
            String string2 = "FETCH_NEXT";
            if (string == null ? string2 != null : !string.equals(string2)) {
                String string3 = fetchOrientation;
                String string4 = "FETCH_FIRST";
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    throw new BadRequestException(new StringBuilder(34).append(fetchOrientation).append(" in operation log is not supported").toString());
                }
            }
            Seq logRowSet = (rowSet = (fetchResultsResp = this.fe().be().sessionManager().operationManager().getOperationLogRowSet(OperationHandle$.MODULE$.apply(operationHandleStr), FetchOrientation$.MODULE$.withName(fetchOrientation), maxRows)).getResults()).getColumns() != null ? (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(((TColumn)rowSet.getColumns().get(0)).getStringVal().getValues()).asScala() : (Seq)Nil$.MODULE$;
            operationLog = new OperationLog((List)JavaConverters$.MODULE$.seqAsJavaListConverter(logRowSet).asJava(), logRowSet.size());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof BadRequestException) {
                BadRequestException badRequestException = (BadRequestException)throwable2;
                throw badRequestException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(49).append("Error getting operation log for operation handle ").append(operationHandleStr).toString();
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return operationLog;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResultRowSet.class))}, description="get result row set")
    @GET
    @Path(value="{operationHandle}/rowset")
    public ResultRowSet getNextRowSet(@PathParam(value="operationHandle") String operationHandleStr, @QueryParam(value="maxrows") @DefaultValue(value="100") int maxRows, @QueryParam(value="fetchorientation") @DefaultValue(value="FETCH_NEXT") String fetchOrientation) {
        ResultRowSet resultRowSet;
        try {
            TFetchResultsResp fetchResultsResp = this.fe().be().fetchResults(OperationHandle$.MODULE$.apply(operationHandleStr), FetchOrientation$.MODULE$.withName(fetchOrientation), maxRows, false);
            TRowSet rowSet = fetchResultsResp.getResults();
            Buffer rows = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowSet.getRows()).asScala()).map((Function1 & Serializable & scala.Serializable)i2 -> new Row((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(i2.getColVals()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> {
                Object object;
                String string = ((Enum)i.getSetField()).name();
                TColumnValue._Fields _Fields2 = (TColumnValue._Fields)i.getSetField();
                if (TColumnValue._Fields.STRING_VAL.equals(_Fields2)) {
                    object = i.getStringVal().isSetValue() ? i.getStringVal().getFieldValue(TStringValue._Fields.VALUE) : null;
                } else if (TColumnValue._Fields.BOOL_VAL.equals(_Fields2)) {
                    object = i.getBoolVal().isSetValue() ? i.getBoolVal().getFieldValue(TBoolValue._Fields.VALUE) : null;
                } else if (TColumnValue._Fields.BYTE_VAL.equals(_Fields2)) {
                    object = i.getByteVal().isSetValue() ? i.getByteVal().getFieldValue(TByteValue._Fields.VALUE) : null;
                } else if (TColumnValue._Fields.DOUBLE_VAL.equals(_Fields2)) {
                    object = i.getDoubleVal().isSetValue() ? i.getDoubleVal().getFieldValue(TDoubleValue._Fields.VALUE) : null;
                } else if (TColumnValue._Fields.I16_VAL.equals(_Fields2)) {
                    object = i.getI16Val().isSetValue() ? i.getI16Val().getFieldValue(TI16Value._Fields.VALUE) : null;
                } else if (TColumnValue._Fields.I32_VAL.equals(_Fields2)) {
                    object = i.getI32Val().isSetValue() ? i.getI32Val().getFieldValue(TI32Value._Fields.VALUE) : null;
                } else if (TColumnValue._Fields.I64_VAL.equals(_Fields2)) {
                    object = i.getI64Val().isSetValue() ? i.getI64Val().getFieldValue(TI64Value._Fields.VALUE) : null;
                } else {
                    throw new MatchError((Object)_Fields2);
                }
                return new Field(string, object);
            }, Buffer$.MODULE$.canBuildFrom())).asJava()), Buffer$.MODULE$.canBuildFrom());
            resultRowSet = new ResultRowSet((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(rows).asJava(), rows.size());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable2;
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> illegalArgumentException.getMessage(), illegalArgumentException);
                throw new BadRequestException(illegalArgumentException.getMessage());
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(50).append("Error getting result row set for operation handle ").append(operationHandleStr).toString();
                throw new NotFoundException(ApiUtils$.MODULE$.logAndRefineErrorMsg(errorMsg, e));
            }
            throw throwable;
        }
        return resultRowSet;
    }

    public OperationsResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

