/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.CogroupedKStream;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.SessionWindowedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.SlidingWindows;
import org.apache.kafka.streams.kstream.TimeWindowedKStream;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.CogroupedKStreamImpl;
import org.apache.kafka.streams.kstream.internals.GroupedInternal;
import org.apache.kafka.streams.kstream.internals.GroupedStreamAggregateBuilder;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KStreamAggregate;
import org.apache.kafka.streams.kstream.internals.KStreamReduce;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.NamedInternal;
import org.apache.kafka.streams.kstream.internals.SessionWindowedKStreamImpl;
import org.apache.kafka.streams.kstream.internals.SlidingWindowedKStreamImpl;
import org.apache.kafka.streams.kstream.internals.TimeWindowedKStreamImpl;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.VersionedBytesStoreSupplier;

class KGroupedStreamImpl<K, V>
extends AbstractStream<K, V>
implements KGroupedStream<K, V> {
    static final String REDUCE_NAME = "KSTREAM-REDUCE-";
    static final String AGGREGATE_NAME = "KSTREAM-AGGREGATE-";
    private final GroupedStreamAggregateBuilder<K, V> aggregateBuilder;
    final boolean repartitionRequired;
    final String userProvidedRepartitionTopicName;

    KGroupedStreamImpl(String name, Set<String> subTopologySourceNodes, GroupedInternal<K, V> groupedInternal, boolean repartitionRequired, GraphNode graphNode, InternalStreamsBuilder builder) {
        super(name, groupedInternal.keySerde(), groupedInternal.valueSerde(), subTopologySourceNodes, graphNode, builder);
        this.repartitionRequired = repartitionRequired;
        this.userProvidedRepartitionTopicName = groupedInternal.name();
        this.aggregateBuilder = new GroupedStreamAggregateBuilder<K, V>(builder, groupedInternal, repartitionRequired, subTopologySourceNodes, name, graphNode);
    }

    @Override
    public KTable<K, V> reduce(Reducer<V> reducer) {
        return this.reduce(reducer, Materialized.with(this.keySerde, this.valueSerde));
    }

    @Override
    public KTable<K, V> reduce(Reducer<V> reducer, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        return this.reduce(reducer, NamedInternal.empty(), materialized);
    }

    @Override
    public KTable<K, V> reduce(Reducer<V> reducer, Named named, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(reducer, "reducer can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        Objects.requireNonNull(named, "name can't be null");
        MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, REDUCE_NAME);
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        if (materializedInternal.valueSerde() == null) {
            materializedInternal.withValueSerde(this.valueSerde);
        }
        String name = new NamedInternal(named).orElseGenerateWithPrefix(this.builder, REDUCE_NAME);
        KeyValueStoreMaterializer<K, V> storeFactory = new KeyValueStoreMaterializer<K, V>(materializedInternal);
        return this.doAggregate(new KStreamReduce(storeFactory, reducer), name, storeFactory);
    }

    @Override
    public <VR> KTable<K, VR> aggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        return this.aggregate(initializer, aggregator, NamedInternal.empty(), materialized);
    }

    @Override
    public <VR> KTable<K, VR> aggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator, Named named, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        Objects.requireNonNull(named, "named can't be null");
        MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, AGGREGATE_NAME);
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        String name = new NamedInternal(named).orElseGenerateWithPrefix(this.builder, AGGREGATE_NAME);
        KeyValueStoreMaterializer<K, VR> storeFactory = new KeyValueStoreMaterializer<K, VR>(materializedInternal);
        return this.doAggregate(new KStreamAggregate<K, V, VR>(storeFactory, initializer, aggregator), name, storeFactory);
    }

    @Override
    public <VR> KTable<K, VR> aggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator) {
        return this.aggregate(initializer, aggregator, Materialized.with(this.keySerde, null));
    }

    @Override
    public KTable<K, Long> count() {
        return this.doCount(NamedInternal.empty(), Materialized.with(this.keySerde, Serdes.Long()));
    }

    @Override
    public KTable<K, Long> count(Named named) {
        Objects.requireNonNull(named, "named can't be null");
        return this.doCount(named, Materialized.with(this.keySerde, Serdes.Long()));
    }

    @Override
    public KTable<K, Long> count(Materialized<K, Long, KeyValueStore<Bytes, byte[]>> materialized) {
        return this.count(NamedInternal.empty(), materialized);
    }

    @Override
    public KTable<K, Long> count(Named named, Materialized<K, Long, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(materialized, "materialized can't be null");
        if (new MaterializedInternal<K, Long, KeyValueStore<Bytes, byte[]>>(materialized).storeName() == null) {
            this.builder.newStoreName(AGGREGATE_NAME);
        }
        return this.doCount(named, materialized);
    }

    private KTable<K, Long> doCount(Named named, Materialized<K, Long, KeyValueStore<Bytes, byte[]>> materialized) {
        MaterializedInternal<K, Long, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, Long, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, AGGREGATE_NAME);
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        if (materializedInternal.valueSerde() == null) {
            materializedInternal.withValueSerde((Serde<Long>)Serdes.Long());
        }
        String name = new NamedInternal(named).orElseGenerateWithPrefix(this.builder, AGGREGATE_NAME);
        KeyValueStoreMaterializer<K, Long> storeFactory = new KeyValueStoreMaterializer<K, Long>(materializedInternal);
        return this.doAggregate(new KStreamAggregate(storeFactory, this.aggregateBuilder.countInitializer, this.aggregateBuilder.countAggregator), name, storeFactory);
    }

    @Override
    public <W extends Window> TimeWindowedKStream<K, V> windowedBy(Windows<W> windows) {
        return new TimeWindowedKStreamImpl<K, V, W>(windows, this.builder, this.subTopologySourceNodes, this.name, this.keySerde, this.valueSerde, this.aggregateBuilder, this.graphNode);
    }

    @Override
    public TimeWindowedKStream<K, V> windowedBy(SlidingWindows windows) {
        return new SlidingWindowedKStreamImpl<K, V>(windows, this.builder, this.subTopologySourceNodes, this.name, this.keySerde, this.valueSerde, this.aggregateBuilder, this.graphNode);
    }

    @Override
    public SessionWindowedKStream<K, V> windowedBy(SessionWindows windows) {
        return new SessionWindowedKStreamImpl<K, V>(windows, this.builder, this.subTopologySourceNodes, this.name, this.keySerde, this.valueSerde, this.aggregateBuilder, this.graphNode);
    }

    private <T> KTable<K, T> doAggregate(KStreamAggProcessorSupplier<K, V, K, T> aggregateSupplier, String functionName, KeyValueStoreMaterializer<K, T> storeFactory) {
        return this.aggregateBuilder.build(new NamedInternal(functionName), storeFactory, aggregateSupplier, storeFactory.queryableStoreName(), storeFactory.keySerde(), storeFactory.valueSerde(), storeFactory.storeSupplier() instanceof VersionedBytesStoreSupplier);
    }

    @Override
    public <VOut> CogroupedKStream<K, VOut> cogroup(Aggregator<? super K, ? super V, VOut> aggregator) {
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        return new CogroupedKStreamImpl<K, VOut>(this.name, this.subTopologySourceNodes, this.graphNode, this.builder).cogroup(this, aggregator);
    }
}

