/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoader;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(DelegatingClassLoader.class);
    private final ConcurrentMap<String, SortedMap<PluginDesc<?>, ClassLoader>> pluginLoaders = new ConcurrentHashMap();
    private final ConcurrentMap<String, String> aliases = new ConcurrentHashMap<String, String>();

    public DelegatingClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public DelegatingClassLoader() {
        this(DelegatingClassLoader.class.getClassLoader());
    }

    PluginClassLoader pluginClassLoader(String name) {
        if (!PluginUtils.shouldLoadInIsolation(name)) {
            return null;
        }
        SortedMap inner = (SortedMap)this.pluginLoaders.get(name);
        if (inner == null) {
            return null;
        }
        ClassLoader pluginLoader = (ClassLoader)inner.get(inner.lastKey());
        return pluginLoader instanceof PluginClassLoader ? (PluginClassLoader)pluginLoader : null;
    }

    ClassLoader connectorLoader(String connectorClassOrAlias) {
        String fullName = this.aliases.getOrDefault(connectorClassOrAlias, connectorClassOrAlias);
        URLClassLoader classLoader = this.pluginClassLoader(fullName);
        if (classLoader == null) {
            classLoader = this;
        }
        log.debug("Getting plugin class loader: '{}' for connector: {}", (Object)classLoader, (Object)connectorClassOrAlias);
        return classLoader;
    }

    public void installDiscoveredPlugins(PluginScanResult scanResult) {
        this.pluginLoaders.putAll(DelegatingClassLoader.computePluginLoaders(scanResult));
        for (String string : this.pluginLoaders.keySet()) {
            log.info("Added plugin '{}'", (Object)string);
        }
        this.aliases.putAll(PluginUtils.computeAliases(scanResult));
        for (Map.Entry entry : this.aliases.entrySet()) {
            log.info("Added alias '{}' to plugin '{}'", entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String fullName = this.aliases.getOrDefault(name, name);
        PluginClassLoader pluginLoader = this.pluginClassLoader(fullName);
        if (pluginLoader != null) {
            log.trace("Retrieving loaded class '{}' from '{}'", (Object)fullName, (Object)pluginLoader);
            return pluginLoader.loadClass(fullName, resolve);
        }
        return super.loadClass(fullName, resolve);
    }

    private static Map<String, SortedMap<PluginDesc<?>, ClassLoader>> computePluginLoaders(PluginScanResult plugins) {
        HashMap pluginLoaders = new HashMap();
        plugins.forEach(pluginDesc -> pluginLoaders.computeIfAbsent(pluginDesc.className(), k -> new TreeMap()).put(pluginDesc, pluginDesc.loader()));
        return pluginLoaders;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

