/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Random;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.workload.PayloadGenerator;

public class TimestampRandomPayloadGenerator
implements PayloadGenerator {
    private final int size;
    private final long seed;
    private final byte[] randomBytes;
    private final ByteBuffer buffer;
    private final Random random = new Random();

    @JsonCreator
    public TimestampRandomPayloadGenerator(@JsonProperty(value="size") int size, @JsonProperty(value="seed") long seed) {
        this.size = size;
        this.seed = seed;
        if (size < 8) {
            throw new RuntimeException("The size of the payload must be greater than or equal to 8.");
        }
        this.random.setSeed(seed);
        this.randomBytes = new byte[size - 8];
        this.buffer = ByteBuffer.allocate(8);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @JsonProperty
    public int size() {
        return this.size;
    }

    @JsonProperty
    public long seed() {
        return this.seed;
    }

    @Override
    public synchronized byte[] generate(long position) {
        byte[] result = new byte[this.size];
        if (this.randomBytes.length > 0) {
            this.random.setSeed(this.seed + position);
            this.random.nextBytes(this.randomBytes);
            System.arraycopy(this.randomBytes, 0, result, 8, this.randomBytes.length);
        }
        this.buffer.clear();
        this.buffer.putLong(Time.SYSTEM.milliseconds());
        this.buffer.rewind();
        System.arraycopy(this.buffer.array(), 0, result, 0, 8);
        return result;
    }
}

