/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kafka.log.remote.RemoteLogManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public class RemoteLogOffsetReader
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLogOffsetReader.class);
    private final RemoteLogManager rlm;
    private final TopicPartition tp;
    private final long timestamp;
    private final long startingOffset;
    private final LeaderEpochFileCache leaderEpochCache;
    private final Supplier<Optional<FileRecords.TimestampAndOffset>> searchInLocalLog;
    private final Consumer<OffsetResultHolder.FileRecordsOrError> callback;

    public RemoteLogOffsetReader(RemoteLogManager rlm, TopicPartition tp, long timestamp, long startingOffset, LeaderEpochFileCache leaderEpochCache, Supplier<Option<FileRecords.TimestampAndOffset>> searchInLocalLog, Consumer<OffsetResultHolder.FileRecordsOrError> callback) {
        this.rlm = rlm;
        this.tp = tp;
        this.timestamp = timestamp;
        this.startingOffset = startingOffset;
        this.leaderEpochCache = leaderEpochCache;
        this.searchInLocalLog = () -> OptionConverters.toJava((Option)((Option)searchInLocalLog.get()));
        this.callback = callback;
    }

    @Override
    public Void call() throws Exception {
        OffsetResultHolder.FileRecordsOrError result;
        try {
            Optional<FileRecords.TimestampAndOffset> timestampAndOffsetOpt = this.rlm.findOffsetByTimestamp(this.tp, this.timestamp, this.startingOffset, this.leaderEpochCache).or(this.searchInLocalLog);
            result = new OffsetResultHolder.FileRecordsOrError(Optional.empty(), timestampAndOffsetOpt);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while reading the remote log offset for {}", (Object)this.tp, (Object)e);
            result = new OffsetResultHolder.FileRecordsOrError(Optional.of(e), Optional.empty());
        }
        this.callback.accept(result);
        return null;
    }
}

