/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanMetaFiltered;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRecursionException;
import org.apache.juneau.BeanTraverseSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonParserSession;
import org.apache.juneau.json.JsonSerializerSession;
import org.apache.juneau.jsonschema.BeanDefMapper;
import org.apache.juneau.jsonschema.JsonSchemaBeanPropertyMeta;
import org.apache.juneau.jsonschema.JsonSchemaClassMeta;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.jsonschema.TypeCategory;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.swap.ObjectSwap;

public class JsonSchemaGeneratorSession
extends BeanTraverseSession {
    private final JsonSchemaGenerator ctx;
    private final Map<String, JsonMap> defs;
    private JsonParserSession jpSession;
    private JsonSerializerSession jsSession;

    public static Builder create(JsonSchemaGenerator ctx) {
        return new Builder(AssertionUtils.assertArgNotNull("ctx", ctx));
    }

    protected JsonSchemaGeneratorSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.defs = this.isUseBeanDefs() ? new TreeMap() : null;
    }

    public JsonSchemaGeneratorSession addBeanDef(String id, JsonMap def) {
        if (Utils.nn(this.defs)) {
            this.defs.put(AssertionUtils.assertArgNotNull("id", id), AssertionUtils.assertArgNotNull("def", def));
        }
        return this;
    }

    public String getBeanDefId(ClassMeta<?> cm) {
        return this.getBeanDefMapper().getId(cm);
    }

    public Map<String, JsonMap> getBeanDefs() {
        return this.defs;
    }

    public URI getBeanDefUri(ClassMeta<?> cm) {
        return this.getBeanDefMapper().getURI(cm);
    }

    public URI getBeanDefUri(String id) {
        return this.getBeanDefMapper().getURI(id);
    }

    public JsonSchemaBeanPropertyMeta getJsonSchemaBeanPropertyMeta(BeanPropertyMeta bpm) {
        return this.ctx.getJsonSchemaBeanPropertyMeta(bpm);
    }

    public JsonSchemaClassMeta getJsonSchemaClassMeta(ClassMeta<?> cm) {
        return this.ctx.getJsonSchemaClassMeta(cm);
    }

    public JsonMap getSchema(ClassMeta<?> cm) throws BeanRecursionException, SerializeException {
        return this.getSchema(cm, "root", null, false, false, null);
    }

    public JsonMap getSchema(Object o) throws BeanRecursionException, SerializeException {
        return this.getSchema(this.toClassMeta(o), "root", null, false, false, null);
    }

    public JsonMap getSchema(Type type) throws BeanRecursionException, SerializeException {
        return this.getSchema(this.getClassMeta(type, new Type[0]), "root", null, false, false, null);
    }

    private Object getDescription(ClassMeta<?> sType, TypeCategory t, boolean descriptionAdded) {
        boolean canAdd;
        boolean bl = canAdd = this.isAllowNestedDescriptions() || !descriptionAdded;
        if (canAdd && (this.getAddDescriptionsTo().contains((Object)t) || this.getAddDescriptionsTo().contains((Object)TypeCategory.ANY))) {
            return sType.toString();
        }
        return null;
    }

    private static List<String> getEnums(ClassMeta<?> cm) {
        List<String> l = CollectionUtils.list(new String[0]);
        for (Enum e : (Enum[])cm.inner().getEnumConstants()) {
            l.add(cm.toString(e));
        }
        return l;
    }

    private Object getExample(ClassMeta<?> sType, TypeCategory t, boolean exampleAdded) throws SerializeException {
        Object example;
        boolean canAdd;
        boolean bl = canAdd = this.isAllowNestedExamples() || !exampleAdded;
        if (canAdd && (this.getAddExamplesTo().contains((Object)t) || this.getAddExamplesTo().contains((Object)TypeCategory.ANY)) && Utils.nn(example = sType.getExample(this, this.jpSession()))) {
            try {
                return JsonParser.DEFAULT.parse(this.toJson(example), Object.class);
            }
            catch (ParseException e) {
                throw new SerializeException(e);
            }
        }
        return null;
    }

    private JsonMap getSchema(ClassMeta<?> eType, String attrName, List<String> pNames, boolean exampleAdded, boolean descriptionAdded, JsonSchemaBeanPropertyMeta jsbpm) throws BeanRecursionException, SerializeException {
        ClassMeta<?> objectSwapCM;
        boolean useDef;
        if (this.ctx.isIgnoredType(eType)) {
            return null;
        }
        JsonMap out = new JsonMap();
        if (eType == null) {
            eType = this.object();
        }
        ClassMeta<?> aType = null;
        ClassMeta<?> sType = null;
        ObjectSwap<Object, ?> objectSwap = eType.getSwap(this);
        aType = this.push(attrName, eType, null);
        sType = eType.getSerializedClassMeta(this);
        String type = null;
        String format = null;
        Object example = null;
        Object description = null;
        boolean bl = useDef = this.isUseBeanDefs() && sType.isBean() && pNames == null;
        if (useDef) {
            exampleAdded = false;
            descriptionAdded = false;
        }
        if (useDef && this.defs.containsKey(this.getBeanDefId(sType))) {
            this.pop();
            return new JsonMap().append("$ref", this.getBeanDefUri(sType));
        }
        JsonSchemaClassMeta jscm = null;
        ClassMeta<?> classMeta = objectSwapCM = objectSwap == null ? null : this.getClassMeta(objectSwap.getClass());
        if (Utils.nn(objectSwapCM) && this.getAnnotationProvider().has(Schema.class, objectSwapCM, new AnnotationTraversal[0])) {
            jscm = this.getJsonSchemaClassMeta(objectSwapCM);
        }
        if (jscm == null) {
            jscm = this.getJsonSchemaClassMeta(sType);
        }
        TypeCategory tc = null;
        if (sType.isNumber()) {
            tc = TypeCategory.NUMBER;
            if (sType.isDecimal()) {
                type = "number";
                if (sType.isFloat()) {
                    format = "float";
                } else if (sType.isDouble()) {
                    format = "double";
                }
            } else {
                type = "integer";
                if (sType.isShort()) {
                    format = "int16";
                } else if (sType.isInteger()) {
                    format = "int32";
                } else if (sType.isLong()) {
                    format = "int64";
                }
            }
        } else if (sType.isBoolean()) {
            tc = TypeCategory.BOOLEAN;
            type = "boolean";
        } else if (sType.isMap()) {
            tc = TypeCategory.MAP;
            type = "object";
        } else if (sType.isBean()) {
            tc = TypeCategory.BEAN;
            type = "object";
        } else if (sType.isCollection()) {
            tc = TypeCategory.COLLECTION;
            type = "array";
        } else if (sType.isArray()) {
            tc = TypeCategory.ARRAY;
            type = "array";
        } else if (sType.isEnum()) {
            tc = TypeCategory.ENUM;
            type = "string";
        } else if (sType.isCharSequence() || sType.isChar()) {
            tc = TypeCategory.STRING;
            type = "string";
        } else if (sType.isUri()) {
            tc = TypeCategory.STRING;
            type = "string";
            format = "uri";
        } else {
            tc = TypeCategory.STRING;
            type = "string";
        }
        if (Utils.nn(jsbpm)) {
            out.append(jsbpm.getSchema());
        }
        out.append(jscm.getSchema());
        Predicate<String> ne = Utils::ne;
        out.appendIfAbsentIf(ne, "type", type);
        out.appendIfAbsentIf(ne, "format", format);
        if (Utils.nn(aType)) {
            JsonMap om;
            example = this.getExample(sType, tc, exampleAdded);
            description = this.getDescription(sType, tc, descriptionAdded);
            exampleAdded |= Utils.nn(example);
            descriptionAdded |= Utils.nn(description);
            if (tc == TypeCategory.BEAN) {
                JsonMap properties = new JsonMap();
                BeanMeta bm = this.getBeanMeta(sType.inner());
                if (Utils.nn(pNames)) {
                    bm = new BeanMetaFiltered(bm, pNames);
                }
                for (BeanPropertyMeta p : bm.getProperties().values()) {
                    if (!p.canRead()) continue;
                    List<String> pProps = p.getProperties();
                    properties.put(p.getName(), (Object)this.getSchema(p.getClassMeta(), p.getName(), pProps, exampleAdded, descriptionAdded, this.getJsonSchemaBeanPropertyMeta(p)));
                }
                out.put("properties", (Object)properties);
            } else if (tc == TypeCategory.COLLECTION) {
                et = sType.getElementType();
                if (sType.isCollection() && sType.isChildOf(Set.class)) {
                    out.put("uniqueItems", (Object)true);
                }
                out.put("items", (Object)this.getSchema(et, "items", pNames, exampleAdded, descriptionAdded, null));
            } else if (tc == TypeCategory.ARRAY) {
                et = sType.getElementType();
                if (sType.isCollection() && sType.isChildOf(Set.class)) {
                    out.put("uniqueItems", (Object)true);
                }
                out.put("items", (Object)this.getSchema(et, "items", pNames, exampleAdded, descriptionAdded, null));
            } else if (tc == TypeCategory.ENUM) {
                out.put("enum", (Object)JsonSchemaGeneratorSession.getEnums(sType));
            } else if (tc == TypeCategory.MAP && !(om = this.getSchema(sType.getValueType(), "additionalProperties", null, exampleAdded, descriptionAdded, null)).isEmpty()) {
                out.put("additionalProperties", (Object)om);
            }
        }
        out.append(jscm.getSchema());
        Predicate<Object> neo = Utils::ne;
        out.appendIfAbsentIf(neo, "description", description);
        out.appendIfAbsentIf(neo, "example", example);
        if (useDef) {
            this.defs.put(this.getBeanDefId(sType), out);
            out = JsonMap.of(new Object[]{"$ref", this.getBeanDefUri(sType)});
        }
        this.pop();
        return out;
    }

    private JsonParserSession jpSession() {
        if (this.jpSession == null) {
            this.jpSession = this.ctx.getJsonParser().getSession();
        }
        return this.jpSession;
    }

    private ClassMeta<?> toClassMeta(Object o) {
        if (o instanceof Type) {
            Type o2 = (Type)o;
            return this.getClassMeta(o2, new Type[0]);
        }
        return this.getClassMetaForObject(o);
    }

    private String toJson(Object o) throws SerializeException {
        if (this.jsSession == null) {
            this.jsSession = this.ctx.getJsonSerializer().getSession();
        }
        return this.jsSession.serializeToString(o);
    }

    protected final Set<TypeCategory> getAddDescriptionsTo() {
        return this.ctx.getAddDescriptionsTo();
    }

    protected final Set<TypeCategory> getAddExamplesTo() {
        return this.ctx.getAddExamplesTo();
    }

    protected final BeanDefMapper getBeanDefMapper() {
        return this.ctx.getBeanDefMapper();
    }

    protected final List<Pattern> getIgnoreTypes() {
        return this.ctx.getIgnoreTypes();
    }

    protected final boolean isAllowNestedDescriptions() {
        return this.ctx.isAllowNestedDescriptions();
    }

    protected final boolean isAllowNestedExamples() {
        return this.ctx.isAllowNestedExamples();
    }

    protected final boolean isUseBeanDefs() {
        return this.ctx.isUseBeanDefs();
    }

    public static class Builder
    extends BeanTraverseSession.Builder {
        private JsonSchemaGenerator ctx;

        protected Builder(JsonSchemaGenerator ctx) {
            super(AssertionUtils.assertArgNotNull("ctx", ctx));
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public JsonSchemaGeneratorSession build() {
            return new JsonSchemaGeneratorSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }
    }
}

