/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentStringListAssertion;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;

public class FluentThrowableAssertion<T extends Throwable, R>
extends FluentObjectAssertion<T, R> {
    private static final Messages MESSAGES = Messages.of(FluentThrowableAssertion.class, "Messages");
    private static final String MSG_exceptionWasNotExpectedType = MESSAGES.getString("exceptionWasNotExpectedType");
    private static final String MSG_exceptionWasNotThrown = MESSAGES.getString("exceptionWasNotThrown");
    private static final String MSG_causedByExceptionNotExpectedType = MESSAGES.getString("causedByExceptionNotExpectedType");

    public FluentThrowableAssertion(Assertion creator, T value, R returns) {
        super(creator, value, returns);
    }

    public FluentThrowableAssertion(T value, R returns) {
        this(null, value, returns);
    }

    public FluentThrowableAssertion<Throwable, R> asCausedBy() {
        return this.asCausedBy(Throwable.class);
    }

    public <X extends Throwable> FluentThrowableAssertion<X, R> asCausedBy(Class<X> type) {
        Throwable t = this.map(Throwable::getCause).orElse(null);
        if (t == null || type.isInstance(t)) {
            return new FluentThrowableAssertion(this, (Throwable)type.cast(t), this.returns());
        }
        throw this.error(MSG_causedByExceptionNotExpectedType, Utils.cn(type), Utils.cn(t.getClass()));
    }

    public <X extends Throwable> FluentThrowableAssertion<X, R> asFind(Class<X> throwableClass) {
        Throwable t = this.orElse(null);
        while (Utils.nn(t)) {
            if (throwableClass.isInstance(t)) {
                return new FluentThrowableAssertion(this, (Throwable)throwableClass.cast(t), this.returns());
            }
            t = t.getCause();
        }
        return new FluentThrowableAssertion(this, null, this.returns());
    }

    public FluentStringAssertion<R> asLocalizedMessage() {
        return new FluentStringAssertion((Assertion)this, this.map(Throwable::getLocalizedMessage).orElse(null), this.returns());
    }

    public FluentListAssertion<String, R> asLocalizedMessages() {
        List<String> l = null;
        Throwable t = this.orElse(null);
        if (Utils.nn(t)) {
            if (t.getCause() == null) {
                l = Collections.singletonList(t.getMessage());
            } else {
                l = CollectionUtils.list(new String[0]);
                while (Utils.nn(t)) {
                    l.add(ThrowableUtils.lm(t));
                    t = t.getCause();
                }
            }
        }
        return new FluentListAssertion((Assertion)this, l, this.returns());
    }

    public FluentStringAssertion<R> asMessage() {
        return new FluentStringAssertion((Assertion)this, this.map(Throwable::getMessage).orElse(null), this.returns());
    }

    public FluentListAssertion<String, R> asMessages() {
        List<String> l = null;
        Throwable t = this.orElse(null);
        if (Utils.nn(t)) {
            if (t.getCause() == null) {
                l = Collections.singletonList(t.getMessage());
            } else {
                l = CollectionUtils.list(new String[0]);
                while (Utils.nn(t)) {
                    l.add(t.getMessage());
                    t = t.getCause();
                }
            }
        }
        return new FluentListAssertion((Assertion)this, l, this.returns());
    }

    public FluentStringListAssertion<R> asStackTrace() {
        return new FluentStringListAssertion((Assertion)this, this.valueIsNull() ? null : CollectionUtils.l(ThrowableUtils.getStackTrace((Throwable)this.value())), this.returns());
    }

    @Override
    public FluentThrowableAssertion<T, R> asTransformed(Function<T, T> function) {
        return new FluentThrowableAssertion(this, (Throwable)function.apply(this.orElse(null)), this.returns());
    }

    @Override
    public R isExactType(Class<?> type) {
        AssertionUtils.assertArgNotNull("type", type);
        if (type != ((Throwable)this.value()).getClass()) {
            throw this.error(MSG_exceptionWasNotExpectedType, Utils.cn(type), Utils.cn(this.value()));
        }
        return this.returns();
    }

    @Override
    public R isExists() {
        if (this.valueIsNull()) {
            throw this.error(MSG_exceptionWasNotThrown, new Object[0]);
        }
        return this.returns();
    }

    @Override
    public R isType(Class<?> parent) {
        AssertionUtils.assertArgNotNull("parent", parent);
        if (!parent.isInstance(this.value())) {
            throw this.error(MSG_exceptionWasNotExpectedType, Utils.cn(parent), Utils.cn(this.value()));
        }
        return this.returns();
    }

    @Override
    public FluentThrowableAssertion<T, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentThrowableAssertion<T, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentThrowableAssertion<T, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentThrowableAssertion<T, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentThrowableAssertion<T, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    @Override
    protected boolean equals(Object o1, Object o2) {
        if (o1 instanceof Throwable) {
            Throwable o1t = (Throwable)o1;
            if (o2 instanceof Throwable) {
                Throwable o2t = (Throwable)o2;
                return Utils.eq(o1t, o2t, (x, y) -> Utils.eq(x.getClass(), y.getClass()) && Utils.eq(x.getMessage(), y.getMessage()));
            }
        }
        return super.equals(o1, o2);
    }
}

