/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.commons.lang.StringFormat;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.ExecutableInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class StringUtils {
    public static final AsciiSet COMMON_SEPARATORS = AsciiSet.of(",;:|\t");
    public static final String CRLF = "\r\n";
    public static final AsciiSet DECIMAL_CHARS = AsciiSet.of("0123456789");
    public static final AsciiSet DIGIT = AsciiSet.of("0123456789");
    public static final String EMPTY = "";
    public static final AsciiSet FIRST_NUMBER_CHARS = AsciiSet.of("+-.#0123456789");
    public static final AsciiSet HEXADECIMAL_CHARS = AsciiSet.of("0123456789abcdefABCDEF");
    public static final AsciiSet HTTP_HEADER_CHARS = AsciiSet.create().chars("\t -").ranges("!-[", "]-}").build();
    public static final AsciiSet LETTER = AsciiSet.create().ranges("a-z", "A-Z").build();
    public static final AsciiSet LETTER_LC = AsciiSet.create().range('a', 'z').build();
    public static final AsciiSet LETTER_UC = AsciiSet.create().range('A', 'Z').build();
    public static final AsciiSet MAP_ESCAPE_SET = AsciiSet.of(",=\\");
    public static final String NEWLINE = "\n";
    public static final Predicate<String> NOT_EMPTY = Utils::ne;
    public static final AsciiSet NUMBER_CHARS = AsciiSet.of("-xX.+-#pP0123456789abcdefABCDEF");
    public static final AsciiSet OCTAL_CHARS = AsciiSet.of("01234567");
    public static final AsciiSet QUOTE_ESCAPE_SET = AsciiSet.of("\"'\\");
    public static final String SPACE = " ";
    public static final String TAB = "\t";
    public static final AsciiSet URI_CHARS = AsciiSet.create().chars("?#+%;/:@&=+$,-_.!~*'()").range('0', '9').range('A', 'Z').range('a', 'z').build();
    public static final AsciiSet URL_ENCODE_PATHINFO_VALIDCHARS = AsciiSet.create().ranges("a-z", "A-Z", "0-9").chars("-_.*/()").build();
    public static final AsciiSet URL_UNENCODED_CHARS = AsciiSet.create().ranges("a-z", "A-Z", "0-9").chars("-_.!~*'()\\").build();
    public static final AsciiSet URL_UNENCODED_LAX_CHARS = URL_UNENCODED_CHARS.copy().chars(":@$,").chars("{}|\\^[]`").build();
    public static final AsciiSet VOWEL = AsciiSet.of("aeiouAEIOU");
    public static final AsciiSet WHITESPACE_CHARS = AsciiSet.of(" \t\n\r\f\u000b");
    private static final char[] BASE64M1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final byte[] BASE64M2 = new byte[128];
    private static final Random RANDOM;
    public static final Pattern FP_REGEX;
    static final Map<Character, AsciiSet> ESCAPE_SETS;
    private static final List<Readifier> READIFIERS;
    private static final Cache<Class<?>, Function<Object, String>> READIFIER_CACHE;
    private static final char[] HEX;

    public static String abbreviate(String in, int length) {
        if (in == null || in.length() <= length || in.length() <= 3) {
            return in;
        }
        return in.substring(0, length - 3) + "...";
    }

    public static StringBuilder append(StringBuilder sb, String in) {
        if (sb == null) {
            return new StringBuilder(in);
        }
        sb.append(in);
        return sb;
    }

    public static StringBuilder appendIfNotBlank(StringBuilder sb, String str) {
        if (StringUtils.isNotBlank(str)) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(str);
        }
        return sb;
    }

    public static StringBuilder appendIfNotEmpty(StringBuilder sb, String str) {
        if (Utils.ne(str)) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(str);
        }
        return sb;
    }

    public static StringBuilder appendWithSeparator(StringBuilder sb, String str, String separator) {
        if (str != null) {
            if (sb == null) {
                sb = new StringBuilder();
            } else if (sb.length() > 0 && separator != null) {
                sb.append(separator);
            }
            sb.append(str);
        }
        return sb;
    }

    public static String articlized(String subject) {
        return (VOWEL.contains(subject.charAt(0)) ? "an " : "a ") + subject;
    }

    public static byte[] base64Decode(String in) {
        int inLength;
        if (in == null) {
            return null;
        }
        byte[] bIn = in.getBytes(IoUtils.UTF8);
        AssertionUtils.assertArg(bIn.length % 4 == 0, "Invalid BASE64 string length.  Must be multiple of 4.", new Object[0]);
        for (inLength = bIn.length; inLength > 0 && bIn[inLength - 1] == 61; --inLength) {
        }
        int outLength = inLength * 3 / 4;
        byte[] out = new byte[outLength];
        int iIn = 0;
        int iOut = 0;
        while (iIn < inLength) {
            byte i0 = bIn[iIn++];
            byte i1 = bIn[iIn++];
            int i2 = iIn < inLength ? bIn[iIn++] : 65;
            int i3 = iIn < inLength ? bIn[iIn++] : 65;
            byte b0 = BASE64M2[i0];
            byte b1 = BASE64M2[i1];
            byte b2 = BASE64M2[i2];
            byte b3 = BASE64M2[i3];
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[iOut++] = (byte)o0;
            if (iOut < outLength) {
                out[iOut++] = (byte)o1;
            }
            if (iOut >= outLength) continue;
            out[iOut++] = (byte)o2;
        }
        return out;
    }

    public static String base64DecodeToString(String in) {
        byte[] b = StringUtils.base64Decode(in);
        if (b == null) {
            return null;
        }
        return new String(b, IoUtils.UTF8);
    }

    public static String base64Encode(byte[] in) {
        if (in == null) {
            return null;
        }
        int outLength = (in.length * 4 + 2) / 3;
        char[] out = new char[(in.length + 2) / 3 * 4];
        int iIn = 0;
        int iOut = 0;
        while (iIn < in.length) {
            int i0 = in[iIn++] & 0xFF;
            int i1 = iIn < in.length ? in[iIn++] & 0xFF : 0;
            int i2 = iIn < in.length ? in[iIn++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[iOut++] = BASE64M1[o0];
            out[iOut++] = BASE64M1[o1];
            out[iOut] = iOut < outLength ? BASE64M1[o2] : 61;
            int n = ++iOut < outLength ? BASE64M1[o3] : 61;
            out[iOut] = n;
            ++iOut;
        }
        return new String(out);
    }

    public static String base64EncodeToString(String in) {
        if (in == null) {
            return null;
        }
        return StringUtils.base64Encode(in.getBytes(IoUtils.UTF8));
    }

    public static String buildString(Consumer<StringBuilder> builder) {
        AssertionUtils.assertArgNotNull("builder", builder);
        StringBuilder sb = new StringBuilder();
        builder.accept(sb);
        return sb.toString();
    }

    public static String camelCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        List<String> words = StringUtils.splitWords(str);
        if (words.isEmpty()) {
            return EMPTY;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.size(); ++i) {
            String word = words.get(i);
            if (i == 0) {
                result.append(StringUtils.uncapitalize(word));
                continue;
            }
            result.append(StringUtils.capitalize(word.toLowerCase()));
        }
        return result.toString();
    }

    public static String capitalize(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static List<String> cdlToList(String s) {
        return StringUtils.split(s);
    }

    public static LinkedHashSet<String> cdlToSet(String s) {
        return StringUtils.split(s).stream().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static char charAt(String s, int i) {
        if (s == null || i < 0 || i >= s.length()) {
            return '\u0000';
        }
        return s.charAt(i);
    }

    public static String clean(String str) {
        if (str == null) {
            return null;
        }
        str = StringUtils.removeControlChars(str);
        return StringUtils.normalizeWhitespace(str);
    }

    public static int compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return Integer.MIN_VALUE;
        }
        if (s2 == null) {
            return Integer.MAX_VALUE;
        }
        return s1.compareTo(s2);
    }

    public static int compareIgnoreCase(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareToIgnoreCase(str2);
    }

    public static byte[] compress(String contents) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(contents.length() >> 1);
        try (GZIPOutputStream gos = new GZIPOutputStream(baos);){
            gos.write(contents.getBytes());
            gos.finish();
            gos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static boolean contains(String s, char c) {
        return s != null && s.indexOf(c) >= 0;
    }

    public static boolean contains(String value, CharSequence substring) {
        return Utils.nn(value) && value.contains(substring);
    }

    public static boolean contains(String s, String substring) {
        return Utils.nn(s) && s.contains(substring);
    }

    public static boolean containsAll(String s, char ... values) {
        if (s == null || values == null || values.length == 0) {
            return false;
        }
        for (char v : values) {
            if (s.indexOf(v) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(String s, CharSequence ... values) {
        if (s == null || values == null || values.length == 0) {
            return false;
        }
        for (CharSequence v : values) {
            if (s.contains(v)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(String s, String ... values) {
        if (s == null || values == null || values.length == 0) {
            return false;
        }
        for (String v : values) {
            if (s.contains(v)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAny(String s, char ... values) {
        if (s == null || values == null || values.length == 0) {
            return false;
        }
        for (char v : values) {
            if (s.indexOf(v) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String s, CharSequence ... values) {
        if (s == null || values == null || values.length == 0) {
            return false;
        }
        for (CharSequence v : values) {
            if (!s.contains(v)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String s, String ... values) {
        if (s == null || values == null || values.length == 0) {
            return false;
        }
        for (String v : values) {
            if (!s.contains(v)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String str, String search) {
        if (str == null || search == null) {
            return false;
        }
        return str.toLowerCase().contains(search.toLowerCase());
    }

    public static int countChars(String s, char c) {
        int count = 0;
        if (s == null) {
            return count;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static int countMatches(String str, String search) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(search)) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(search, index)) != -1) {
            ++count;
            index += search.length();
        }
        return count;
    }

    public static String decodeHex(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c < ' ' || c > '~') {
                sb.append("[").append(Integer.toHexString(c)).append("]");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String decompress(byte[] is) throws Exception {
        return IoUtils.read(new GZIPInputStream(new ByteArrayInputStream(is)));
    }

    public static String defaultIfBlank(String str, String defaultStr) {
        return StringUtils.isBlank(str) ? defaultStr : str;
    }

    public static String defaultIfEmpty(String str, String defaultStr) {
        return StringUtils.isEmpty(str) ? defaultStr : str;
    }

    public static int diffPosition(String s1, String s2) {
        int i;
        s1 = StringUtils.emptyIfNull(s1);
        s2 = StringUtils.emptyIfNull(s2);
        int len = Math.min(s1.length(), s2.length());
        for (i = 0; i < len; ++i) {
            int j = s1.charAt(i) - s2.charAt(i);
            if (j == 0) continue;
            return i;
        }
        if (Utils.eq(s1.length(), s2.length())) {
            return -1;
        }
        return i;
    }

    public static int diffPositionIc(String s1, String s2) {
        int i;
        s1 = StringUtils.emptyIfNull(s1);
        s2 = StringUtils.emptyIfNull(s2);
        int len = Math.min(s1.length(), s2.length());
        for (i = 0; i < len; ++i) {
            int j = Character.toLowerCase(s1.charAt(i)) - Character.toLowerCase(s2.charAt(i));
            if (j == 0) continue;
            return i;
        }
        if (Utils.eq(s1.length(), s2.length())) {
            return -1;
        }
        return i;
    }

    public static String[] distinct(String[] array) {
        if (array == null) {
            return null;
        }
        return Arrays.stream(array).collect(Collectors.toCollection(LinkedHashSet::new)).toArray(new String[0]);
    }

    public static String[] doubleMetaphone(String str) {
        String primary;
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        String alternate = primary = StringUtils.metaphone(str);
        return CollectionUtils.a(primary, alternate);
    }

    public static String emptyIfNull(String str) {
        return str == null ? EMPTY : str;
    }

    public static boolean endsWith(String s, char c) {
        int i;
        if (Utils.nn(s) && (i = s.length()) > 0) {
            return s.charAt(i - 1) == c;
        }
        return false;
    }

    public static boolean endsWith(String s, String suffix) {
        return s != null && s.endsWith(suffix);
    }

    public static boolean endsWithAny(String s, char ... c) {
        int i;
        if (Utils.nn(s) && (i = s.length()) > 0) {
            char c2 = s.charAt(i - 1);
            for (char cc : c) {
                if (c2 != cc) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean endsWithAny(String s, String ... suffixes) {
        if (s == null || suffixes == null || suffixes.length == 0) {
            return false;
        }
        for (String suffix : suffixes) {
            if (!s.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        if (str == null || suffix == null) {
            return false;
        }
        return str.toLowerCase().endsWith(suffix.toLowerCase());
    }

    public static double entropy(String str) {
        if (StringUtils.isEmpty(str)) {
            return 0.0;
        }
        int length = str.length();
        int[] charCounts = new int[65536];
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            charCounts[c] = charCounts[c] + 1;
        }
        double entropy = 0.0;
        for (int count : charCounts) {
            if (count <= 0) continue;
            double probability = (double)count / (double)length;
            entropy -= probability * (Math.log(probability) / Math.log(2.0));
        }
        return entropy;
    }

    public static boolean equalsIgnoreCase(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.toString().equalsIgnoreCase(b.toString());
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static String escapeChars(String s, AsciiSet escaped) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (!escaped.contains(s.charAt(i))) continue;
            ++count;
        }
        if (count == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() + count);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (escaped.contains(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapeForJava(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            sb.append(switch (c) {
                case '\"' -> "\\\"";
                case '\\' -> "\\\\";
                case '\n' -> "\\n";
                case '\r' -> "\\r";
                case '\t' -> "\\t";
                case '\f' -> "\\f";
                case '\b' -> "\\b";
                default -> c < ' ' || c > '~' ? String.format("\\u%04x", c) : String.valueOf(c);
            });
        }
        return sb.toString();
    }

    public static String escapeHtml(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(str.length() * 2);
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeRegex(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("\\", "\\\\").replace(".", "\\.").replace("*", "\\*").replace("+", "\\+").replace("?", "\\?").replace("^", "\\^").replace("$", "\\$").replace("{", "\\{").replace("}", "\\}").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("|", "\\|");
    }

    public static String escapeSql(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("'", "''");
    }

    public static String escapeXml(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(str.length() * 2);
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static List<String> extractBetween(String str, String start, String end) {
        int endPos;
        int startPos;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(start) || StringUtils.isEmpty(end)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        int startIndex = 0;
        while ((startPos = str.indexOf(start, startIndex)) != -1 && (endPos = str.indexOf(end, startPos + start.length())) != -1) {
            result.add(str.substring(startPos + start.length(), endPos));
            startIndex = endPos + end.length();
        }
        return result;
    }

    public static List<String> extractEmails(String str) {
        if (StringUtils.isEmpty(str)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    public static List<String> extractNumbers(String str) {
        if (StringUtils.isEmpty(str)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\d+(?:\\.\\d+)?");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    public static List<String> extractUrls(String str) {
        if (StringUtils.isEmpty(str)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(?:https?|ftp)://[\\w\\-._~:/?#\\[\\]@!$&'()*+,;=%]+", 2);
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    public static List<String> extractWords(String str) {
        if (StringUtils.isEmpty(str)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\w+");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    public static String[] filter(String[] array, Predicate<String> predicate) {
        if (array == null) {
            return null;
        }
        if (predicate == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(array).filter(predicate).toArray(String[]::new);
    }

    public static char firstChar(String s) {
        if (s == null || s.isEmpty()) {
            return '\u0000';
        }
        return s.charAt(0);
    }

    public static String firstNonBlank(String ... vals) {
        for (String v : vals) {
            if (!StringUtils.isNotBlank(v)) continue;
            return v;
        }
        return null;
    }

    public static String firstNonEmpty(String ... s) {
        for (String ss : s) {
            if (!Utils.ne(ss)) continue;
            return ss;
        }
        return null;
    }

    public static char firstNonWhitespaceChar(String s) {
        if (Utils.nn(s)) {
            for (int i = 0; i < s.length(); ++i) {
                if (StringUtils.isWhitespace(s.charAt(i))) continue;
                return s.charAt(i);
            }
        }
        return '\u0000';
    }

    public static String fixUrl(String in) {
        if (in == null) {
            return null;
        }
        StringBuilder sb = null;
        int m = 0;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (URI_CHARS.contains(c)) continue;
            sb = StringUtils.append(sb, in.substring(m, i));
            if (c == ' ') {
                sb.append("+");
            } else {
                sb.append('%').append(StringUtils.toHex2(c));
            }
            m = i + 1;
        }
        if (Utils.nn(sb)) {
            sb.append(in.substring(m));
            return sb.toString();
        }
        return in;
    }

    public static String format(String pattern, Object ... args) {
        return StringFormat.format(pattern, args);
    }

    public static String formatNamed(String s, Map<String, Object> m) {
        if (s == null) {
            return null;
        }
        if (m == null || m.isEmpty() || s.indexOf(123) == -1) {
            return s;
        }
        StateEnum state = StateEnum.S1;
        boolean hasInternalVar = false;
        int x = 0;
        int depth = 0;
        int length = s.length();
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            boolean keyExists;
            char c = s.charAt(i);
            if (state == StateEnum.S1) {
                if (c == '{') {
                    state = StateEnum.S2;
                    x = i;
                    continue;
                }
                out.append(c);
                continue;
            }
            if (c == '{') {
                ++depth;
                hasInternalVar = true;
                continue;
            }
            if (c != '}') continue;
            if (depth > 0) {
                --depth;
                continue;
            }
            String key = s.substring(x + 1, i);
            key = hasInternalVar ? StringUtils.formatNamed(key, m) : key;
            hasInternalVar = false;
            Object val = m.get(key);
            boolean bl = keyExists = m.containsKey(key) || Utils.nn(val);
            if (!keyExists) {
                out.append('{').append(key).append('}');
            } else {
                String v;
                if (val == null) {
                    val = EMPTY;
                }
                if ((v = Utils.r(val)).indexOf(123) != -1) {
                    v = StringUtils.formatNamed(v, m);
                }
                out.append(v);
            }
            state = StateEnum.S1;
        }
        return out.toString();
    }

    public static byte[] fromHex(String hex) {
        ByteBuffer buff = ByteBuffer.allocate(hex.length() / 2);
        for (int i = 0; i < hex.length(); i += 2) {
            buff.put((byte)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        buff.rewind();
        return buff.array();
    }

    public static String fromHexToUTF8(String hex) {
        ByteBuffer buff = ByteBuffer.allocate(hex.length() / 2);
        for (int i = 0; i < hex.length(); i += 2) {
            buff.put((byte)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        buff.rewind();
        return StandardCharsets.UTF_8.decode(buff).toString();
    }

    public static byte[] fromSpacedHex(String hex) {
        ByteBuffer buff = ByteBuffer.allocate((hex.length() + 1) / 3);
        for (int i = 0; i < hex.length(); i += 3) {
            buff.put((byte)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        buff.rewind();
        return buff.array();
    }

    public static String fromSpacedHexToUTF8(String hex) {
        ByteBuffer buff = ByteBuffer.allocate((hex.length() + 1) / 3);
        for (int i = 0; i < hex.length(); i += 3) {
            buff.put((byte)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        buff.rewind();
        return StandardCharsets.UTF_8.decode(buff).toString();
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getAuthorityUri(String s) {
        StateEnum state = StateEnum.S1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == StateEnum.S1) {
                if (StringUtils.isLowerCaseLetter(c)) {
                    state = StateEnum.S2;
                    continue;
                }
                return s;
            }
            if (state == StateEnum.S2) {
                if (c == ':') {
                    state = StateEnum.S3;
                    continue;
                }
                if (StringUtils.isLowerCaseLetter(c)) continue;
                return s;
            }
            if (state == StateEnum.S3) {
                if (c == '/') {
                    state = StateEnum.S4;
                    continue;
                }
                return s;
            }
            if (state == StateEnum.S4) {
                if (c == '/') {
                    state = StateEnum.S5;
                    continue;
                }
                return s;
            }
            if (state == StateEnum.S5) {
                if (c != '/') {
                    state = StateEnum.S6;
                    continue;
                }
                return s;
            }
            if (c != '/') continue;
            return s.substring(0, i);
        }
        return s;
    }

    public static long getDuration(String s) {
        if (StringUtils.isEmpty(s = StringUtils.trim(s))) {
            return -1L;
        }
        long totalMs = 0L;
        int i = 0;
        int len = s.length();
        while (i < len) {
            while (i < len && Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            int numStart = i;
            boolean hasDecimal = false;
            while (i < len) {
                char c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ++i;
                    continue;
                }
                if (c != '.' || hasDecimal) break;
                hasDecimal = true;
                ++i;
            }
            if (i == numStart) {
                return -1L;
            }
            String numStr = s.substring(numStart, i).trim();
            double value = Double.parseDouble(numStr);
            while (i < len && Character.isWhitespace(s.charAt(i))) {
                ++i;
            }
            int unitStart = i;
            while (i < len && LETTER.contains(s.charAt(i))) {
                ++i;
            }
            String unit = s.substring(unitStart, i).trim().toLowerCase();
            long ms = StringUtils.parseUnit(unit, value);
            if (ms < 0L) {
                return -1L;
            }
            totalMs += ms;
        }
        return totalMs;
    }

    public static Pattern getGlobMatchPattern(String s) {
        return StringUtils.getGlobMatchPattern(s, 0);
    }

    public static Pattern getGlobMatchPattern(String s, int flags) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\\Q");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '*') {
                sb.append("\\E").append(".*").append("\\Q");
                continue;
            }
            if (c == '?') {
                sb.append("\\E").append(".").append("\\Q");
                continue;
            }
            sb.append(c);
        }
        sb.append("\\E");
        return Pattern.compile(sb.toString(), flags);
    }

    public static Pattern getMatchPattern(String s) {
        return StringUtils.getMatchPattern(s, 0);
    }

    public static Pattern getMatchPattern(String s, int flags) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\\Q");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '*') {
                sb.append("\\E").append(".*").append("\\Q");
                continue;
            }
            if (c == '?') {
                sb.append("\\E").append(".").append("\\Q");
                continue;
            }
            sb.append(c);
        }
        sb.append("\\E");
        return Pattern.compile(sb.toString(), flags);
    }

    public static String getNumberedLines(String s) {
        return StringUtils.getNumberedLines(s, 1, Integer.MAX_VALUE);
    }

    public static String getNumberedLines(String s, int start, int end) {
        if (s == null) {
            return null;
        }
        String[] lines = s.split("[\r\n]+");
        int digits = String.valueOf(lines.length).length();
        if (start < 1) {
            start = 1;
        }
        if (end < 0) {
            end = Integer.MAX_VALUE;
        }
        if (end > lines.length) {
            end = lines.length;
        }
        StringBuilder sb = new StringBuilder();
        for (String l : CollectionUtils.l(lines).subList(start - 1, end)) {
            sb.append(String.format("%0" + digits + "d", start++)).append(": ").append(l).append(NEWLINE);
        }
        return sb.toString();
    }

    public static long getStringSize(String str) {
        if (str == null) {
            return 0L;
        }
        return 40L + 2L * (long)str.length();
    }

    public static boolean hasText(String str) {
        return StringUtils.isNotBlank(str);
    }

    public static int indexOf(String s, char ... c) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            for (char cc : c) {
                if (c2 != cc) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(String str, String search) {
        if (str == null || search == null) {
            return -1;
        }
        return str.indexOf(search);
    }

    public static int indexOfIgnoreCase(String str, String search) {
        if (str == null || search == null) {
            return -1;
        }
        return str.toLowerCase().indexOf(search.toLowerCase());
    }

    public static String intern(String str) {
        return str == null ? null : str.intern();
    }

    public static String interpolate(String template, Map<String, Object> variables) {
        if (template == null) {
            return null;
        }
        if (variables == null || variables.isEmpty()) {
            return template;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        int length = template.length();
        while (i < length) {
            int dollarIndex = template.indexOf("${", i);
            if (dollarIndex == -1) {
                result.append(template.substring(i));
                break;
            }
            result.append(template.substring(i, dollarIndex));
            int braceIndex = template.indexOf(125, dollarIndex + 2);
            if (braceIndex == -1) {
                result.append(template.substring(dollarIndex));
                break;
            }
            String varName = template.substring(dollarIndex + 2, braceIndex);
            Object value = variables.get(varName);
            if (variables.containsKey(varName)) {
                result.append(value != null ? value.toString() : "null");
            } else {
                result.append("${").append(varName).append("}");
            }
            i = braceIndex + 1;
        }
        return result.toString();
    }

    public static boolean isAbsoluteUri(String s) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        StateEnum state = StateEnum.S1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == StateEnum.S1) {
                if (StringUtils.isLowerCaseLetter(c)) {
                    state = StateEnum.S2;
                    continue;
                }
                return false;
            }
            if (state == StateEnum.S2) {
                if (c == ':') {
                    state = StateEnum.S3;
                    continue;
                }
                if (StringUtils.isLowerCaseLetter(c)) continue;
                return false;
            }
            if (state == StateEnum.S3) {
                if (c == '/') {
                    state = StateEnum.S4;
                    continue;
                }
                return false;
            }
            if (state == StateEnum.S4) {
                if (c == '/') {
                    state = StateEnum.S5;
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isAllNotBlank(CharSequence ... values) {
        if (values == null || values.length == 0) {
            return false;
        }
        for (CharSequence value : values) {
            if (StringUtils.isNotBlank(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... values) {
        if (values == null || values.length == 0) {
            return false;
        }
        for (CharSequence value : values) {
            if (value != null && !value.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (LETTER.contains(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (LETTER.contains(str.charAt(i)) || DIGIT.contains(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyNotBlank(CharSequence ... values) {
        if (values == null) {
            return false;
        }
        for (CharSequence value : values) {
            if (!StringUtils.isNotBlank(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyNotEmpty(CharSequence ... values) {
        if (values == null) {
            return false;
        }
        for (CharSequence value : values) {
            if (value == null || value.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(CharSequence str) {
        return str == null || str.toString().isBlank();
    }

    public static boolean isCreditCard(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        String cleaned = str.replaceAll("[\\s\\-]", EMPTY);
        if (!cleaned.matches("^\\d{13,19}$")) {
            return false;
        }
        int sum = 0;
        boolean alternate = false;
        for (int i = cleaned.length() - 1; i >= 0; --i) {
            int digit = Character.getNumericValue(cleaned.charAt(i));
            if (alternate && (digit *= 2) > 9) {
                digit = digit % 10 + 1;
            }
            sum += digit;
            alternate = !alternate;
        }
        return sum % 10 == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDecimal(String s) {
        if (s == null || s.isEmpty() || !FIRST_NUMBER_CHARS.contains(s.charAt(0))) {
            return false;
        }
        int i = 0;
        int length = s.length();
        char c = s.charAt(0);
        boolean isPrefixed = false;
        if (c == '+' || c == '-') {
            isPrefixed = true;
            ++i;
        }
        if (i == length) {
            return false;
        }
        if ((c = s.charAt(i++)) == '0' && length > (isPrefixed ? 2 : 1)) {
            if ((c = s.charAt(i++)) == 'x' || c == 'X') {
                for (int j = i; j < length; ++j) {
                    if (HEXADECIMAL_CHARS.contains(s.charAt(j))) continue;
                    return false;
                }
                return true;
            } else {
                if (!OCTAL_CHARS.contains(c)) return false;
                for (int j = i; j < length; ++j) {
                    if (OCTAL_CHARS.contains(s.charAt(j))) continue;
                    return false;
                }
            }
            return true;
        } else if (c == '#') {
            for (int j = i; j < length; ++j) {
                if (HEXADECIMAL_CHARS.contains(s.charAt(j))) continue;
                return false;
            }
            return true;
        } else {
            if (!DECIMAL_CHARS.contains(c)) return false;
            for (int j = i; j < length; ++j) {
                if (DECIMAL_CHARS.contains(s.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isDigit(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (DIGIT.contains(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmail(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return str.matches("^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}$");
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isFirstNumberChar(char c) {
        return FIRST_NUMBER_CHARS.contains(c);
    }

    public static boolean isFloat(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (!FIRST_NUMBER_CHARS.contains(s.charAt(0))) {
            return s.equals("NaN") || s.equals("Infinity");
        }
        int i = 0;
        int length = s.length();
        char c = s.charAt(0);
        if (c == '+' || c == '-') {
            ++i;
        }
        if (i == length) {
            return false;
        }
        c = s.charAt(i);
        if (c == '.' || DECIMAL_CHARS.contains(c)) {
            return FP_REGEX.matcher(s).matches();
        }
        return false;
    }

    public static boolean isInterned(String str) {
        if (str == null) {
            return false;
        }
        return str == str.intern();
    }

    public static boolean isProbablyJson(String s) {
        if (s == null) {
            return false;
        }
        char c1 = StringUtils.firstNonWhitespaceChar(s);
        char c2 = StringUtils.lastNonWhitespaceChar(s);
        if (c1 == '{' && c2 == '}' || c1 == '[' && c2 == ']' || c1 == '\'' && c2 == '\'') {
            return true;
        }
        return StringUtils.isOneOf(s, "true", "false", "null") || StringUtils.isNumeric(s);
    }

    public static boolean isProbablyJsonArray(Object o, boolean ignoreWhitespaceAndComments) {
        if (o instanceof CharSequence) {
            CharSequence o2 = (CharSequence)o;
            String s = o2.toString();
            if (!ignoreWhitespaceAndComments) {
                return s.startsWith("[") && s.endsWith("]");
            }
            if (StringUtils.firstRealCharacter(s) != 91) {
                return false;
            }
            int i = s.lastIndexOf(93);
            if (i == -1) {
                return false;
            }
            return StringUtils.firstRealCharacter(s = s.substring(i + 1)) == -1;
        }
        return false;
    }

    public static boolean isProbablyJsonObject(Object o, boolean ignoreWhitespaceAndComments) {
        if (o instanceof CharSequence) {
            CharSequence o2 = (CharSequence)o;
            String s = o2.toString();
            if (!ignoreWhitespaceAndComments) {
                return s.startsWith("{") && s.endsWith("}");
            }
            if (StringUtils.firstRealCharacter(s) != 123) {
                return false;
            }
            int i = s.lastIndexOf(125);
            if (i == -1) {
                return false;
            }
            return StringUtils.firstRealCharacter(s = s.substring(i + 1)) == -1;
        }
        return false;
    }

    public static boolean isNotBlank(CharSequence str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean isNumberChar(char c) {
        return NUMBER_CHARS.contains(c);
    }

    public static boolean isNumeric(String s) {
        if (s == null || s.isEmpty() || !StringUtils.isFirstNumberChar(s.charAt(0))) {
            return false;
        }
        return StringUtils.isDecimal(s) || StringUtils.isFloat(s);
    }

    public static boolean isOneOf(String s, String ... values) {
        AssertionUtils.assertArgNotNull("values", values);
        for (String value : values) {
            if (!Utils.eq(s, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPhoneNumber(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        String cleaned = str.replaceAll("[\\s()\\-\\.]", EMPTY);
        if (cleaned.startsWith("+")) {
            cleaned = cleaned.substring(1);
        }
        return cleaned.matches("^\\d{10,15}$");
    }

    public static boolean isSimilar(String str1, String str2, double threshold) {
        return StringUtils.similarity(str1, str2) >= threshold;
    }

    public static boolean isUri(String s) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        StateEnum state = StateEnum.S1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == StateEnum.S1) {
                if (StringUtils.isLowerCaseLetter(c)) {
                    state = StateEnum.S2;
                    continue;
                }
                return false;
            }
            if (state == StateEnum.S2) {
                if (StringUtils.isLowerCaseLetter(c)) {
                    state = StateEnum.S3;
                    continue;
                }
                return false;
            }
            if (state == StateEnum.S3) {
                if (c == ':') {
                    state = StateEnum.S4;
                    continue;
                }
                if (StringUtils.isLowerCaseLetter(c)) continue;
                return false;
            }
            return c == '/';
        }
        return false;
    }

    private static boolean isLowerCaseLetter(char c) {
        if (c < 'a') {
            return false;
        }
        return c <= 'z';
    }

    public static boolean isValidDateFormat(String dateStr, String format) {
        if (StringUtils.isEmpty(dateStr) || StringUtils.isEmpty(format)) {
            return false;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setLenient(false);
            sdf.parse(dateStr);
            return true;
        }
        catch (IllegalArgumentException | ParseException e) {
            return false;
        }
    }

    public static boolean isValidHostname(String hostname) {
        String[] labels;
        if (StringUtils.isEmpty(hostname)) {
            return false;
        }
        if (hostname.startsWith(".") || hostname.endsWith(".")) {
            return false;
        }
        if (hostname.length() > 253) {
            return false;
        }
        for (String label : labels = hostname.split("\\.", -1)) {
            if (label.isEmpty()) {
                return false;
            }
            if (label.length() > 63) {
                return false;
            }
            if (label.startsWith("-") || label.endsWith("-")) {
                return false;
            }
            if (label.matches("^[a-zA-Z0-9-]+$")) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidIpAddress(String ip) {
        if (StringUtils.isEmpty(ip)) {
            return false;
        }
        try {
            if (ip.contains(".") && !ip.contains(":")) {
                String[] parts = ip.split("\\.");
                if (parts.length != 4) {
                    return false;
                }
                for (String part : parts) {
                    int num = Integer.parseInt(part);
                    if (num >= 0 && num <= 255) continue;
                    return false;
                }
                return true;
            }
            if (ip.contains(":")) {
                return StringUtils.isValidIPv6Address(ip);
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidMacAddress(String mac) {
        if (StringUtils.isEmpty(mac)) {
            return false;
        }
        String cleaned = mac.replaceAll("[:-]", EMPTY).toUpperCase();
        if (cleaned.length() != 12) {
            return false;
        }
        return cleaned.matches("^[0-9A-F]{12}$");
    }

    public static boolean isValidRegex(String regex) {
        if (StringUtils.isEmpty(regex)) {
            return false;
        }
        try {
            Pattern.compile(regex);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public static boolean isValidTimeFormat(String timeStr, String format) {
        if (StringUtils.isEmpty(timeStr) || StringUtils.isEmpty(format)) {
            return false;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setLenient(false);
            sdf.parse(timeStr);
            return true;
        }
        catch (IllegalArgumentException | ParseException e) {
            return false;
        }
    }

    public static boolean isWhitespace(int c) {
        return Character.isWhitespace(c);
    }

    public static boolean isWhitespace(String str) {
        if (str == null) {
            return false;
        }
        if (str.isEmpty()) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtils.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String join(Collection<?> values) {
        return StringUtils.joine(CollectionUtils.toList(values), ',');
    }

    public static String join(Collection<?> tokens, char d) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> iter = tokens.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(d);
        }
        return sb.toString();
    }

    public static String join(Collection<?> tokens, String d) {
        if (tokens == null) {
            return null;
        }
        return StringUtils.join(tokens, d, new StringBuilder()).toString();
    }

    public static StringBuilder join(Collection<?> tokens, String d, StringBuilder sb) {
        if (tokens == null) {
            return sb;
        }
        Iterator<?> iter = tokens.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(d);
        }
        return sb;
    }

    public static String join(int[] tokens, char d) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public static String join(int[] array, String delimiter) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        if (delimiter == null) {
            delimiter = EMPTY;
        }
        return Arrays.stream(array).mapToObj(String::valueOf).collect(Collectors.joining(delimiter));
    }

    public static String join(Object[] tokens, char d) {
        if (tokens == null) {
            return null;
        }
        if (tokens.length == 1) {
            return StringUtils.emptyIfNull(Utils.s(tokens[0]));
        }
        return StringUtils.join(tokens, d, new StringBuilder()).toString();
    }

    public static StringBuilder join(Object[] tokens, char d, StringBuilder sb) {
        if (tokens == null) {
            return sb;
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(tokens[i]);
        }
        return sb;
    }

    public static String join(Object[] tokens, String separator) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public static String join(String ... values) {
        return StringUtils.join((Object[])values, ',');
    }

    public static String joine(List<?> tokens, char d) {
        if (tokens == null) {
            return null;
        }
        AsciiSet as = StringUtils.getEscapeSet(d);
        StringBuilder sb = new StringBuilder();
        int j = tokens.size();
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(StringUtils.escapeChars(Utils.s(tokens.get(i)), as));
        }
        return sb.toString();
    }

    public static String joinnl(Object[] tokens) {
        return StringUtils.join(tokens, '\n');
    }

    public static String kebabCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        List<String> words = StringUtils.splitWords(str);
        if (words.isEmpty()) {
            return EMPTY;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.size(); ++i) {
            if (i > 0) {
                result.append('-');
            }
            result.append(words.get(i).toLowerCase());
        }
        return result.toString();
    }

    public static int lastIndexOf(String str, String search) {
        if (str == null || search == null) {
            return -1;
        }
        return str.lastIndexOf(search);
    }

    public static int lastIndexOfIgnoreCase(String str, String search) {
        if (str == null || search == null) {
            return -1;
        }
        return str.toLowerCase().lastIndexOf(search.toLowerCase());
    }

    public static char lastNonWhitespaceChar(String s) {
        if (Utils.nn(s)) {
            for (int i = s.length() - 1; i >= 0; --i) {
                if (StringUtils.isWhitespace(s.charAt(i))) continue;
                return s.charAt(i);
            }
        }
        return '\u0000';
    }

    public static String left(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (len >= str.length()) {
            return str;
        }
        return str.substring(0, len);
    }

    public static int levenshteinDistance(String str1, String str2) {
        if (str1 == null) {
            str1 = EMPTY;
        }
        if (str2 == null) {
            str2 = EMPTY;
        }
        int len1 = str1.length();
        int len2 = str2.length();
        int[] prev = new int[len2 + 1];
        int[] curr = new int[len2 + 1];
        for (int j = 0; j <= len2; ++j) {
            prev[j] = j;
        }
        for (int i = 1; i <= len1; ++i) {
            curr[0] = i;
            for (int j = 1; j <= len2; ++j) {
                curr[j] = str1.charAt(i - 1) == str2.charAt(j - 1) ? prev[j - 1] : 1 + Math.min(Math.min(prev[j], curr[j - 1]), prev[j - 1]);
            }
            int[] temp = prev;
            prev = curr;
            curr = temp;
        }
        return prev[len2];
    }

    public static int lineCount(String str) {
        if (StringUtils.isEmpty(str)) {
            return 0;
        }
        int count = 1;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < str.length() && str.charAt(i + 1) == '\n') {
                ++i;
            }
            ++count;
        }
        return count;
    }

    public static String lowerCase(String s) {
        return s == null ? null : s.toLowerCase();
    }

    public static String[] mapped(String[] array, Function<String, String> mapper) {
        if (array == null) {
            return null;
        }
        if (mapper == null) {
            return Arrays.copyOf(array, array.length);
        }
        return (String[])Arrays.stream(array).map(mapper).toArray(String[]::new);
    }

    public static boolean matches(String str, String regex) {
        if (str == null || regex == null) {
            return false;
        }
        return str.matches(regex);
    }

    public static String metaphone(String str) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        String upper = str.toUpperCase().replaceAll("[^A-Z]", EMPTY);
        if (upper.isEmpty()) {
            return EMPTY;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        int len = upper.length();
        if (upper.startsWith("KN") || upper.startsWith("GN") || upper.startsWith("PN") || upper.startsWith("AE") || upper.startsWith("WR")) {
            i = 1;
        } else if (upper.startsWith("X")) {
            result.append('S');
            i = 1;
        } else if (upper.startsWith("WH")) {
            result.append('W');
            i = 2;
        }
        while (i < len && result.length() < 4) {
            char next2;
            char c = upper.charAt(i);
            char prev = i > 0 ? upper.charAt(i - 1) : (char)'\u0000';
            char next = i < len - 1 ? upper.charAt(i + 1) : (char)'\u0000';
            char c2 = next2 = i < len - 2 ? upper.charAt(i + 2) : (char)'\u0000';
            if (c == prev && c != 'C') {
                ++i;
                continue;
            }
            switch (c) {
                case 'B': {
                    if (prev == 'M' && next == '\u0000') break;
                    result.append('B');
                    break;
                }
                case 'C': {
                    if (next == 'H') {
                        if (prev == 'S') {
                            result.append('K');
                        } else {
                            result.append('X');
                        }
                        ++i;
                        break;
                    }
                    if (next == 'I' || next == 'E' || next == 'Y') {
                        result.append('S');
                        break;
                    }
                    result.append('K');
                    break;
                }
                case 'D': {
                    if (next == 'G' && (next2 == 'E' || next2 == 'I' || next2 == 'Y')) {
                        result.append('J');
                        ++i;
                        break;
                    }
                    result.append('T');
                    break;
                }
                case 'F': 
                case 'J': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'R': {
                    result.append(c);
                    break;
                }
                case 'G': {
                    if (next == 'H' && (next2 == 'A' || next2 == 'E' || next2 == 'I' || next2 == 'O' || next2 == 'U') || next == 'N' && (next2 == 'E' || next2 == 'D')) break;
                    if ((next == 'E' || next == 'I' || next == 'Y') && prev != 'G') {
                        result.append('J');
                        break;
                    }
                    result.append('K');
                    break;
                }
                case 'H': {
                    if (VOWEL.contains(prev) && VOWEL.contains(next)) break;
                    result.append('H');
                    break;
                }
                case 'K': {
                    if (prev == 'C') break;
                    result.append('K');
                    break;
                }
                case 'P': {
                    if (next == 'H') {
                        result.append('F');
                        ++i;
                        break;
                    }
                    result.append('P');
                    break;
                }
                case 'Q': {
                    result.append('K');
                    break;
                }
                case 'S': {
                    if (next == 'H') {
                        result.append('X');
                        ++i;
                        break;
                    }
                    if (next == 'I' && (next2 == 'O' || next2 == 'A')) {
                        result.append('X');
                        ++i;
                        break;
                    }
                    result.append('S');
                    break;
                }
                case 'T': {
                    if (next == 'H') {
                        result.append('0');
                        ++i;
                        break;
                    }
                    if (next == 'I' && (next2 == 'O' || next2 == 'A')) {
                        result.append('X');
                        ++i;
                        break;
                    }
                    result.append('T');
                    break;
                }
                case 'V': {
                    result.append('F');
                    break;
                }
                case 'W': 
                case 'Y': {
                    if (!VOWEL.contains(next)) break;
                    result.append(c);
                    break;
                }
                case 'X': {
                    result.append("KS");
                    break;
                }
                case 'Z': {
                    result.append('S');
                    break;
                }
            }
            ++i;
        }
        return result.length() > 0 ? result.toString() : upper.substring(0, Math.min(1, upper.length()));
    }

    public static String mid(String str, int pos, int len) {
        if (str == null) {
            return null;
        }
        if (pos < 0 || len < 0) {
            return EMPTY;
        }
        if (pos >= str.length()) {
            return EMPTY;
        }
        int end = Math.min(pos + len, str.length());
        return str.substring(pos, end);
    }

    public static char mostFrequentChar(String str) {
        if (StringUtils.isEmpty(str)) {
            return '\u0000';
        }
        int[] charCounts = new int[65536];
        int maxCount = 0;
        char maxChar = '\u0000';
        for (int i = 0; i < str.length(); ++i) {
            char c;
            char c2 = c = str.charAt(i);
            charCounts[c2] = charCounts[c2] + 1;
            if (charCounts[c] <= maxCount) continue;
            maxCount = charCounts[c];
            maxChar = c;
        }
        return maxChar;
    }

    public static int naturalCompare(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        int len1 = str1.length();
        int len2 = str2.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < len1 && i2 < len2) {
            char c1 = str1.charAt(i1);
            char c2 = str2.charAt(i2);
            if (DIGIT.contains(c1) && DIGIT.contains(c2)) {
                int end1;
                while (i1 < len1 && str1.charAt(i1) == '0') {
                    ++i1;
                }
                while (i2 < len2 && str2.charAt(i2) == '0') {
                    ++i2;
                }
                int end2 = i2;
                for (end1 = i1; end1 < len1 && DIGIT.contains(str1.charAt(end1)); ++end1) {
                }
                while (end2 < len2 && DIGIT.contains(str2.charAt(end2))) {
                    ++end2;
                }
                int lenNum1 = end1 - i1;
                int lenNum2 = end2 - i2;
                if (lenNum1 != lenNum2) {
                    return lenNum1 - lenNum2;
                }
                for (int j = 0; j < lenNum1; ++j) {
                    char d2;
                    char d1 = str1.charAt(i1 + j);
                    if (d1 == (d2 = str2.charAt(i2 + j))) continue;
                    return d1 - d2;
                }
                i1 = end1;
                i2 = end2;
                continue;
            }
            int cmp = Character.toLowerCase(c1) - Character.toLowerCase(c2);
            if (cmp != 0) {
                return cmp;
            }
            ++i1;
            ++i2;
        }
        return len1 - len2;
    }

    public static String normalizeUnicode(String str) {
        if (str == null) {
            return null;
        }
        return Normalizer.normalize(str, Normalizer.Form.NFD);
    }

    public static String normalizeWhitespace(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\s+", SPACE).trim();
    }

    public static boolean notContains(String s, char c) {
        return !StringUtils.contains(s, c);
    }

    public static boolean notContains(String s, CharSequence substring) {
        return !StringUtils.contains(s, substring);
    }

    public static boolean notContains(String s, String substring) {
        return !StringUtils.contains(s, substring);
    }

    public static boolean notContainsAll(String s, char ... values) {
        return !StringUtils.containsAll(s, values);
    }

    public static boolean notContainsAll(String s, CharSequence ... values) {
        return !StringUtils.containsAll(s, values);
    }

    public static boolean notContainsAll(String s, String ... values) {
        return !StringUtils.containsAll(s, values);
    }

    public static boolean notContainsAny(String s, char ... values) {
        return !StringUtils.containsAny(s, values);
    }

    public static boolean notContainsAny(String s, CharSequence ... values) {
        return !StringUtils.containsAny(s, values);
    }

    public static boolean notContainsAny(String s, String ... values) {
        return !StringUtils.containsAny(s, values);
    }

    public static String obfuscate(String s) {
        if (s == null || s.length() < 2) {
            return "*";
        }
        return s.substring(0, 1) + s.substring(1).replaceAll(".", "*");
    }

    public static String ordinal(int number) {
        int abs = Math.abs(number);
        String suffix = "th";
        if (abs % 100 != 11 && abs % 100 != 12 && abs % 100 != 13) {
            int lastDigit = abs % 10;
            if (lastDigit == 1) {
                suffix = "st";
            } else if (lastDigit == 2) {
                suffix = "nd";
            } else if (lastDigit == 3) {
                suffix = "rd";
            }
        }
        return number + suffix;
    }

    public static String padCenter(String str, int size, char padChar) {
        int pads;
        if (str == null) {
            str = EMPTY;
        }
        if ((pads = size - str.length()) <= 0) {
            return str;
        }
        int rightPads = pads / 2;
        int leftPads = pads - rightPads;
        return String.valueOf(padChar).repeat(leftPads) + str + String.valueOf(padChar).repeat(rightPads);
    }

    public static String padLeft(String str, int size, char padChar) {
        int pads;
        if (str == null) {
            str = EMPTY;
        }
        if ((pads = size - str.length()) <= 0) {
            return str;
        }
        return String.valueOf(padChar).repeat(pads) + str;
    }

    public static String padRight(String str, int size, char padChar) {
        int pads;
        if (str == null) {
            str = EMPTY;
        }
        if ((pads = size - str.length()) <= 0) {
            return str;
        }
        return str + String.valueOf(padChar).repeat(pads);
    }

    public static Character parseCharacter(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (s.isEmpty()) {
            return null;
        }
        if (s.length() == 1) {
            return Character.valueOf(s.charAt(0));
        }
        throw ThrowableUtils.illegalArg("Invalid character: ''{0}''", s);
    }

    public static float parseFloat(String value) {
        return Float.parseFloat(StringUtils.removeUnderscores(value));
    }

    public static int parseInt(String value) {
        return Integer.parseInt(StringUtils.removeUnderscores(value));
    }

    public static int parseIntWithSuffix(String s) {
        AssertionUtils.assertArgNotNull("s", s);
        int m = StringUtils.multiplierInt(s);
        if (m == 1) {
            return Integer.decode(s);
        }
        return Integer.decode(s.substring(0, s.length() - 1).trim()) * m;
    }

    public static long parseLong(String value) {
        return Long.parseLong(StringUtils.removeUnderscores(value));
    }

    public static long parseLongWithSuffix(String s) {
        AssertionUtils.assertArgNotNull("s", s);
        long m = StringUtils.multiplierLong(s);
        if (m == 1L) {
            return Long.decode(s);
        }
        String baseStr = s.substring(0, s.length() - 1).trim();
        Long base = Long.decode(baseStr);
        try {
            return Math.multiplyExact((long)base, m);
        }
        catch (ArithmeticException e) {
            throw new NumberFormatException("Value " + s + " exceeds Long.MAX_VALUE");
        }
    }

    public static Map<String, String> parseMap(String str, char keyValueDelimiter, char entryDelimiter, boolean trimKeys) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (StringUtils.isEmpty(str)) {
            return result;
        }
        List<String> entries = StringUtils.split(str, entryDelimiter);
        for (String entry : entries) {
            String key;
            if (StringUtils.isEmpty(entry)) continue;
            int delimiterIndex = entry.indexOf(keyValueDelimiter);
            if (delimiterIndex == -1) {
                key = trimKeys ? entry.trim() : entry;
                result.put(key, EMPTY);
                continue;
            }
            key = entry.substring(0, delimiterIndex);
            String value = entry.substring(delimiterIndex + 1);
            if (trimKeys) {
                key = key.trim();
                value = value.trim();
            }
            result.put(key, value);
        }
        return result;
    }

    public static Number parseNumber(String s, Class<? extends Number> type) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            s = "0";
        }
        if (type == null) {
            type = Number.class;
        }
        s = s.replace("_", EMPTY);
        boolean isAutoDetect = type == Number.class;
        boolean isDecimal = false;
        if (isAutoDetect) {
            isDecimal = StringUtils.isDecimal(s);
            if (isDecimal) {
                type = s.length() > 20 ? Double.class : (s.length() >= 10 ? Long.class : Integer.class);
            } else if (StringUtils.isFloat(s)) {
                type = Double.class;
            } else {
                throw new NumberFormatException(s);
            }
        }
        if (type == Double.class || type == Double.TYPE) {
            Double d = Double.valueOf(s);
            Float f = Float.valueOf(s);
            if (isAutoDetect && !isDecimal && d.toString().equals(f.toString())) {
                return f;
            }
            return d;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(s);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(s);
        }
        if (type == Long.class || type == Long.TYPE || type == AtomicLong.class) {
            try {
                long l = StringUtils.parseLongWithSuffix(s);
                if (type == AtomicLong.class) {
                    return new AtomicLong(l);
                }
                if (isAutoDetect && l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                    return (int)l;
                }
                return l;
            }
            catch (NumberFormatException e) {
                if (isAutoDetect) {
                    return Double.valueOf(s);
                }
                throw e;
            }
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.decode(s);
        }
        if (type == Short.class || type == Short.TYPE) {
            return Short.decode(s);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return Byte.decode(s);
        }
        if (type == BigInteger.class) {
            return new BigInteger(s);
        }
        if (type == AtomicInteger.class) {
            return new AtomicInteger(Integer.decode(s));
        }
        throw new NumberFormatException("Unsupported Number type: " + type.getName());
    }

    public static String pascalCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        List<String> words = StringUtils.splitWords(str);
        if (words.isEmpty()) {
            return EMPTY;
        }
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            result.append(StringUtils.capitalize(word.toLowerCase()));
        }
        return result.toString();
    }

    public static String pluralize(String word, int count) {
        char secondLast;
        if (word == null || word.isEmpty()) {
            return word;
        }
        if (count == 1) {
            return word;
        }
        String lower = word.toLowerCase();
        int length = word.length();
        if (lower.endsWith("s") || lower.endsWith("x") || lower.endsWith("z") || lower.endsWith("ch") || lower.endsWith("sh")) {
            return word + "es";
        }
        if (length > 1 && lower.endsWith("y") && !VOWEL.contains(secondLast = lower.charAt(length - 2))) {
            return word.substring(0, length - 1) + "ies";
        }
        if (lower.endsWith("f")) {
            return word.substring(0, length - 1) + "ves";
        }
        if (lower.endsWith("fe")) {
            return word.substring(0, length - 2) + "ves";
        }
        return word + "s";
    }

    public static String random(int numchars) {
        StringBuilder sb = new StringBuilder(numchars);
        for (int i = 0; i < numchars; ++i) {
            int c = RANDOM.nextInt(36) + 97;
            if (c > 122) {
                c -= 75;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String randomAlphabetic(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be non-negative: " + length);
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int c = RANDOM.nextInt(52);
            if (c < 26) {
                sb.append((char)(97 + c));
                continue;
            }
            sb.append((char)(65 + c - 26));
        }
        return sb.toString();
    }

    public static String randomAlphanumeric(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be non-negative: " + length);
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int c = RANDOM.nextInt(62);
            if (c < 10) {
                sb.append((char)(48 + c));
                continue;
            }
            if (c < 36) {
                sb.append((char)(97 + c - 10));
                continue;
            }
            sb.append((char)(65 + c - 36));
        }
        return sb.toString();
    }

    public static String randomAscii(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be non-negative: " + length);
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append((char)(32 + RANDOM.nextInt(95)));
        }
        return sb.toString();
    }

    public static String randomNumeric(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be non-negative: " + length);
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append((char)(48 + RANDOM.nextInt(10)));
        }
        return sb.toString();
    }

    public static String randomString(int length, String chars) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be non-negative: " + length);
        }
        if (chars == null || chars.isEmpty()) {
            throw new IllegalArgumentException("Character set must not be null or empty");
        }
        StringBuilder sb = new StringBuilder(length);
        int charsLen = chars.length();
        for (int i = 0; i < length; ++i) {
            sb.append(chars.charAt(RANDOM.nextInt(charsLen)));
        }
        return sb.toString();
    }

    public static double readabilityScore(String str) {
        if (StringUtils.isEmpty(str)) {
            return 0.0;
        }
        List<String> words = StringUtils.extractWords(str);
        if (words.isEmpty()) {
            return 0.0;
        }
        int sentenceCount = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '.' && c != '!' && c != '?') continue;
            ++sentenceCount;
        }
        if (sentenceCount == 0) {
            sentenceCount = 1;
        }
        double avgWordsPerSentence = (double)words.size() / (double)sentenceCount;
        int totalSyllables = 0;
        for (String word : words) {
            totalSyllables += StringUtils.estimateSyllables(word);
        }
        double avgSyllablesPerWord = (double)totalSyllables / (double)words.size();
        double score = 206.835 - 1.015 * avgWordsPerSentence - 84.6 * avgSyllablesPerWord;
        return Math.max(0.0, Math.min(100.0, score));
    }

    public static String readable(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (c == byte[].class) {
            return StringUtils.toHex((byte[])o);
        }
        Function f = READIFIER_CACHE.get(c, () -> {
            Function readifier = READIFIERS.stream().filter(r -> r.forClass() == c || r.forClass().isAssignableFrom(c)).map(Readifier::toFunction).findFirst().orElse(null);
            if (readifier != null) {
                return readifier;
            }
            if (c.isArray()) {
                return x -> {
                    List<Object> l = CollectionUtils.list(new Object[0]);
                    for (int i = 0; i < Array.getLength(x); ++i) {
                        l.add(Array.get(x, i));
                    }
                    return StringUtils.readable(l);
                };
            }
            return x -> x.toString();
        });
        return (String)f.apply(o);
    }

    public static String remove(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        return str.replace(remove, EMPTY);
    }

    public static String removeAccents(String str) {
        if (str == null) {
            return null;
        }
        String normalized = Normalizer.normalize(str, Normalizer.Form.NFD);
        StringBuilder sb = new StringBuilder(normalized.length());
        for (int i = 0; i < normalized.length(); ++i) {
            char c = normalized.charAt(i);
            int type = Character.getType(c);
            if (type == 6) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String removeAll(String str, String ... remove) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(str) || remove == null || remove.length == 0) {
            return str;
        }
        String result = str;
        for (String r : remove) {
            if (r == null) continue;
            result = result.replace(r, EMPTY);
        }
        return result;
    }

    public static String removeControlChars(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isISOControl(c) && !Character.isWhitespace(c)) {
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String removeEnd(String str, String suffix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(suffix)) {
            return str;
        }
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static String removeNonPrintable(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\p{C}", EMPTY);
    }

    public static String removeStart(String str, String prefix) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(prefix)) {
            return str;
        }
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removeUnderscores(String value) {
        AssertionUtils.assertArgNotNull("value", value);
        return StringUtils.notContains(value, '_') ? value : value.replace("_", EMPTY);
    }

    public static String repeat(int count, String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(pattern);
        }
        return sb.toString();
    }

    public static String replaceUnicodeSequences(String s) {
        if (s.indexOf(92) == -1) {
            return s;
        }
        Pattern p = Pattern.compile("\\\\u(\\p{XDigit}{4})");
        Matcher m = p.matcher(s);
        StringBuffer sb = new StringBuffer(s.length());
        while (m.find()) {
            String ch = String.valueOf((char)Integer.parseInt(m.group(1), 16));
            m.appendReplacement(sb, Matcher.quoteReplacement(ch));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static String right(String str, int len) {
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (len >= str.length()) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String sanitize(String str) {
        if (str == null) {
            return null;
        }
        return StringUtils.escapeHtml(str);
    }

    public static double similarity(String str1, String str2) {
        if (str1 == null) {
            str1 = EMPTY;
        }
        if (str2 == null) {
            str2 = EMPTY;
        }
        if (str1.equals(str2)) {
            return 1.0;
        }
        int maxLen = Math.max(str1.length(), str2.length());
        int distance = StringUtils.levenshteinDistance(str1, str2);
        return 1.0 - (double)distance / (double)maxLen;
    }

    public static String snakeCase(String str) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        List<String> words = StringUtils.splitWords(str);
        if (words.isEmpty()) {
            return EMPTY;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.size(); ++i) {
            if (i > 0) {
                result.append('_');
            }
            result.append(words.get(i).toLowerCase());
        }
        return result.toString();
    }

    public static String[] sort(String[] array) {
        if (array == null) {
            return null;
        }
        Object[] result = Arrays.copyOf(array, array.length);
        Arrays.sort(result);
        return result;
    }

    public static String[] sortIgnoreCase(String[] array) {
        if (array == null) {
            return null;
        }
        String[] result = Arrays.copyOf(array, array.length);
        Arrays.sort(result, String.CASE_INSENSITIVE_ORDER);
        return result;
    }

    public static String soundex(String str) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        String upper = str.toUpperCase();
        StringBuilder result = new StringBuilder(4);
        result.append(upper.charAt(0));
        char lastCode = '\u0000';
        for (int i = 1; i < upper.length() && result.length() < 4; ++i) {
            char c = upper.charAt(i);
            char code = StringUtils.getSoundexCode(c);
            if (code == '0' || code == lastCode) continue;
            result.append(code);
            lastCode = code;
        }
        while (result.length() < 4) {
            result.append('0');
        }
        return result.toString();
    }

    public static List<String> split(String s) {
        return s == null ? Collections.emptyList() : StringUtils.split(s, ',');
    }

    public static List<String> split(String s, char c) {
        return StringUtils.split(s, c, Integer.MAX_VALUE);
    }

    public static void split(String s, char c, Consumer<String> consumer) {
        AsciiSet escapeChars = StringUtils.getEscapeSet(c);
        if (StringUtils.isEmpty(s)) {
            return;
        }
        if (s.indexOf(c) == -1) {
            consumer.accept(s);
            return;
        }
        int x1 = 0;
        int escapeCount = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\\') {
                ++escapeCount;
            } else if (s.charAt(i) == c && escapeCount % 2 == 0) {
                String s2 = s.substring(x1, i);
                String s3 = StringUtils.unescapeChars(s2, escapeChars);
                consumer.accept(s3.trim());
                x1 = i + 1;
            }
            if (s.charAt(i) == '\\') continue;
            escapeCount = 0;
        }
        String s2 = s.substring(x1);
        String s3 = StringUtils.unescapeChars(s2, escapeChars);
        consumer.accept(s3.trim());
    }

    public static List<String> split(String s, char c, int limit) {
        AsciiSet escapeChars = StringUtils.getEscapeSet(c);
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return Collections.emptyList();
        }
        if (s.indexOf(c) == -1) {
            return Collections.singletonList(s);
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int escapeCount = 0;
        --limit;
        for (int i = 0; i < sArray.length && limit > 0; ++i) {
            if (sArray[i] == '\\') {
                ++escapeCount;
            } else if (sArray[i] == c && escapeCount % 2 == 0) {
                String s2 = new String(sArray, x1, i - x1);
                String s3 = StringUtils.unescapeChars(s2, escapeChars);
                l.add(s3.trim());
                --limit;
                x1 = i + 1;
            }
            if (sArray[i] == '\\') continue;
            escapeCount = 0;
        }
        String s2 = new String(sArray, x1, sArray.length - x1);
        String s3 = StringUtils.unescapeChars(s2, escapeChars);
        l.add(s3.trim());
        return l;
    }

    public static void split(String s, Consumer<String> consumer) {
        StringUtils.split(s, ',', consumer);
    }

    public static String[] splita(String s) {
        return StringUtils.splita(s, ',');
    }

    public static String[] splita(String s, char c) {
        return StringUtils.splita(s, c, Integer.MAX_VALUE);
    }

    public static String[] splita(String s, char c, int limit) {
        List<String> l = StringUtils.split(s, c, limit);
        return l == null ? null : l.toArray(new String[l.size()]);
    }

    public static String[] splita(String[] s, char c) {
        if (s == null) {
            return null;
        }
        LinkedList<String> l = new LinkedList<String>();
        for (String ss : s) {
            if (ss == null || ss.indexOf(c) == -1) {
                l.add(ss);
                continue;
            }
            Collections.addAll(l, StringUtils.splita(ss, c));
        }
        return l.toArray(new String[l.size()]);
    }

    public static Map<String, String> splitMap(String s, boolean trim) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return CollectionUtils.mape();
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        StateEnum state = StateEnum.S1;
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int escapeCount = 0;
        String key = null;
        for (int i = 0; i < sArray.length + 1; ++i) {
            int c;
            int n = c = i == sArray.length ? 44 : sArray[i];
            if (c == 92) {
                ++escapeCount;
            }
            if (escapeCount % 2 == 0) {
                if (state == StateEnum.S1) {
                    if (c == 61) {
                        key = s.substring(x1, i);
                        if (trim) {
                            key = StringUtils.trim(key);
                        }
                        key = StringUtils.unescapeChars(key, MAP_ESCAPE_SET);
                        state = StateEnum.S2;
                        x1 = i + 1;
                    } else if (c == 44) {
                        key = s.substring(x1, i);
                        if (trim) {
                            key = StringUtils.trim(key);
                        }
                        key = StringUtils.unescapeChars(key, MAP_ESCAPE_SET);
                        m.put(key, EMPTY);
                        state = StateEnum.S1;
                        x1 = i + 1;
                    }
                } else if (c == 44) {
                    String val = s.substring(x1, i);
                    if (trim) {
                        val = StringUtils.trim(val);
                    }
                    val = StringUtils.unescapeChars(val, MAP_ESCAPE_SET);
                    m.put(key, val);
                    key = null;
                    x1 = i + 1;
                    state = StateEnum.S1;
                }
            }
            if (c == 92) continue;
            escapeCount = 0;
        }
        return m;
    }

    public static String[] splitMethodArgs(String s) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return new String[0];
        }
        if (s.indexOf(44) == -1) {
            return CollectionUtils.a(s);
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int paramDepth = 0;
        for (int i = 0; i < sArray.length; ++i) {
            char c = s.charAt(i);
            if (c == '>') {
                ++paramDepth;
                continue;
            }
            if (c == '<') {
                --paramDepth;
                continue;
            }
            if (c != ',' || paramDepth != 0) continue;
            String s2 = new String(sArray, x1, i - x1);
            l.add(s2.trim());
            x1 = i + 1;
        }
        String s2 = new String(sArray, x1, sArray.length - x1);
        l.add(s2.trim());
        return l.toArray(new String[l.size()]);
    }

    public static List<String> splitNested(String s) {
        AsciiSet escapeChars = StringUtils.getEscapeSet(',');
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return Collections.emptyList();
        }
        if (s.indexOf(44) == -1) {
            return Collections.singletonList(StringUtils.trim(s));
        }
        LinkedList<String> l = new LinkedList<String>();
        int x1 = 0;
        boolean inEscape = false;
        int depthCount = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inEscape) {
                if (c != '\\') continue;
                inEscape = false;
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            if (c == '{') {
                ++depthCount;
                continue;
            }
            if (c == '}') {
                --depthCount;
                continue;
            }
            if (c != ',' || depthCount != 0) continue;
            l.add(StringUtils.trim(StringUtils.unescapeChars(s.substring(x1, i), escapeChars)));
            x1 = i + 1;
        }
        l.add(StringUtils.trim(StringUtils.unescapeChars(s.substring(x1, s.length()), escapeChars)));
        return l;
    }

    public static List<String> splitNestedInner(String s) {
        AssertionUtils.assertArg(Utils.nn(s), "String was null.", new Object[0]);
        AssertionUtils.assertArg(Utils.ne(s), "String was empty.", new Object[0]);
        int start = -1;
        int end = -1;
        StateEnum state = StateEnum.S1;
        int depth = 0;
        boolean inEscape = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inEscape) {
                if (c != '\\') continue;
                inEscape = false;
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            if (state == StateEnum.S1) {
                if (c != '{') continue;
                start = i + 1;
                state = StateEnum.S2;
                continue;
            }
            if (c == '{') {
                ++depth;
                continue;
            }
            if (depth > 0 && c == '}') {
                --depth;
                continue;
            }
            if (c != '}') continue;
            end = i;
            break;
        }
        if (start == -1) {
            throw ThrowableUtils.illegalArg("Start character '{' not found in string:  {0}", s);
        }
        if (end == -1) {
            throw ThrowableUtils.illegalArg("End character '}' not found in string  {0}", s);
        }
        return StringUtils.splitNested(s.substring(start, end));
    }

    public static String[] splitQuoted(String s) {
        return StringUtils.splitQuoted(s, false);
    }

    public static String[] splitQuoted(String s, boolean keepQuotes) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s = s.trim())) {
            return CollectionUtils.a(new String[0]);
        }
        if (!StringUtils.containsAny(s, ' ', '\t', '\'', '\"')) {
            return CollectionUtils.a(s);
        }
        StateEnum state = StateEnum.S1;
        boolean isInEscape = false;
        boolean needsUnescape = false;
        int mark = 0;
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == StateEnum.S1) {
                if (c == '\'') {
                    state = StateEnum.S2;
                    mark = keepQuotes ? i : i + 1;
                    continue;
                }
                if (c == '\"') {
                    state = StateEnum.S3;
                    mark = keepQuotes ? i : i + 1;
                    continue;
                }
                if (c == ' ' || c == '\t') continue;
                state = StateEnum.S4;
                mark = i;
                continue;
            }
            if (state == StateEnum.S2 || state == StateEnum.S3) {
                if (c == '\\') {
                    isInEscape = !isInEscape;
                    needsUnescape = !keepQuotes;
                    continue;
                }
                if (!isInEscape) {
                    if (c != (state == StateEnum.S2 ? (char)'\'' : '\"')) continue;
                    String s2 = s.substring(mark, keepQuotes ? i + 1 : i);
                    if (needsUnescape) {
                        s2 = StringUtils.unescapeChars(s2, QUOTE_ESCAPE_SET);
                    }
                    l.add(s2);
                    state = StateEnum.S1;
                    needsUnescape = false;
                    isInEscape = false;
                    continue;
                }
                isInEscape = false;
                continue;
            }
            if (c != ' ' && c != '\t') continue;
            l.add(s.substring(mark, i));
            state = StateEnum.S1;
        }
        if (state == StateEnum.S4) {
            l.add(s.substring(mark));
        } else if (state == StateEnum.S2 || state == StateEnum.S3) {
            throw ThrowableUtils.illegalArg("Unmatched string quotes: {0}", s);
        }
        return l.toArray(new String[l.size()]);
    }

    public static boolean startsWith(String s, char c) {
        int i;
        if (Utils.nn(s) && (i = s.length()) > 0) {
            return s.charAt(0) == c;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        return str.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static Supplier<String> stringSupplier(Supplier<?> s) {
        return () -> StringUtils.readable(s.get());
    }

    public static String strip(String s) {
        if (s == null || s.length() <= 1) {
            return s;
        }
        return s.substring(1, s.length() - 1);
    }

    public static String stripInvalidHttpHeaderChars(String s) {
        if (s == null) {
            return null;
        }
        boolean needsReplace = false;
        for (int i = 0; i < s.length() && !needsReplace; needsReplace |= HTTP_HEADER_CHARS.contains(s.charAt(i)), ++i) {
        }
        if (!needsReplace) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!HTTP_HEADER_CHARS.contains(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String substringAfter(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringBetween(String str, String open, String close) {
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start == -1) {
            return null;
        }
        int end = str.indexOf(close, start + open.length());
        if (end == -1) {
            return null;
        }
        return str.substring(start + open.length(), end);
    }

    public static String swapCase(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (LETTER_UC.contains(c)) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (LETTER_LC.contains(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String titleCase(String str) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        List<String> words = StringUtils.splitWords(str);
        if (words.isEmpty()) {
            return EMPTY;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.size(); ++i) {
            if (i > 0) {
                result.append(' ');
            }
            result.append(StringUtils.capitalize(words.get(i).toLowerCase()));
        }
        return result.toString();
    }

    public static String toCdl(Object o) {
        if (o == null) {
            return null;
        }
        if (Utils.isArray(o)) {
            StringBuilder sb = new StringBuilder();
            int j = Array.getLength(o);
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(Array.get(o, i));
            }
            return sb.toString();
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            return StringUtils.join(c, ", ");
        }
        return o.toString();
    }

    public static String toHex(byte b) {
        char[] c = new char[2];
        int v = b & 0xFF;
        c[0] = HEX[v >>> 4];
        c[1] = HEX[v & 0xF];
        return new String(c);
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int v = element & 0xFF;
            sb.append(HEX[v >>> 4]).append(HEX[v & 0xF]);
        }
        return sb.toString();
    }

    public static String toHex(InputStream is) {
        return Utils.safe(() -> is == null ? null : StringUtils.toHex(IoUtils.readBytes(is)));
    }

    public static char[] toHex2(int num) {
        if (num < 0 || num > 255) {
            throw new NumberFormatException("toHex2 can only be used on numbers between 0 and 255");
        }
        char[] n = new char[2];
        int a = num % 16;
        n[1] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        a = num / 16 % 16;
        n[0] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        return n;
    }

    public static char[] toHex4(int num) {
        if (num < 0) {
            throw new NumberFormatException("toHex4 can only be used on non-negative numbers");
        }
        char[] n = new char[4];
        int a = num % 16;
        n[3] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        int base = 16;
        for (int i = 1; i < 4; ++i) {
            a = num / base % 16;
            base <<= 4;
            n[3 - i] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        }
        return n;
    }

    public static char[] toHex8(long num) {
        if (num < 0L) {
            throw new NumberFormatException("toHex8 can only be used on non-negative numbers");
        }
        char[] n = new char[8];
        long a = num % 16L;
        n[7] = (char)(a > 9L ? 65L + a - 10L : 48L + a);
        int base = 16;
        for (int i = 1; i < 8; ++i) {
            a = num / (long)base % 16L;
            base <<= 4;
            n[7 - i] = (char)(a > 9L ? 65L + a - 10L : 48L + a);
        }
        return n;
    }

    public static String toIsoDate(Calendar c) {
        if (c == null) {
            return null;
        }
        ZonedDateTime zdt = c.toInstant().atZone(c.getTimeZone().toZoneId());
        return zdt.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String toIsoDateTime(Calendar c) {
        if (c == null) {
            return null;
        }
        ZonedDateTime zdt = c.toInstant().atZone(c.getTimeZone().toZoneId());
        return zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static String toReadableBytes(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (byte b2 : b) {
            sb.append((String)(b2 < 32 || b2 > 122 ? String.format("[%02X]", b2) : (char)b2 + "   "));
        }
        sb.append(NEWLINE);
        for (byte b2 : b) {
            sb.append(String.format("[%02X]", b2));
        }
        return sb.toString();
    }

    public static String toSpacedHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int j = 0; j < bytes.length; ++j) {
            if (j > 0) {
                sb.append(' ');
            }
            int v = bytes[j] & 0xFF;
            sb.append(HEX[v >>> 4]).append(HEX[v & 0xF]);
        }
        return sb.toString();
    }

    public static String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static String toString(Object obj, String defaultStr) {
        return obj == null ? defaultStr : obj.toString();
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static URI toUri(Object o) {
        if (o == null || o instanceof URI) {
            return (URI)o;
        }
        try {
            return new URI(o.toString());
        }
        catch (URISyntaxException e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    public static String toUtf8(byte[] b) {
        return b == null ? null : new String(b, IoUtils.UTF8);
    }

    public static String toUtf8(InputStream is) {
        return Utils.safe(() -> is == null ? null : new String(IoUtils.readBytes(is), IoUtils.UTF8));
    }

    public static String transliterate(String str, String fromChars, String toChars) {
        if (str == null) {
            return null;
        }
        if (fromChars == null || toChars == null || fromChars.isEmpty() || toChars.isEmpty()) {
            return str;
        }
        if (fromChars.length() != toChars.length()) {
            throw new IllegalArgumentException("fromChars and toChars must have the same length");
        }
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int index = fromChars.indexOf(c);
            if (index >= 0) {
                sb.append(toChars.charAt(index));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static String trimEnd(String s) {
        if (Utils.nn(s)) {
            while (Utils.ne(s) && StringUtils.isWhitespace(s.charAt(s.length() - 1))) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static String trimLeadingSlashes(String s) {
        if (s == null) {
            return null;
        }
        while (Utils.ne(s) && s.charAt(0) == '/') {
            s = s.substring(1);
        }
        return s;
    }

    public static String trimSlashes(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return s;
        }
        while (StringUtils.endsWith(s, '/')) {
            s = s.substring(0, s.length() - 1);
        }
        while (Utils.ne(s) && s.charAt(0) == '/') {
            s = s.substring(1);
        }
        return s;
    }

    public static String trimSlashesAndSpaces(String s) {
        if (s == null) {
            return null;
        }
        while (Utils.ne(s) && (s.charAt(s.length() - 1) == '/' || StringUtils.isWhitespace(s.charAt(s.length() - 1)))) {
            s = s.substring(0, s.length() - 1);
        }
        while (Utils.ne(s) && (s.charAt(0) == '/' || StringUtils.isWhitespace(s.charAt(0)))) {
            s = s.substring(1);
        }
        return s;
    }

    public static String trimStart(String s) {
        if (Utils.nn(s)) {
            while (Utils.ne(s) && StringUtils.isWhitespace(s.charAt(0))) {
                s = s.substring(1);
            }
        }
        return s;
    }

    public static String trimTrailingSlashes(String s) {
        if (s == null) {
            return null;
        }
        while (StringUtils.endsWith(s, '/')) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String uncapitalize(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String unescapeChars(String s, AsciiSet escaped) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (!escaped.contains(s.charAt(i))) continue;
            ++count;
        }
        if (count == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() - count);
        for (int i = 0; i < s.length(); ++i) {
            char c2;
            char c = s.charAt(i);
            if (c == '\\' && i + 1 != s.length() && escaped.contains(c2 = s.charAt(i + 1))) {
                ++i;
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static String unescapeHtml(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&#39;", "'").replace("&apos;", "'").replace("&amp;", "&");
    }

    public static String unescapeXml(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&apos;", "'").replace("&amp;", "&");
    }

    public static String unicodeSequence(char c) {
        StringBuilder sb = new StringBuilder(6);
        sb.append('\\').append('u');
        for (char cc : StringUtils.toHex4(c)) {
            sb.append(cc);
        }
        return sb.toString();
    }

    public static String upperCase(String s) {
        return s == null ? null : s.toUpperCase();
    }

    public static String urlDecode(String s) {
        if (s == null) {
            return s;
        }
        boolean needsDecode = false;
        for (int i = 0; i < s.length() && !needsDecode; ++i) {
            char c = s.charAt(i);
            if (c != '+' && c != '%') continue;
            needsDecode = true;
        }
        if (needsDecode) {
            return Utils.safe(() -> URLDecoder.decode(s, "UTF-8"));
        }
        return s;
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        boolean needsEncode = false;
        for (int i = 0; i < s.length() && !needsEncode; needsEncode |= !URL_UNENCODED_CHARS.contains(s.charAt(i)), ++i) {
        }
        if (needsEncode) {
            return Utils.safe(() -> URLEncoder.encode(s, "UTF-8"));
        }
        return s;
    }

    public static String urlEncodeLax(String s) {
        if (s == null) {
            return null;
        }
        boolean needsEncode = false;
        for (int i = 0; i < s.length() && !needsEncode; needsEncode |= !URL_UNENCODED_LAX_CHARS.contains(s.charAt(i)), ++i) {
        }
        if (needsEncode) {
            StringBuilder sb = new StringBuilder(s.length() * 2);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (URL_UNENCODED_LAX_CHARS.contains(c)) {
                    sb.append(c);
                    continue;
                }
                if (c == ' ') {
                    sb.append("+");
                    continue;
                }
                if (c <= '\u007f') {
                    sb.append('%').append(StringUtils.toHex2(c));
                    continue;
                }
                Utils.safe(() -> sb.append(URLEncoder.encode(EMPTY + c, "UTF-8")));
            }
            s = sb.toString();
        }
        return s;
    }

    public static String urlEncodePath(Object o) {
        if (o == null) {
            return null;
        }
        String s = Utils.s(o);
        boolean needsEncode = false;
        for (int i = 0; i < s.length() && !needsEncode; ++i) {
            needsEncode = URL_ENCODE_PATHINFO_VALIDCHARS.contains(s.charAt(i));
        }
        if (!needsEncode) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        CharArrayWriter caw = new CharArrayWriter();
        int caseDiff = 32;
        int i = 0;
        while (i < s.length()) {
            byte[] ba;
            char c = s.charAt(i);
            if (URL_ENCODE_PATHINFO_VALIDCHARS.contains(c)) {
                sb.append(c);
                ++i;
                continue;
            }
            if (c == ' ') {
                sb.append('+');
                ++i;
                continue;
            }
            do {
                char d;
                caw.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                caw.write(d);
                ++i;
            } while (++i < s.length() && !URL_ENCODE_PATHINFO_VALIDCHARS.contains(c = s.charAt(i)));
            caw.flush();
            String s2 = new String(caw.toCharArray());
            for (byte element : ba = s2.getBytes(IoUtils.UTF8)) {
                sb.append('%');
                char ch = Character.forDigit(element >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - caseDiff);
                }
                sb.append(ch);
                ch = Character.forDigit(element & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - caseDiff);
                }
                sb.append(ch);
            }
            caw.reset();
        }
        return sb.toString();
    }

    public static int wordCount(String str) {
        if (StringUtils.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        boolean inWord = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (LETTER.contains(c) || DIGIT.contains(c) || c == '_') {
                if (inWord) continue;
                ++count;
                inWord = true;
                continue;
            }
            inWord = false;
        }
        return count;
    }

    public static String wrap(String str, int wrapLength) {
        return StringUtils.wrap(str, wrapLength, NEWLINE);
    }

    public static String wrap(String str, int wrapLength, String newline) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (wrapLength <= 0) {
            throw ThrowableUtils.illegalArg("wrapLength must be > 0: {0}", wrapLength);
        }
        if (newline == null) {
            throw ThrowableUtils.illegalArg("newline cannot be null", new Object[0]);
        }
        StringBuilder result = new StringBuilder();
        String[] lines = str.split("\r?\n", -1);
        for (int lineIdx = 0; lineIdx < lines.length; ++lineIdx) {
            String line = lines[lineIdx];
            if (line.isEmpty()) {
                if (lineIdx >= lines.length - 1) continue;
                result.append(newline);
                continue;
            }
            String[] words = line.split(" +");
            StringBuilder currentLine = new StringBuilder();
            block1: for (String word : words) {
                if (word.isEmpty()) continue;
                int wordLength = word.length();
                int currentLength = currentLine.length();
                if (currentLength == 0) {
                    if (wordLength > wrapLength && words.length > 1) {
                        if (result.length() > 0) {
                            result.append(newline);
                        }
                        for (int wordPos = 0; wordPos < wordLength; wordPos += wrapLength) {
                            int remaining;
                            if (wordPos > 0) {
                                result.append(newline);
                            }
                            if ((remaining = wordLength - wordPos) <= wrapLength) {
                                result.append(word.substring(wordPos));
                                continue block1;
                            }
                            result.append(word.substring(wordPos, wordPos + wrapLength));
                        }
                        continue;
                    }
                    currentLine.append(word);
                    continue;
                }
                int neededLength = currentLength + 1 + wordLength;
                if (neededLength < wrapLength) {
                    currentLine.append(' ').append(word);
                    continue;
                }
                if (result.length() > 0) {
                    result.append(newline);
                }
                result.append((CharSequence)currentLine);
                currentLine.setLength(0);
                if (wordLength > wrapLength && words.length > 1) {
                    result.append(newline);
                    for (int wordPos = 0; wordPos < wordLength; wordPos += wrapLength) {
                        int remaining;
                        if (wordPos > 0) {
                            result.append(newline);
                        }
                        if ((remaining = wordLength - wordPos) <= wrapLength) {
                            result.append(word.substring(wordPos));
                            continue block1;
                        }
                        result.append(word.substring(wordPos, wordPos + wrapLength));
                    }
                    continue;
                }
                currentLine.append(word);
            }
            if (currentLine.length() <= 0) continue;
            if (result.length() > 0) {
                result.append(newline);
            }
            result.append((CharSequence)currentLine);
        }
        return result.toString();
    }

    private static int estimateSyllables(String word) {
        String lower = word.toLowerCase();
        int count = 0;
        boolean prevWasVowel = false;
        for (int i = 0; i < lower.length(); ++i) {
            boolean isVowel;
            char c = lower.charAt(i);
            boolean bl = isVowel = VOWEL.contains(c) || c == 'y';
            if (isVowel && !prevWasVowel) {
                ++count;
            }
            prevWasVowel = isVowel;
        }
        if (lower.endsWith("e") && count > 1) {
            --count;
        }
        return Math.max(1, count);
    }

    private static int firstRealCharacter(String s) {
        return Utils.safe(() -> {
            StringReader r = new StringReader(s);
            int c = 0;
            while ((c = r.read()) != -1) {
                if (StringUtils.isWhitespace(c)) continue;
                if (c == 47) {
                    StringUtils.skipComments(r);
                    continue;
                }
                return c;
            }
            return -1;
        });
    }

    private static char getSoundexCode(char c) {
        if (c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'H' || c == 'W' || c == 'Y') {
            return '0';
        }
        if (c == 'B' || c == 'F' || c == 'P' || c == 'V') {
            return '1';
        }
        if (c == 'C' || c == 'G' || c == 'J' || c == 'K' || c == 'Q' || c == 'S' || c == 'X' || c == 'Z') {
            return '2';
        }
        if (c == 'D' || c == 'T') {
            return '3';
        }
        if (c == 'L') {
            return '4';
        }
        if (c == 'M' || c == 'N') {
            return '5';
        }
        if (c == 'R') {
            return '6';
        }
        return '0';
    }

    public static boolean isValidIPv6Address(String ip) {
        String[] groups;
        String[] rightParts;
        String[] leftParts;
        int totalParts;
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        if (ip.startsWith(":") && !ip.startsWith("::")) {
            return false;
        }
        if (ip.endsWith(":") && !ip.endsWith("::")) {
            return false;
        }
        if (ip.contains(".")) {
            int lastColon = ip.lastIndexOf(":");
            if (lastColon < 0) {
                return false;
            }
            String ipv4Part = ip.substring(lastColon + 1);
            String[] ipv4Parts = ipv4Part.split("\\.");
            if (ipv4Parts.length != 4) {
                return false;
            }
            for (String part : ipv4Parts) {
                try {
                    int num = Integer.parseInt(part);
                    if (num >= 0 && num <= 255) continue;
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            String ipv6Part = ip.substring(0, lastColon);
            if (ipv6Part.isEmpty() || ipv6Part.equals("::") || ipv6Part.equals("::ffff") || ipv6Part.equals("::FFFF") || ipv6Part.equals(":") && ip.startsWith("::")) {
                return true;
            }
        }
        int doubleColonCount = 0;
        for (int i = 1; i < ip.length(); ++i) {
            if (ip.charAt(i) != ':' || ip.charAt(i - 1) != ':' || ++doubleColonCount <= 1) continue;
            return false;
        }
        String[] parts = ip.split("::", -1);
        if (parts.length == 2 ? (totalParts = (leftParts = parts[0].isEmpty() ? new String[]{} : parts[0].split(":")).length + (rightParts = parts[1].isEmpty() ? new String[]{} : parts[1].split(":")).length) > 7 : (groups = ip.split(":")).length != 8) {
            return false;
        }
        for (String groupSection : groups = ip.split("::")) {
            String[] groupParts;
            if (groupSection.isEmpty()) continue;
            for (String group : groupParts = groupSection.split(":")) {
                if (group.length() > 4) {
                    return false;
                }
                for (int i = 0; i < group.length(); ++i) {
                    char c = group.charAt(i);
                    if (HEXADECIMAL_CHARS.contains(c)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static <T> Readifier readifier(Class<T> type, Function<? super T, String> converter) {
        return new Readifier(type, converter);
    }

    private static List<Readifier> loadReadifiers() {
        ArrayList<Readifier> list = new ArrayList<Readifier>();
        list.add(StringUtils.readifier(Map.Entry.class, x -> StringUtils.readable(x.getKey()) + "=" + StringUtils.readable(x.getValue())));
        list.add(StringUtils.readifier(Collection.class, x -> x.stream().map(StringUtils::readable).collect(Collectors.joining(",", "[", "]"))));
        list.add(StringUtils.readifier(Map.class, x -> x.entrySet().stream().map(StringUtils::readable).collect(Collectors.joining(",", "{", "}"))));
        list.add(StringUtils.readifier(Iterable.class, x -> StringUtils.readable(CollectionUtils.toList(x))));
        list.add(StringUtils.readifier(Iterator.class, x -> StringUtils.readable(CollectionUtils.toList(x))));
        list.add(StringUtils.readifier(Enumeration.class, x -> StringUtils.readable(CollectionUtils.toList(x))));
        list.add(StringUtils.readifier(Optional.class, x -> StringUtils.readable(x.orElse(null))));
        list.add(StringUtils.readifier(GregorianCalendar.class, x -> x.toZonedDateTime().format(DateTimeFormatter.ISO_INSTANT)));
        list.add(StringUtils.readifier(Date.class, x -> x.toInstant().toString()));
        list.add(StringUtils.readifier(InputStream.class, x -> StringUtils.toHex(x)));
        list.add(StringUtils.readifier(Reader.class, x -> Utils.safe(() -> IoUtils.read(x))));
        list.add(StringUtils.readifier(File.class, x -> Utils.safe(() -> IoUtils.read(x))));
        list.add(StringUtils.readifier(byte[].class, x -> StringUtils.toHex(x)));
        list.add(StringUtils.readifier(Enum.class, x -> x.name()));
        list.add(StringUtils.readifier(Class.class, x -> Utils.cns(x)));
        list.add(StringUtils.readifier(Constructor.class, x -> ConstructorInfo.of(x).getFullName()));
        list.add(StringUtils.readifier(Method.class, x -> MethodInfo.of(x).getFullName()));
        list.add(StringUtils.readifier(Field.class, x -> FieldInfo.of(x).toString()));
        list.add(StringUtils.readifier(Parameter.class, x -> ParameterInfo.of(x).toString()));
        list.add(StringUtils.readifier(ClassInfo.class, ClassInfo::toString));
        list.add(StringUtils.readifier(MethodInfo.class, ExecutableInfo::toString));
        list.add(StringUtils.readifier(ConstructorInfo.class, ExecutableInfo::toString));
        list.add(StringUtils.readifier(FieldInfo.class, FieldInfo::toString));
        list.add(StringUtils.readifier(ParameterInfo.class, ParameterInfo::toString));
        return Collections.unmodifiableList(list);
    }

    private static int multiplierInt(String s) {
        int c;
        int n = c = StringUtils.isEmpty(s) ? 122 : (int)s.charAt(s.length() - 1);
        if (c == 71) {
            return 0x40000000;
        }
        if (c == 77) {
            return 0x100000;
        }
        if (c == 75) {
            return 1024;
        }
        if (c == 103) {
            return 1000000000;
        }
        if (c == 109) {
            return 1000000;
        }
        if (c == 107) {
            return 1000;
        }
        return 1;
    }

    private static long multiplierLong(String s) {
        if (StringUtils.isEmpty(s)) {
            return 1L;
        }
        char c = s.charAt(s.length() - 1);
        if (c == 'P') {
            return 0x4000000000000L;
        }
        if (c == 'T') {
            return 0x10000000000L;
        }
        if (c == 'G') {
            return 0x40000000L;
        }
        if (c == 'M') {
            return 0x100000L;
        }
        if (c == 'K') {
            return 1024L;
        }
        if (c == 'p') {
            return 1000000000000000L;
        }
        if (c == 't') {
            return 1000000000000L;
        }
        if (c == 'g') {
            return 1000000000L;
        }
        if (c == 'm') {
            return 1000000L;
        }
        if (c == 'k') {
            return 1000L;
        }
        return 1L;
    }

    private static long parseUnit(String unit, double value) {
        if (StringUtils.isEmpty(unit)) {
            return (long)value;
        }
        if (unit.equals("ms") || unit.equals("millis") || unit.equals("milliseconds")) {
            return (long)value;
        }
        if (unit.startsWith("s") && !unit.startsWith("sec")) {
            return (long)(value * 1000.0);
        }
        if (unit.startsWith("sec") || unit.startsWith("second")) {
            return (long)(value * 1000.0);
        }
        if (unit.startsWith("m") && !unit.startsWith("mo") && !unit.startsWith("mill") && !unit.startsWith("ms")) {
            return (long)(value * 1000.0 * 60.0);
        }
        if (unit.startsWith("min") || unit.startsWith("minute")) {
            return (long)(value * 1000.0 * 60.0);
        }
        if (unit.startsWith("h") || unit.startsWith("hour")) {
            return (long)(value * 1000.0 * 60.0 * 60.0);
        }
        if (unit.startsWith("d") && !unit.startsWith("da")) {
            return (long)(value * 1000.0 * 60.0 * 60.0 * 24.0);
        }
        if (unit.startsWith("day")) {
            return (long)(value * 1000.0 * 60.0 * 60.0 * 24.0);
        }
        if (unit.startsWith("w") || unit.startsWith("week")) {
            return (long)(value * 1000.0 * 60.0 * 60.0 * 24.0 * 7.0);
        }
        if (unit.startsWith("mo") || unit.startsWith("month")) {
            return (long)(value * 1000.0 * 60.0 * 60.0 * 24.0 * 30.0);
        }
        if (unit.startsWith("y") && !unit.startsWith("yr")) {
            return (long)(value * 1000.0 * 60.0 * 60.0 * 24.0 * 365.0);
        }
        if (unit.startsWith("yr") || unit.startsWith("year")) {
            return (long)(value * 1000.0 * 60.0 * 60.0 * 24.0 * 365.0);
        }
        return -1L;
    }

    public static void skipComments(StringReader r) throws IOException {
        block4: {
            int c;
            block3: {
                c = r.read();
                if (c != 42) break block3;
                c = r.read();
                while (c != -1) {
                    if (c == 42) {
                        c = r.read();
                        if (c != 47) continue;
                        return;
                    }
                    c = r.read();
                }
                break block4;
            }
            if (c != 47) break block4;
            while ((c = r.read()) != -1) {
                if (c != 10) continue;
                return;
            }
        }
    }

    private static AsciiSet getEscapeSet(char c) {
        return ESCAPE_SETS.computeIfAbsent(Character.valueOf(c), key -> AsciiSet.create().chars(key.charValue(), '\\').build());
    }

    private static List<String> splitWords(String str) {
        if (str == null || StringUtils.isEmpty(str)) {
            return Collections.emptyList();
        }
        ArrayList<String> words = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean wasLowerCase = false;
        boolean wasUpperCase = false;
        int consecutiveUpperCount = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            boolean isSeparator = c == ' ' || c == '_' || c == '-' || c == '\t';
            boolean isUpperCase = LETTER_UC.contains(c);
            boolean isLowerCase = LETTER_LC.contains(c);
            boolean isLetter = LETTER.contains(c);
            if (isSeparator) {
                if (sb.length() > 0) {
                    words.add(sb.toString());
                    sb.setLength(0);
                }
                wasLowerCase = false;
                wasUpperCase = false;
                consecutiveUpperCount = 0;
                continue;
            }
            if (isLetter) {
                if (sb.length() > 0) {
                    if (isUpperCase && wasLowerCase) {
                        words.add(sb.toString());
                        sb.setLength(0);
                        consecutiveUpperCount = 0;
                    } else if (isUpperCase && wasUpperCase && consecutiveUpperCount >= 2) {
                        char nextChar;
                        if (i + 1 < str.length() && LETTER_LC.contains(nextChar = str.charAt(i + 1))) {
                            words.add(sb.toString());
                            sb.setLength(0);
                            consecutiveUpperCount = 0;
                        }
                    } else if (isLowerCase && wasUpperCase && consecutiveUpperCount >= 2) {
                        int splitPoint = sb.length() - 1;
                        words.add(sb.substring(0, splitPoint));
                        sb.delete(0, splitPoint);
                        consecutiveUpperCount = 0;
                    }
                }
                sb.append(c);
                wasLowerCase = isLowerCase;
                wasUpperCase = isUpperCase;
                if (isUpperCase) {
                    ++consecutiveUpperCount;
                    continue;
                }
                consecutiveUpperCount = 0;
                continue;
            }
            sb.append(c);
            wasLowerCase = false;
            wasUpperCase = false;
            consecutiveUpperCount = 0;
        }
        if (sb.length() > 0) {
            words.add(sb.toString());
        }
        return words;
    }

    protected StringUtils() {
    }

    static {
        for (int i = 0; i < 64; ++i) {
            StringUtils.BASE64M2[StringUtils.BASE64M1[i]] = (byte)i;
        }
        RANDOM = new Random();
        FP_REGEX = Pattern.compile("[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");
        ESCAPE_SETS = new ConcurrentHashMap<Character, AsciiSet>();
        READIFIERS = StringUtils.loadReadifiers();
        READIFIER_CACHE = Cache.create().weak().build();
        HEX = "0123456789ABCDEF".toCharArray();
    }

    private static class Readifier {
        private final Class<?> type;
        private final Function<Object, String> bridge;

        private <T> Readifier(Class<T> type, Function<? super T, String> converter) {
            this.type = type;
            this.bridge = o -> (String)converter.apply((Object)type.cast(o));
        }

        Class<?> forClass() {
            return this.type;
        }

        Function<Object, String> toFunction() {
            return this.bridge;
        }
    }
}

