/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.common.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.juneau.common.utils.Snippet;

public class ThrowableUtils {
    public static RuntimeException asRuntimeException(Throwable cause) {
        return ThrowableUtils.cast(RuntimeException.class, cause);
    }

    public static <T> T cast(Class<T> type, Throwable t) {
        try {
            return type.isInstance(t) ? type.cast(t) : type.getConstructor(Throwable.class).newInstance(t);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T extends Throwable> T getCause(Class<T> c, Throwable t) {
        while (t != null) {
            if (!c.isInstance(t = t.getCause())) continue;
            return (T)((Throwable)c.cast(t));
        }
        return null;
    }

    public static <T> T safeSupplier(SupplierWithThrowable<T> supplier) {
        try {
            return supplier.get();
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw ThrowableUtils.asRuntimeException(t);
        }
    }

    public static void safeRun(Snippet snippet) {
        try {
            snippet.run();
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw ThrowableUtils.asRuntimeException(t);
        }
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
        }
        return sw.toString();
    }

    public static int hash(Throwable t, String stopClass) {
        int i = 0;
        while (t != null) {
            for (StackTraceElement e : t.getStackTrace()) {
                if (e.getClassName().equals(stopClass)) break;
                if (e.getClassName().indexOf(36) != -1) continue;
                i ^= e.hashCode();
            }
            t = t.getCause();
        }
        return i;
    }

    @FunctionalInterface
    public static interface SupplierWithThrowable<T> {
        public T get() throws Throwable;
    }
}

