/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.juneau.utils.StackTraceInfo;
import org.apache.juneau.utils.StackTraceUtils;

public class StackTraceDatabase {
    private final ConcurrentHashMap<Integer, StackTraceInfo> db = new ConcurrentHashMap();
    private final String stopClass;
    private final long cacheTimeout;

    public StackTraceDatabase() {
        this(-1L, null);
    }

    public StackTraceDatabase(long cacheTimeout, Class<?> stopClass) {
        this.stopClass = stopClass == null ? "" : stopClass.getName();
        this.cacheTimeout = cacheTimeout;
    }

    public StackTraceDatabase add(Throwable e) {
        this.find(e).increment();
        return this;
    }

    public StackTraceInfo getStackTraceInfo(Throwable e) {
        return this.find(e).clone();
    }

    public void reset() {
        this.db.clear();
    }

    public List<StackTraceInfo> getClonedStackTraceInfos() {
        return this.db.values().stream().map(x -> x.clone()).sorted().collect(Collectors.toList());
    }

    private StackTraceInfo find(Throwable e) {
        int hash = StackTraceUtils.hash(e, this.stopClass);
        StackTraceInfo stc = this.db.get(hash);
        long time = System.currentTimeMillis();
        if (stc != null && stc.timeout > time) {
            return stc;
        }
        String n = e == null ? null : e.getClass().getSimpleName();
        long t = this.cacheTimeout == -1L ? Long.MAX_VALUE : time + this.cacheTimeout;
        stc = new StackTraceInfo(n, t, hash);
        this.db.put(hash, stc);
        return this.db.get(hash);
    }
}

