/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.MetaProvider;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.PropertyStoreApply;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ExecutableInfo;
import org.apache.juneau.reflect.ParamInfo;

@BeanIgnore
public final class MethodInfo
extends ExecutableInfo
implements Comparable<MethodInfo> {
    private ClassInfo returnType;
    private final Method m;
    private List<Method> matching;

    protected MethodInfo(ClassInfo declaringClass, Method m, Method rm) {
        super(declaringClass, m, rm);
        this.m = m;
    }

    public static MethodInfo of(ClassInfo declaringClass, Method m, Method rm) {
        if (m == null) {
            return null;
        }
        return new MethodInfo(declaringClass, m, rm);
    }

    public static MethodInfo of(Class<?> declaringClass, Method m, Method rm) {
        if (m == null) {
            return null;
        }
        return new MethodInfo(ClassInfo.of(declaringClass), m, rm);
    }

    public static MethodInfo of(Method m) {
        if (m == null) {
            return null;
        }
        return new MethodInfo(ClassInfo.of(m.getDeclaringClass()), m, m);
    }

    public Method inner() {
        return this.m;
    }

    public List<Method> getMatching() {
        if (this.matching == null) {
            this.matching = Collections.unmodifiableList(MethodInfo.findMatching(new ArrayList<Method>(), this.m, this.m.getDeclaringClass()));
        }
        return this.matching;
    }

    public Iterable<Method> getMatchingParentFirst() {
        return CollectionUtils.iterable(this.getMatching(), true);
    }

    private static List<Method> findMatching(List<Method> l, Method m, Class<?> c) {
        for (Method m2 : c.getDeclaredMethods()) {
            if (!m.getName().equals(m2.getName()) || !Arrays.equals(m.getParameterTypes(), m2.getParameterTypes())) continue;
            l.add(m2);
        }
        Class<?> pc = c.getSuperclass();
        if (pc != null) {
            MethodInfo.findMatching(l, m, pc);
        }
        for (Class<?> ic : c.getInterfaces()) {
            MethodInfo.findMatching(l, m, ic);
        }
        return l;
    }

    private Method findMatchingOnClass(ClassInfo c) {
        for (Method m2 : c.inner().getDeclaredMethods()) {
            if (!this.m.getName().equals(m2.getName()) || !Arrays.equals(this.m.getParameterTypes(), m2.getParameterTypes())) continue;
            return m2;
        }
        return null;
    }

    public final <T extends Annotation> T getAnnotation(Class<T> a) {
        return this.getAnnotation(a, MetaProvider.DEFAULT);
    }

    public final <T extends Annotation> T getAnnotation(Class<T> a, MetaProvider mp) {
        if (a == null) {
            return null;
        }
        for (Method m2 : this.getMatching()) {
            T t = mp.getAnnotation(a, m2);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public final boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.getAnnotation(a) != null;
    }

    public <T extends Annotation> List<T> getAnnotations(Class<T> a) {
        return this.appendAnnotations(new ArrayList(), a);
    }

    public <T extends Annotation> List<T> getAnnotationsParentFirst(Class<T> a) {
        return this.appendAnnotationsParentFirst(new ArrayList(), a);
    }

    public <T extends Annotation> List<T> appendAnnotations(List<T> l, Class<T> a) {
        for (Method m2 : this.getMatching()) {
            for (Annotation a2 : m2.getDeclaredAnnotations()) {
                if (!a.isInstance(a2)) continue;
                l.add(a2);
            }
        }
        this.getReturnType().resolved().appendAnnotations(l, a);
        this.declaringClass.appendAnnotations(l, a);
        return l;
    }

    public <T extends Annotation> List<T> appendAnnotationsParentFirst(List<T> l, Class<T> a) {
        this.declaringClass.appendAnnotationsParentFirst(l, a);
        for (Method m2 : this.getMatchingParentFirst()) {
            for (Annotation a2 : m2.getDeclaredAnnotations()) {
                if (!a.isInstance(a2)) continue;
                l.add(a2);
            }
        }
        this.getReturnType().resolved().appendAnnotations(l, a);
        return l;
    }

    @SafeVarargs
    public final Annotation getAnyAnnotation(Class<? extends Annotation> ... c) {
        for (Class<? extends Annotation> cc : c) {
            Annotation a = this.getAnnotation(cc);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public AnnotationList getAnnotationList(Predicate<AnnotationInfo<?>> filter) {
        return this.appendAnnotationList(new AnnotationList(filter));
    }

    public AnnotationList getAnnotationListParentFirst(Predicate<AnnotationInfo<?>> filter) {
        return this.appendAnnotationListParentFirst(new AnnotationList(filter));
    }

    public AnnotationList getAnnotationListMethodOnlyParentFirst(Predicate<AnnotationInfo<?>> filter) {
        return this.appendAnnotationListMethodOnlyParentFirst(new AnnotationList(filter));
    }

    public boolean hasConfigAnnotations() {
        for (Method m2 : this.getMatching()) {
            for (Annotation a2 : m2.getAnnotations()) {
                if (a2.annotationType().getAnnotation(PropertyStoreApply.class) == null) continue;
                return true;
            }
        }
        return false;
    }

    AnnotationList appendAnnotationList(AnnotationList al) {
        ClassInfo c = this.declaringClass;
        for (ClassInfo ci : c.getParents()) {
            this.appendMethodAnnotations(al, ci);
            this.appendAnnotations(al, ci);
        }
        for (ClassInfo ci : c.getInterfaces()) {
            this.appendMethodAnnotations(al, ci);
            this.appendAnnotations(al, ci);
        }
        this.appendAnnotations(al, c.getPackage());
        return al;
    }

    AnnotationList appendAnnotationListParentFirst(AnnotationList al) {
        ClassInfo c = this.declaringClass;
        this.appendAnnotations(al, c.getPackage());
        for (ClassInfo ci : c.getInterfacesParentFirst()) {
            this.appendAnnotations(al, ci);
            this.appendMethodAnnotations(al, ci);
        }
        for (ClassInfo ci : c.getParentsParentFirst()) {
            this.appendAnnotations(al, ci);
            this.appendMethodAnnotations(al, ci);
        }
        return al;
    }

    AnnotationList appendAnnotationListMethodOnlyParentFirst(AnnotationList al) {
        ClassInfo c = this.declaringClass;
        for (ClassInfo ci : c.getInterfacesParentFirst()) {
            this.appendMethodAnnotations(al, ci);
        }
        for (ClassInfo ci : c.getParentsParentFirst()) {
            this.appendMethodAnnotations(al, ci);
        }
        return al;
    }

    void appendAnnotations(AnnotationList al, Package p) {
        if (p != null) {
            for (Annotation a : p.getDeclaredAnnotations()) {
                al.add(AnnotationInfo.of(p, a));
            }
        }
    }

    void appendAnnotations(AnnotationList al, ClassInfo ci) {
        if (ci != null) {
            for (Annotation a : ci.c.getDeclaredAnnotations()) {
                al.add(AnnotationInfo.of(ci, a));
            }
        }
    }

    void appendMethodAnnotations(AnnotationList al, ClassInfo ci) {
        Method m = this.findMatchingOnClass(ci);
        if (m != null) {
            for (Annotation a : m.getDeclaredAnnotations()) {
                al.add(AnnotationInfo.of(MethodInfo.of(m), a));
            }
        }
    }

    public ClassInfo getReturnType() {
        if (this.returnType == null) {
            this.returnType = ClassInfo.of(this.m.getReturnType(), this.m.getGenericReturnType());
        }
        return this.returnType;
    }

    public ClassInfo getResolvedReturnType() {
        if (this.returnType == null) {
            this.returnType = ClassInfo.of(this.m.getReturnType(), this.m.getGenericReturnType());
        }
        return this.returnType.resolved();
    }

    public boolean hasReturnType(Class<?> c) {
        return this.m.getReturnType() == c;
    }

    public boolean hasReturnType(ClassInfo ci) {
        return this.hasReturnType(ci.inner());
    }

    public boolean hasReturnTypeParent(Class<?> c) {
        return ClassInfo.of(c).isParentOf(this.m.getReturnType());
    }

    public boolean hasReturnTypeParent(ClassInfo ci) {
        return this.hasReturnTypeParent(ci.inner());
    }

    public <T> T invoke(Object obj, Object ... args) throws ExecutableException {
        try {
            return (T)this.m.invoke(obj, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
    }

    public Object invokeFuzzy(Object pojo, Object ... args) throws ExecutableException {
        try {
            return this.m.invoke(pojo, ClassUtils.getMatchingArgs(this.m.getParameterTypes(), args));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ExecutableException(e);
        }
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.m.getName());
        Class<?>[] pt = this.rawParamTypes();
        if (pt.length > 0) {
            sb.append('(');
            List<ParamInfo> mpi = this.getParams();
            for (int i = 0; i < pt.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                mpi.get(i).getParameterType().appendFullName(sb);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public String getPropertyName() {
        String n = this.m.getName();
        if ((n.startsWith("get") || n.startsWith("set")) && n.length() > 3) {
            return Introspector.decapitalize(n.substring(3));
        }
        if (n.startsWith("is") && n.length() > 2) {
            return Introspector.decapitalize(n.substring(2));
        }
        return n;
    }

    public boolean argsOnlyOfType(Class<?> ... args) {
        for (Class<?> c1 : this.rawParamTypes()) {
            boolean foundMatch = false;
            for (Class<?> c2 : args) {
                if (c1 != c2) continue;
                foundMatch = true;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    public boolean isBridge() {
        return this.m.isBridge();
    }

    @Override
    public int compareTo(MethodInfo o) {
        int i = this.getSimpleName().compareTo(o.getSimpleName());
        if (i == 0 && (i = this.rawParamTypes().length - o.rawParamTypes().length) == 0) {
            for (int j = 0; j < this.rawParamTypes().length && i == 0; ++j) {
                i = this.rawParamTypes()[j].getName().compareTo(o.rawParamTypes()[j].getName());
            }
        }
        return i;
    }
}

