/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.StringUtils;

public class DelegateMap<T extends Map>
extends ObjectMap
implements Delegate<T> {
    private static final long serialVersionUID = 1L;
    private transient ClassMeta<T> classMeta;

    public DelegateMap(T m, BeanSession session) {
        this.classMeta = session.getClassMetaForObject(m);
        for (Map.Entry e : m.entrySet()) {
            this.put(StringUtils.stringify(e.getKey()), e.getValue());
        }
    }

    @Override
    public ClassMeta<T> getClassMeta() {
        return this.classMeta;
    }

    public DelegateMap<T> filterKeys(List<String> keys) {
        ObjectMap m2 = new ObjectMap();
        for (String k : keys) {
            if (!this.containsKey(k)) continue;
            m2.put(k, this.get(k));
        }
        this.clear();
        this.putAll(m2);
        return this;
    }
}

