/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StateMachineState;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.parser.ParseException;

public class StaticFileMapping {
    final Class<?> resourceClass;
    final String path;
    final String location;
    final Map<String, Object> responseHeaders;

    public StaticFileMapping(Class<?> resourceClass, String path, String location, Map<String, Object> responseHeaders) {
        this.resourceClass = resourceClass;
        this.path = StringUtils.trimSlashes((String)path);
        this.location = StringUtils.trimTrailingSlashes((String)location);
        this.responseHeaders = CollectionUtils.immutableMap(responseHeaders);
    }

    public static List<StaticFileMapping> parse(Class<?> resourceClass, String mapping) throws ParseException {
        if (StringUtils.isEmpty((String)(mapping = StringUtils.trim((String)mapping)))) {
            return Collections.emptyList();
        }
        StateMachineState state = StateMachineState.S01;
        int mark = 0;
        String path = null;
        String location = null;
        ArrayList<StaticFileMapping> l = new ArrayList<StaticFileMapping>();
        String s = mapping;
        int jsonDepth = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == StateMachineState.S01) {
                if (c != ':') continue;
                path = StringUtils.trim((String)s.substring(mark, i));
                mark = i + 1;
                state = StateMachineState.S02;
                continue;
            }
            if (state == StateMachineState.S02) {
                if (c == ':') {
                    location = StringUtils.trim((String)s.substring(mark, i));
                    mark = i + 1;
                    state = StateMachineState.S03;
                    continue;
                }
                if (c != ',') continue;
                location = StringUtils.trim((String)s.substring(mark, i));
                l.add(new StaticFileMapping(resourceClass, path, location, null));
                mark = i + 1;
                state = StateMachineState.S01;
                path = null;
                location = null;
                continue;
            }
            if (state == StateMachineState.S03) {
                if (c == '{') {
                    mark = i;
                    state = StateMachineState.S04;
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                throw new ParseException("Invalid staticFiles mapping.  Expected '{' at beginning of headers.  mapping=[{0}]", new Object[]{mapping});
            }
            if (state == StateMachineState.S04) {
                if (c == '{') {
                    ++jsonDepth;
                    continue;
                }
                if (c != '}') continue;
                if (jsonDepth > 0) {
                    --jsonDepth;
                    continue;
                }
                String json = s.substring(mark, i + 1);
                l.add(new StaticFileMapping(resourceClass, path, location, (Map<String, Object>)new ObjectMap((CharSequence)json)));
                state = StateMachineState.S05;
                path = null;
                location = null;
                continue;
            }
            if (state == StateMachineState.S05) {
                if (c == ',') {
                    state = StateMachineState.S06;
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                throw new ParseException("Invalid staticFiles mapping.  Invalid text following headers.  mapping=[{0}]", new Object[]{mapping});
            }
            if (Character.isWhitespace(c)) continue;
            mark = i;
            state = StateMachineState.S01;
        }
        if (state == StateMachineState.S01) {
            throw new ParseException("Invalid staticFiles mapping.  Couldn''t find '':'' following path.  mapping=[{0}]", new Object[]{mapping});
        }
        if (state == StateMachineState.S02) {
            location = StringUtils.trim((String)s.substring(mark, s.length()));
            l.add(new StaticFileMapping(resourceClass, path, location, null));
        } else {
            if (state == StateMachineState.S03) {
                throw new ParseException("Invalid staticFiles mapping.  Found extra '':'' following location.  mapping=[{0}]", new Object[]{mapping});
            }
            if (state == StateMachineState.S04) {
                throw new ParseException("Invalid staticFiles mapping.  Malformed headers.  mapping=[{0}]", new Object[]{mapping});
            }
        }
        return l;
    }

    public String toString() {
        return SimpleJsonSerializer.DEFAULT_READABLE.toString((Object)this.toMap());
    }

    public ObjectMap toMap() {
        return new DefaultFilteringObjectMap().append("resourceClass", this.resourceClass).append("path", (Object)this.path).append("location", (Object)this.location).append("responseHeaders", this.responseHeaders);
    }
}

