/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.SchemaInfo;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.utils.ASet;

@Bean(bpi="in,name,type,description,required,schema,format,allowEmptyValue,items,collectionFormat,default,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,maxItems,minItems,uniqueItems,enum,multipleOf,x-example,x-examples,*")
public class ParameterInfo
extends SwaggerElement {
    private static final String[] VALID_IN = new String[]{"query", "header", "path", "formData", "body"};
    private static final String[] VALID_TYPES = new String[]{"string", "number", "integer", "boolean", "array", "file"};
    private static final String[] VALID_COLLECTION_FORMATS = new String[]{"csv", "ssv", "tsv", "pipes", "multi"};
    private String name;
    private String in;
    private String description;
    private String type;
    private String format;
    private String pattern;
    private String collectionFormat;
    private Number maximum;
    private Number minimum;
    private Number multipleOf;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Boolean required;
    private Boolean allowEmptyValue;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private SchemaInfo schema;
    private Items items;
    private Object _default;
    private List<Object> _enum;
    private String example;
    private Map<String, String> examples;

    public ParameterInfo() {
    }

    public ParameterInfo(ParameterInfo copyFrom) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.in = copyFrom.in;
        this.description = copyFrom.description;
        this.type = copyFrom.type;
        this.format = copyFrom.format;
        this.pattern = copyFrom.pattern;
        this.collectionFormat = copyFrom.collectionFormat;
        this.maximum = copyFrom.maximum;
        this.minimum = copyFrom.minimum;
        this.multipleOf = copyFrom.multipleOf;
        this.maxLength = copyFrom.maxLength;
        this.minLength = copyFrom.minLength;
        this.maxItems = copyFrom.maxItems;
        this.minItems = copyFrom.minItems;
        this.required = copyFrom.required;
        this.allowEmptyValue = copyFrom.allowEmptyValue;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.uniqueItems = copyFrom.uniqueItems;
        this.schema = copyFrom.schema == null ? null : copyFrom.schema.copy();
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this._default = copyFrom._default;
        this._enum = CollectionUtils.newList(copyFrom._enum);
        this.example = copyFrom.example;
        this.examples = copyFrom.examples == null ? null : new LinkedHashMap<String, String>(copyFrom.examples);
    }

    public ParameterInfo copy() {
        return new ParameterInfo(this);
    }

    @Override
    protected ParameterInfo strict() {
        super.strict();
        return this;
    }

    public ParameterInfo copyFrom(ParameterInfo p) {
        if (p != null) {
            if (p.name != null) {
                this.name = p.name;
            }
            if (p.in != null) {
                this.in = p.in;
            }
            if (p.description != null) {
                this.description = p.description;
            }
            if (p.type != null) {
                this.type = p.type;
            }
            if (p.format != null) {
                this.format = p.format;
            }
            if (p.pattern != null) {
                this.pattern = p.pattern;
            }
            if (p.collectionFormat != null) {
                this.collectionFormat = p.collectionFormat;
            }
            if (p.maximum != null) {
                this.maximum = p.maximum;
            }
            if (p.minimum != null) {
                this.minimum = p.minimum;
            }
            if (p.multipleOf != null) {
                this.multipleOf = p.multipleOf;
            }
            if (p.maxLength != null) {
                this.maxLength = p.maxLength;
            }
            if (p.minLength != null) {
                this.minLength = p.minLength;
            }
            if (p.maxItems != null) {
                this.maxItems = p.maxItems;
            }
            if (p.minItems != null) {
                this.minItems = p.minItems;
            }
            if (p.required != null) {
                this.required = p.required;
            }
            if (p.allowEmptyValue != null) {
                this.allowEmptyValue = p.allowEmptyValue;
            }
            if (p.exclusiveMaximum != null) {
                this.exclusiveMaximum = p.exclusiveMaximum;
            }
            if (p.exclusiveMinimum != null) {
                this.exclusiveMinimum = p.exclusiveMinimum;
            }
            if (p.uniqueItems != null) {
                this.uniqueItems = p.uniqueItems;
            }
            if (p.schema != null) {
                this.schema = p.schema;
            }
            if (p.items != null) {
                this.items = p.items;
            }
            if (p._default != null) {
                this._default = p._default;
            }
            if (p._enum != null) {
                this._enum = p._enum;
            }
            if (p.example != null) {
                this.example = p.example;
            }
            if (p.examples != null) {
                this.examples = p.examples;
            }
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ParameterInfo setName(String value) {
        if (!"body".equals(this.in)) {
            this.name = value;
        }
        return this;
    }

    public ParameterInfo name(Object value) {
        return this.setName(StringUtils.stringify((Object)value));
    }

    public String getIn() {
        return this.in;
    }

    public ParameterInfo setIn(String value) {
        if (this.isStrict() && !ArrayUtils.contains((String)value, (String[])VALID_IN)) {
            throw new FormattedRuntimeException("Invalid value passed in to setIn(String).  Value=''{0}'', valid values={1}", new Object[]{value, VALID_IN});
        }
        this.in = value;
        if ("path".equals(value)) {
            this.required = true;
        }
        return this;
    }

    public ParameterInfo in(Object value) {
        return this.setIn(StringUtils.stringify((Object)value));
    }

    public String getDescription() {
        return this.description;
    }

    public ParameterInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public ParameterInfo description(Object value) {
        return this.setDescription(StringUtils.stringify((Object)value));
    }

    public Boolean getRequired() {
        return this.required;
    }

    public ParameterInfo setRequired(Boolean value) {
        this.required = value;
        return this;
    }

    public ParameterInfo required(Object value) {
        return this.setRequired(ObjectUtils.toBoolean((Object)value));
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public ParameterInfo setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    public ParameterInfo schema(Object value) {
        return this.setSchema((SchemaInfo)ObjectUtils.toType((Object)value, SchemaInfo.class));
    }

    public String getType() {
        return this.type;
    }

    public ParameterInfo setType(String value) {
        if (this.isStrict() && !ArrayUtils.contains((String)value, (String[])VALID_TYPES)) {
            throw new FormattedRuntimeException("Invalid value passed in to setType(String).  Value=''{0}'', valid values={1}", new Object[]{value, VALID_TYPES});
        }
        this.type = value;
        return this;
    }

    public ParameterInfo type(Object value) {
        return this.setType(StringUtils.stringify((Object)value));
    }

    public String getFormat() {
        return this.format;
    }

    public ParameterInfo setFormat(String value) {
        this.format = value;
        return this;
    }

    public ParameterInfo format(Object value) {
        return this.setFormat(StringUtils.stringify((Object)value));
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public ParameterInfo setAllowEmptyValue(Boolean value) {
        this.allowEmptyValue = value;
        return this;
    }

    public ParameterInfo allowEmptyValue(Object value) {
        return this.setAllowEmptyValue(ObjectUtils.toBoolean((Object)value));
    }

    public Items getItems() {
        return this.items;
    }

    public ParameterInfo setItems(Items value) {
        this.items = value;
        return this;
    }

    public ParameterInfo items(Object value) {
        return this.setItems((Items)ObjectUtils.toType((Object)value, Items.class));
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public ParameterInfo setCollectionFormat(String value) {
        if (this.isStrict() && !ArrayUtils.contains((String)value, (String[])VALID_COLLECTION_FORMATS)) {
            throw new FormattedRuntimeException("Invalid value passed in to setCollectionFormat(String).  Value=''{0}'', valid values={1}", new Object[]{value, VALID_COLLECTION_FORMATS});
        }
        this.collectionFormat = value;
        return this;
    }

    public ParameterInfo collectionFormat(Object value) {
        return this.setCollectionFormat(StringUtils.stringify((Object)value));
    }

    public Object getDefault() {
        return this._default;
    }

    public ParameterInfo setDefault(Object value) {
        this._default = value;
        return this;
    }

    public ParameterInfo _default(Object value) {
        return this.setDefault(value);
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public ParameterInfo setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public ParameterInfo maximum(Object value) {
        return this.setMaximum(ObjectUtils.toNumber((Object)value));
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public ParameterInfo setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public ParameterInfo exclusiveMaximum(Object value) {
        return this.setExclusiveMaximum(ObjectUtils.toBoolean((Object)value));
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public ParameterInfo setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public ParameterInfo minimum(Object value) {
        return this.setMinimum(ObjectUtils.toNumber((Object)value));
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public ParameterInfo setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public ParameterInfo exclusiveMinimum(Object value) {
        return this.setExclusiveMinimum(ObjectUtils.toBoolean((Object)value));
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public ParameterInfo setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public ParameterInfo maxLength(Object value) {
        return this.setMaxLength(ObjectUtils.toInteger((Object)value));
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public ParameterInfo setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public ParameterInfo minLength(Object value) {
        return this.setMinLength(ObjectUtils.toInteger((Object)value));
    }

    public String getPattern() {
        return this.pattern;
    }

    public ParameterInfo setPattern(String value) {
        this.pattern = value;
        return this;
    }

    public ParameterInfo pattern(Object value) {
        return this.setPattern(StringUtils.stringify((Object)value));
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public ParameterInfo setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public ParameterInfo maxItems(Object value) {
        return this.setMaxItems(ObjectUtils.toInteger((Object)value));
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public ParameterInfo setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public ParameterInfo minItems(Object value) {
        return this.setMinItems(ObjectUtils.toInteger((Object)value));
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public ParameterInfo setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    public ParameterInfo uniqueItems(Object value) {
        return this.setUniqueItems(ObjectUtils.toBoolean((Object)value));
    }

    public List<Object> getEnum() {
        return this._enum;
    }

    public ParameterInfo setEnum(Collection<Object> value) {
        this._enum = CollectionUtils.newList(value);
        return this;
    }

    public ParameterInfo addEnum(Collection<Object> value) {
        this._enum = CollectionUtils.addToList(this._enum, value);
        return this;
    }

    public ParameterInfo _enum(Object ... values) {
        this._enum = CollectionUtils.addToList(this._enum, (Object[])values, Object.class, (Type[])new Type[0]);
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public ParameterInfo setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public ParameterInfo multipleOf(Object value) {
        return this.setMultipleOf(ObjectUtils.toNumber((Object)value));
    }

    @Beanp(value="x-example")
    public String getExample() {
        return this.example;
    }

    @Beanp(value="x-example")
    public ParameterInfo setExample(String value) {
        this.example = value;
        return this;
    }

    public ParameterInfo example(Object value) {
        this.example = StringUtils.stringify((Object)value);
        return this;
    }

    @Beanp(value="x-examples")
    public Map<String, String> getExamples() {
        return this.examples;
    }

    @Beanp(value="x-examples")
    public ParameterInfo setExamples(Map<String, String> value) {
        this.examples = CollectionUtils.newMap(value);
        return this;
    }

    public ParameterInfo addExamples(Map<String, String> values) {
        this.examples = CollectionUtils.addToMap(this.examples, values);
        return this;
    }

    public ParameterInfo example(String name, String value) {
        this.examples = CollectionUtils.addToMap(this.examples, (Object)name, (Object)value);
        return this;
    }

    public ParameterInfo examples(Object ... values) {
        this.examples = CollectionUtils.addToMap(this.examples, (Object[])values, String.class, String.class, (Type[])new Type[0]);
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "name": {
                return (T)ObjectUtils.toType((Object)this.getName(), type);
            }
            case "in": {
                return (T)ObjectUtils.toType((Object)this.getIn(), type);
            }
            case "description": {
                return (T)ObjectUtils.toType((Object)this.getDescription(), type);
            }
            case "required": {
                return (T)ObjectUtils.toType((Object)this.getRequired(), type);
            }
            case "schema": {
                return (T)ObjectUtils.toType((Object)this.getSchema(), type);
            }
            case "type": {
                return (T)ObjectUtils.toType((Object)this.getType(), type);
            }
            case "format": {
                return (T)ObjectUtils.toType((Object)this.getFormat(), type);
            }
            case "allowEmptyValue": {
                return (T)ObjectUtils.toType((Object)this.getAllowEmptyValue(), type);
            }
            case "items": {
                return (T)ObjectUtils.toType((Object)this.getItems(), type);
            }
            case "collectionFormat": {
                return (T)ObjectUtils.toType((Object)this.getCollectionFormat(), type);
            }
            case "default": {
                return (T)ObjectUtils.toType((Object)this.getDefault(), type);
            }
            case "maximum": {
                return (T)ObjectUtils.toType((Object)this.getMaximum(), type);
            }
            case "exclusiveMaximum": {
                return (T)ObjectUtils.toType((Object)this.getExclusiveMaximum(), type);
            }
            case "minimum": {
                return (T)ObjectUtils.toType((Object)this.getMinimum(), type);
            }
            case "exclusiveMinimum": {
                return (T)ObjectUtils.toType((Object)this.getExclusiveMinimum(), type);
            }
            case "maxLength": {
                return (T)ObjectUtils.toType((Object)this.getMaxLength(), type);
            }
            case "minLength": {
                return (T)ObjectUtils.toType((Object)this.getMinLength(), type);
            }
            case "pattern": {
                return (T)ObjectUtils.toType((Object)this.getPattern(), type);
            }
            case "maxItems": {
                return (T)ObjectUtils.toType((Object)this.getMaxItems(), type);
            }
            case "minItems": {
                return (T)ObjectUtils.toType((Object)this.getMinItems(), type);
            }
            case "uniqueItems": {
                return (T)ObjectUtils.toType((Object)this.getUniqueItems(), type);
            }
            case "enum": {
                return (T)ObjectUtils.toType(this.getEnum(), type);
            }
            case "multipleOf": {
                return (T)ObjectUtils.toType((Object)this.getMultipleOf(), type);
            }
            case "x-example": {
                return (T)ObjectUtils.toType((Object)this.getExample(), type);
            }
            case "x-examples": {
                return (T)ObjectUtils.toType(this.getExamples(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public ParameterInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "name": {
                return this.name(value);
            }
            case "in": {
                return this.in(value);
            }
            case "description": {
                return this.description(value);
            }
            case "required": {
                return this.required(value);
            }
            case "schema": {
                return this.schema(value);
            }
            case "type": {
                return this.type(value);
            }
            case "format": {
                return this.format(value);
            }
            case "allowEmptyValue": {
                return this.allowEmptyValue(value);
            }
            case "items": {
                return this.items(value);
            }
            case "collectionFormat": {
                return this.collectionFormat(value);
            }
            case "default": {
                return this._default(value);
            }
            case "maximum": {
                return this.maximum(value);
            }
            case "exclusiveMaximum": {
                return this.exclusiveMaximum(value);
            }
            case "minimum": {
                return this.minimum(value);
            }
            case "exclusiveMinimum": {
                return this.exclusiveMinimum(value);
            }
            case "maxLength": {
                return this.maxLength(value);
            }
            case "minLength": {
                return this.minLength(value);
            }
            case "pattern": {
                return this.pattern(value);
            }
            case "maxItems": {
                return this.maxItems(value);
            }
            case "minItems": {
                return this.minItems(value);
            }
            case "uniqueItems": {
                return this.uniqueItems(value);
            }
            case "enum": {
                return this.setEnum(null)._enum(value);
            }
            case "multipleOf": {
                return this.multipleOf(value);
            }
            case "x-example": {
                return this.example(value);
            }
            case "x-examples": {
                return this.examples(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet s = new ASet().appendIf(this.name != null, (Object)"name").appendIf(this.in != null, (Object)"in").appendIf(this.description != null, (Object)"description").appendIf(this.required != null, (Object)"required").appendIf(this.schema != null, (Object)"schema").appendIf(this.type != null, (Object)"type").appendIf(this.format != null, (Object)"format").appendIf(this.allowEmptyValue != null, (Object)"allowEmptyValue").appendIf(this.items != null, (Object)"items").appendIf(this.collectionFormat != null, (Object)"collectionFormat").appendIf(this._default != null, (Object)"default").appendIf(this.maximum != null, (Object)"maximum").appendIf(this.exclusiveMaximum != null, (Object)"exclusiveMaximum").appendIf(this.minimum != null, (Object)"minimum").appendIf(this.exclusiveMinimum != null, (Object)"exclusiveMinimum").appendIf(this.maxLength != null, (Object)"maxLength").appendIf(this.minLength != null, (Object)"minLength").appendIf(this.pattern != null, (Object)"pattern").appendIf(this.maxItems != null, (Object)"maxItems").appendIf(this.minItems != null, (Object)"minItems").appendIf(this.uniqueItems != null, (Object)"uniqueItems").appendIf(this._enum != null, (Object)"enum").appendIf(this.multipleOf != null, (Object)"multipleOf").appendIf(this.example != null, (Object)"x-example").appendIf(this.examples != null, (Object)"x-examples");
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    public ParameterInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (this.schema != null) {
            this.schema = this.schema.resolveRefs(swagger, refStack, maxDepth);
        }
        if (this.items != null) {
            this.items = this.items.resolveRefs(swagger, refStack, maxDepth);
        }
        return this;
    }
}

