/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw.rs_json;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.jena.atlas.data.DataBag;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;

public class RowSetBuffered<T extends RowSet>
extends IteratorSlotted<Binding>
implements RowSet {
    protected T delegate;
    protected Supplier<DataBag<Binding>> bufferFactory;
    protected DataBag<Binding> buffer = null;
    protected Iterator<Binding> bufferIterator = null;
    protected long rowNumber;
    protected List<Var> resultVars = null;

    public RowSetBuffered(T delegate, Supplier<DataBag<Binding>> bufferFactory) {
        this(delegate, bufferFactory, 0L);
    }

    public RowSetBuffered(T delegate, Supplier<DataBag<Binding>> bufferFactory, long rowNumber) {
        this.delegate = delegate;
        this.bufferFactory = bufferFactory;
        this.rowNumber = rowNumber;
    }

    public T getDelegate() {
        return this.delegate;
    }

    @Override
    public List<Var> getResultVars() {
        if (this.resultVars == null) {
            this.resultVars = this.getDelegate().getResultVars();
            this.getDelegate().hasNext();
            this.resultVars = this.getDelegate().getResultVars();
            if (this.resultVars == null && this.getDelegate().hasNext()) {
                this.buffer = this.bufferFactory.get();
                while ((this.resultVars = this.getDelegate().getResultVars()) == null) {
                    if (!this.getDelegate().hasNext()) continue;
                    Binding b = this.getDelegate().next();
                    this.buffer.add(b);
                }
                this.bufferIterator = this.buffer.iterator();
            }
        }
        return this.resultVars;
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    protected void closeBuffer() {
        try {
            if (this.bufferIterator != null) {
                Iter.close(this.bufferIterator);
            }
        }
        finally {
            if (this.buffer != null) {
                this.buffer.close();
            }
        }
        this.bufferIterator = null;
        this.buffer = null;
    }

    @Override
    public void closeIterator() {
        try {
            this.closeBuffer();
        }
        finally {
            this.getDelegate().close();
        }
    }

    @Override
    protected Binding moveToNext() {
        Binding result;
        if (this.bufferIterator != null) {
            if (this.bufferIterator.hasNext()) {
                result = this.bufferIterator.next();
            } else {
                this.closeBuffer();
                result = this.nextFromDelegate();
            }
        } else {
            result = this.nextFromDelegate();
        }
        ++this.rowNumber;
        return result;
    }

    @Override
    protected boolean hasMore() {
        return true;
    }

    protected Binding nextFromDelegate() {
        Binding result = this.getDelegate().hasNext() ? this.getDelegate().next() : null;
        return result;
    }
}

