/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NegotiatingClientConnection
extends AbstractConnection.NonBlocking {
    private static final Logger LOG = LoggerFactory.getLogger(NegotiatingClientConnection.class);
    private final SSLEngine engine;
    private final ClientConnectionFactory connectionFactory;
    private final Map<String, Object> context;
    private String protocol;
    private volatile boolean completed;

    protected NegotiatingClientConnection(EndPoint endPoint, Executor executor, SSLEngine sslEngine, ClientConnectionFactory connectionFactory, Map<String, Object> context2) {
        super(endPoint, executor);
        this.engine = sslEngine;
        this.connectionFactory = connectionFactory;
        this.context = context2;
    }

    public SSLEngine getSSLEngine() {
        return this.engine;
    }

    protected Map<String, Object> getContext() {
        return this.context;
    }

    public String getProtocol() {
        return this.protocol;
    }

    protected void completed(String protocol) {
        this.protocol = protocol;
        this.completed = true;
    }

    @Override
    public void onOpen() {
        super.onOpen();
        try {
            this.getEndPoint().flush(BufferUtil.EMPTY_BUFFER);
            if (this.completed) {
                this.replaceConnection();
            } else {
                this.fillInterested();
            }
        }
        catch (Throwable x) {
            this.close();
            this.failConnectionPromise(x);
        }
    }

    @Override
    public void onFillable() {
        Throwable failure;
        block5: {
            failure = null;
            try {
                int filled;
                do {
                    filled = this.getEndPoint().fill(BufferUtil.EMPTY_BUFFER);
                    if (this.completed) {
                        this.replaceConnection();
                        break block5;
                    }
                    if (filled >= 0) continue;
                    throw new SSLHandshakeException("Abruptly closed by peer");
                } while (filled != 0);
                this.fillInterested();
            }
            catch (Throwable x) {
                failure = x;
            }
        }
        if (failure != null) {
            LOG.atDebug().setCause(failure).log("Unable to fill from endpoint");
            this.close();
            this.failConnectionPromise(failure);
        }
    }

    @Override
    public boolean onIdleExpired(TimeoutException timeout) {
        this.getEndPoint().close(timeout);
        this.failConnectionPromise(timeout);
        return false;
    }

    @Override
    public void close() {
        this.getEndPoint().shutdownOutput();
        super.close();
    }

    private void replaceConnection() throws IOException {
        EndPoint endPoint = this.getEndPoint();
        endPoint.upgrade(this.connectionFactory.newConnection(endPoint, this.context));
    }

    private void failConnectionPromise(Throwable failure) {
        Promise promise = (Promise)this.context.get(ClientConnector.CONNECTION_PROMISE_CONTEXT_KEY);
        promise.failed(failure);
    }
}

