/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritePendingException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WriteFlusher {
    private static final Logger LOG = LoggerFactory.getLogger(WriteFlusher.class);
    private static final ByteBuffer[] EMPTY_BUFFERS = new ByteBuffer[]{BufferUtil.EMPTY_BUFFER};
    private static final EnumMap<StateType, Set<StateType>> __stateTransitions = new EnumMap(StateType.class);
    private static final State __IDLE = new IdleState();
    private static final State __FLUSHING = new FlushingState();
    private static final State __COMPLETING = new CompletingState();
    private static final State __CANCEL = new State(StateType.CANCEL);
    private final EndPoint _endPoint;
    private final AtomicReference<State> _state = new AtomicReference();

    protected WriteFlusher(EndPoint endPoint) {
        this._state.set(__IDLE);
        this._endPoint = endPoint;
    }

    private boolean updateState(State previous, State next) {
        if (!this.isTransitionAllowed(previous, next)) {
            throw new IllegalArgumentException("Bad transition %s -> %s".formatted(previous, next));
        }
        boolean updated = this._state.compareAndSet(previous, next);
        if (LOG.isDebugEnabled()) {
            LOG.debug("update {}:{}{}{}", this, previous, updated ? "-->" : "!->", next);
        }
        return updated;
    }

    private boolean isTransitionAllowed(State currentState, State newState) {
        Set<StateType> allowedNewStateTypes = __stateTransitions.get((Object)currentState.getType());
        if (!allowedNewStateTypes.contains((Object)newState.getType())) {
            LOG.warn("{}: {} -> {} not allowed", this, currentState, newState);
            return false;
        }
        return true;
    }

    public Invocable.InvocationType getCallbackInvocationType() {
        Invocable.InvocationType invocationType;
        State s = this._state.get();
        if (s instanceof PendingState) {
            PendingState p = (PendingState)s;
            invocationType = p.getCallbackInvocationType();
        } else {
            invocationType = Invocable.InvocationType.BLOCKING;
        }
        return invocationType;
    }

    protected abstract void onIncompleteFlush();

    public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
        this.write(callback, (SocketAddress)null, buffers);
    }

    public void write(Callback callback, SocketAddress address, ByteBuffer ... buffers) throws WritePendingException {
        Objects.requireNonNull(callback);
        if (this.isFailed()) {
            this.fail(callback, new Throwable[0]);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("write: {} {}", (Object)this, (Object)BufferUtil.toDetailString(buffers));
        }
        if (!this.updateState(__IDLE, __FLUSHING)) {
            throw new WritePendingException();
        }
        try {
            buffers = this.flush(address, buffers);
            if (buffers != null) {
                PendingState pending;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("flush incomplete {}", (Object)this);
                }
                if (this.updateState(__FLUSHING, pending = new PendingState(callback, address, buffers))) {
                    this.onIncompleteFlush();
                } else {
                    this.fail(callback, new Throwable[0]);
                }
                return;
            }
            if (this.updateState(__FLUSHING, __IDLE)) {
                callback.succeeded();
            } else {
                this.fail(callback, new Throwable[0]);
            }
        }
        catch (Throwable e2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("write exception", e2);
            }
            if (this.updateState(__FLUSHING, new FailedState(e2))) {
                callback.failed(e2);
            }
            this.fail(callback, e2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fail(Callback callback, Throwable ... suppressed) {
        block5: while (true) {
            state = this._state.get();
            switch (state.getType().ordinal()) {
                case 4: {
                    cancellingState = new CancellingState(callback);
                    if (!this._state.compareAndSet(state, cancellingState)) continue block5;
                    return;
                }
                case 6: {
                    failed = (FailedState)state;
                    cause = failed.getCause();
                    break block5;
                }
                case 0: 
                case 5: {
                    for (Throwable t : suppressed) {
                        WriteFlusher.LOG.warn("Failed Write Cause", t);
                    }
                    return;
                }
                default: {
                    t = new IllegalStateException();
                    if (this._state.compareAndSet(state, new FailedState(t))) ** break;
                    continue block5;
                    cause = t;
                    break block5;
                }
            }
            break;
        }
        for (Throwable t : suppressed) {
            if (t == cause) continue;
            cause.addSuppressed(t);
        }
        callback.failed(cause);
    }

    public void completeWrite() {
        State previous;
        if (LOG.isDebugEnabled()) {
            LOG.debug("completeWrite: {}", (Object)this);
        }
        if ((previous = this._state.get()).getType() != StateType.PENDING) {
            return;
        }
        PendingState pending = (PendingState)previous;
        if (!this.updateState(pending, __COMPLETING)) {
            return;
        }
        Callback callback = pending._callback;
        try {
            ByteBuffer[] buffers = pending._buffers;
            SocketAddress address = pending._address;
            buffers = this.flush(address, buffers);
            if (buffers != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("flushed incomplete {}", (Object)BufferUtil.toDetailString(buffers));
                }
                if (buffers != pending._buffers) {
                    pending = new PendingState(callback, address, buffers);
                }
                if (this.updateState(__COMPLETING, pending)) {
                    this.onIncompleteFlush();
                } else {
                    this.fail(callback, new Throwable[0]);
                }
                return;
            }
            if (this.updateState(__COMPLETING, __IDLE)) {
                callback.succeeded();
            } else {
                this.fail(callback, new Throwable[0]);
            }
        }
        catch (Throwable e2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("completeWrite exception", e2);
            }
            if (this.updateState(__COMPLETING, new FailedState(e2))) {
                callback.failed(e2);
            }
            this.fail(callback, e2);
        }
    }

    protected ByteBuffer[] flush(SocketAddress address, ByteBuffer[] buffers) throws IOException {
        boolean progress = true;
        while (progress && buffers != null) {
            long before = BufferUtil.remaining(buffers);
            boolean flushed = address == null ? this._endPoint.flush(buffers) : this._endPoint.send(address, buffers);
            long after = BufferUtil.remaining(buffers);
            long written = before - after;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushed={} written={} remaining={} {}", flushed, written, after, this);
            }
            if (flushed) {
                return null;
            }
            progress = written > 0L;
            int index = 0;
            while (true) {
                if (index == buffers.length) {
                    buffers = null;
                    index = 0;
                    break;
                }
                int remaining = buffers[index].remaining();
                if (remaining > 0) break;
                ++index;
                progress = true;
            }
            if (index <= 0) continue;
            buffers = Arrays.copyOfRange(buffers, index, buffers.length);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("!fully flushed {}", (Object)this);
        }
        return buffers == null ? EMPTY_BUFFERS : buffers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onFail(Throwable cause) {
        block5: while (true) {
            State current = this._state.get();
            switch (current.getType().ordinal()) {
                case 0: 
                case 4: 
                case 5: 
                case 6: {
                    if (!LOG.isDebugEnabled()) return false;
                    LOG.debug("ignored: {} {}", (Object)cause, (Object)this);
                    LOG.trace("IGNORED", cause);
                    return false;
                }
                case 2: {
                    PendingState pending;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("failed: {}", (Object)this, (Object)cause);
                    }
                    if (!this.updateState(pending = (PendingState)current, new FailedState(cause))) continue block5;
                    pending._callback.failed(cause);
                    return true;
                }
                case 1: 
                case 3: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("failed: {}", (Object)this, (Object)cause);
                    }
                    if (this.updateState(current, new FailedState(cause))) return true;
                    continue block5;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Callback cancelWrite(Throwable cause) {
        block8: while (true) {
            State current = this._state.get();
            switch (current.getType().ordinal()) {
                case 0: {
                    if (!this.updateState(current, new FailedState(cause))) continue block8;
                    return null;
                }
                case 6: {
                    return null;
                }
                case 2: {
                    PendingState pending = (PendingState)current;
                    if (!this.updateState(current, new FailedState(cause))) continue block8;
                    return pending._callback;
                }
                case 1: 
                case 3: {
                    this.updateState(current, __CANCEL);
                    continue block8;
                }
                case 4: {
                    Thread.onSpinWait();
                    continue block8;
                }
                case 5: {
                    CancellingState cancelling = (CancellingState)current;
                    if (this.updateState(current, new FailedState(cause))) return cancelling._callback;
                    continue block8;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public void onClose() {
        switch (this._state.get().getType().ordinal()) {
            case 0: 
            case 6: {
                return;
            }
        }
        this.onFail(new ClosedChannelException());
    }

    public boolean isFailed() {
        return this.isState(StateType.FAILED);
    }

    boolean isIdle() {
        return this.isState(StateType.IDLE);
    }

    public boolean isPending() {
        return this.isState(StateType.PENDING);
    }

    private boolean isState(StateType type) {
        return this._state.get().getType() == type;
    }

    public String toStateString() {
        return switch (this._state.get().getType().ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "-";
            case 1 -> "F";
            case 2 -> "P";
            case 3 -> "C";
            case 4 -> "l";
            case 5 -> "L";
            case 6 -> "F";
        };
    }

    public String toString() {
        State s = this._state.get();
        return String.format("WriteFlusher@%x{%s}->%s", this.hashCode(), s, s instanceof PendingState ? ((PendingState)s)._callback : null);
    }

    static {
        __stateTransitions.put(StateType.IDLE, EnumSet.of(StateType.FLUSHING, StateType.FAILED));
        __stateTransitions.put(StateType.FLUSHING, EnumSet.of(StateType.IDLE, StateType.PENDING, StateType.CANCEL, StateType.FAILED));
        __stateTransitions.put(StateType.PENDING, EnumSet.of(StateType.COMPLETING, StateType.IDLE, StateType.FAILED));
        __stateTransitions.put(StateType.COMPLETING, EnumSet.of(StateType.IDLE, StateType.PENDING, StateType.CANCEL, StateType.FAILED));
        __stateTransitions.put(StateType.CANCEL, EnumSet.of(StateType.CANCELLING));
        __stateTransitions.put(StateType.CANCELLING, EnumSet.of(StateType.FAILED));
        __stateTransitions.put(StateType.FAILED, EnumSet.noneOf(StateType.class));
    }

    private static class State {
        private final StateType _type;

        private State(StateType stateType) {
            this._type = stateType;
        }

        public StateType getType() {
            return this._type;
        }

        public String toString() {
            return String.format("%s", new Object[]{this._type});
        }
    }

    private static enum StateType {
        IDLE,
        FLUSHING,
        PENDING,
        COMPLETING,
        CANCEL,
        CANCELLING,
        FAILED;

    }

    private class PendingState
    extends State {
        private final Callback _callback;
        private final SocketAddress _address;
        private final ByteBuffer[] _buffers;

        private PendingState(Callback callback, SocketAddress address, ByteBuffer[] buffers) {
            super(StateType.PENDING);
            this._callback = callback;
            this._address = address;
            this._buffers = buffers;
        }

        Invocable.InvocationType getCallbackInvocationType() {
            return Invocable.getInvocationType(this._callback);
        }
    }

    private static class FailedState
    extends State {
        private final Throwable _cause;

        private FailedState(Throwable cause) {
            super(StateType.FAILED);
            this._cause = cause;
        }

        public Throwable getCause() {
            return this._cause;
        }
    }

    private class CancellingState
    extends State {
        private final Callback _callback;

        private CancellingState(Callback callback) {
            super(StateType.CANCELLING);
            this._callback = callback;
        }
    }

    private static class IdleState
    extends State {
        private IdleState() {
            super(StateType.IDLE);
        }
    }

    private static class FlushingState
    extends State {
        private FlushingState() {
            super(StateType.FLUSHING);
        }
    }

    private static class CompletingState
    extends State {
        private CompletingState() {
            super(StateType.COMPLETING);
        }
    }
}

