/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.text.Format;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.CoordinateFormat;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.metadata.internal.NameToIdentifier;
import org.apache.sis.metadata.internal.ReferencingServices;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.DefaultParametricCS;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.util.AxisDirections;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.referencing.util.TemporalAccessor;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;
import org.opengis.util.NoSuchIdentifierException;
import org.opengis.util.TypeName;

public final class ServicesForMetadata
extends ReferencingServices {
    public static final String CONNECTION = "CONNECTION";

    private static String dimensionNotFound(short resourceKey, CoordinateReferenceSystem crs) {
        if (crs == null) {
            return Errors.format((short)157);
        }
        return Resources.format(resourceKey, crs.getName());
    }

    private static DefaultGeographicBoundingBox setGeographicExtent(Envelope envelope, DefaultGeographicBoundingBox target, CoordinateReferenceSystem crs, GeographicCRS normalizedCRS, String findOpCaller) throws TransformException {
        double northBoundLatitude;
        double southBoundLatitude;
        double eastBoundLongitude;
        double westBoundLongitude;
        if (normalizedCRS != null) {
            CoordinateSystem cs1 = crs.getCoordinateSystem();
            EllipsoidalCS cs2 = normalizedCRS.getCoordinateSystem();
            if (!Utilities.equalsIgnoreMetadata(cs2.getAxis(0), cs1.getAxis(0)) || !Utilities.equalsIgnoreMetadata(cs2.getAxis(1), cs1.getAxis(1))) {
                CoordinateOperation operation;
                DefaultCoordinateOperationFactory factory = DefaultCoordinateOperationFactory.provider();
                try {
                    operation = factory.createOperation(crs, normalizedCRS);
                }
                catch (FactoryException e2) {
                    if (findOpCaller != null) {
                        Logging.recoverableException(Logger.getLogger("org.apache.sis.referencing"), Envelopes.class, findOpCaller, e2);
                        return null;
                    }
                    throw new TransformException(Resources.format((short)8), e2);
                }
                envelope = Envelopes.transform(operation, envelope);
            }
        }
        if (envelope instanceof AbstractEnvelope) {
            AbstractEnvelope ae = (AbstractEnvelope)envelope;
            westBoundLongitude = ae.getLower(0);
            eastBoundLongitude = ae.getUpper(0);
            southBoundLatitude = ae.getLower(1);
            northBoundLatitude = ae.getUpper(1);
        } else {
            westBoundLongitude = envelope.getMinimum(0);
            eastBoundLongitude = envelope.getMaximum(0);
            southBoundLatitude = envelope.getMinimum(1);
            northBoundLatitude = envelope.getMaximum(1);
        }
        if (normalizedCRS != null) {
            double rotation = CRS.getGreenwichLongitude(normalizedCRS);
            westBoundLongitude += rotation;
            eastBoundLongitude += rotation;
        }
        if (findOpCaller != null) {
            if (Double.isNaN(southBoundLatitude)) {
                southBoundLatitude = -90.0;
            }
            if (Double.isNaN(northBoundLatitude)) {
                northBoundLatitude = 90.0;
            }
            if (Double.isNaN(eastBoundLongitude) || Double.isNaN(westBoundLongitude)) {
                eastBoundLongitude = -180.0;
                westBoundLongitude = 180.0;
            }
        }
        if (target == null) {
            target = new DefaultGeographicBoundingBox();
        }
        target.setBounds(westBoundLongitude, eastBoundLongitude, southBoundLatitude, northBoundLatitude);
        target.setInclusion(Boolean.TRUE);
        return target;
    }

    private static void setVerticalExtent(Envelope envelope, DefaultVerticalExtent target, CoordinateReferenceSystem crs, VerticalCRS verticalCRS) {
        int dim;
        if (verticalCRS == null) {
            dim = 0;
        } else {
            dim = AxisDirections.indexOfColinear(crs.getCoordinateSystem(), verticalCRS.getCoordinateSystem());
            assert (dim >= 0) : crs;
        }
        target.setMinimumValue(envelope.getMinimum(dim));
        target.setMaximumValue(envelope.getMaximum(dim));
        target.setVerticalCRS(verticalCRS);
    }

    @Override
    public DefaultGeographicBoundingBox setBounds(Envelope envelope, DefaultGeographicBoundingBox target, String findOpCaller) throws TransformException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        GeographicCRS normalizedCRS = ReferencingUtilities.toNormalizedGeographicCRS(crs, false, false);
        if (normalizedCRS == null) {
            if (crs != null) {
                normalizedCRS = CommonCRS.defaultGeographic();
            } else if (envelope.getDimension() != 2) {
                if (findOpCaller != null) {
                    return null;
                }
                throw new TransformException(ServicesForMetadata.dimensionNotFound((short)40, crs));
            }
        }
        return ServicesForMetadata.setGeographicExtent(envelope, target, crs, normalizedCRS, findOpCaller);
    }

    @Override
    public void setBounds(Envelope envelope, DefaultVerticalExtent target) throws TransformException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        VerticalCRS verticalCRS = CRS.getVerticalComponent(crs, true);
        if (verticalCRS == null && envelope.getDimension() != 1) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)45, crs));
        }
        ServicesForMetadata.setVerticalExtent(envelope, target, crs, verticalCRS);
    }

    @Override
    public void setBounds(Envelope envelope, DefaultTemporalExtent target) throws TransformException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        TemporalAccessor accessor = TemporalAccessor.of(crs, 0);
        if (accessor == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)43, crs));
        }
        accessor.setTemporalExtent(envelope, target);
    }

    @Override
    public void setBounds(Envelope envelope, DefaultSpatialTemporalExtent target) throws TransformException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        SingleCRS horizontalCRS = CRS.getHorizontalComponent(crs);
        VerticalCRS verticalCRS = CRS.getVerticalComponent(crs, true);
        TemporalAccessor accessor = TemporalAccessor.of(crs, 0);
        if (horizontalCRS == null && verticalCRS == null && accessor == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)42, crs));
        }
        DefaultGeographicBoundingBox box = null;
        boolean useExistingBox = horizontalCRS != null;
        Collection<GeographicExtent> spatialExtents = target.getSpatialExtent();
        Iterator<GeographicExtent> it = spatialExtents.iterator();
        while (it.hasNext()) {
            GeographicExtent extent = it.next();
            if (!(extent instanceof GeographicBoundingBox)) continue;
            if (useExistingBox && extent instanceof DefaultGeographicBoundingBox) {
                box = (DefaultGeographicBoundingBox)extent;
                useExistingBox = false;
                continue;
            }
            it.remove();
        }
        if (horizontalCRS != null) {
            GeographicCRS normalizedCRS;
            if (box == null) {
                box = new DefaultGeographicBoundingBox();
                spatialExtents.add(box);
            }
            if ((normalizedCRS = ReferencingUtilities.toNormalizedGeographicCRS(crs, false, false)) == null) {
                normalizedCRS = CommonCRS.defaultGeographic();
            }
            ServicesForMetadata.setGeographicExtent(envelope, box, crs, normalizedCRS, null);
        }
        if (verticalCRS != null) {
            VerticalExtent e2 = target.getVerticalExtent();
            if (!(e2 instanceof DefaultVerticalExtent)) {
                e2 = new DefaultVerticalExtent();
                target.setVerticalExtent(e2);
            }
            ServicesForMetadata.setVerticalExtent(envelope, (DefaultVerticalExtent)e2, crs, verticalCRS);
        } else {
            target.setVerticalExtent(null);
        }
        if (accessor != null) {
            accessor.setTemporalExtent(envelope, target);
        } else {
            target.setExtent(null);
        }
    }

    @Override
    public void addElements(Envelope envelope, DefaultExtent target) throws TransformException {
        ISOMetadata extent;
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        SingleCRS horizontalCRS = CRS.getHorizontalComponent(crs);
        VerticalCRS verticalCRS = CRS.getVerticalComponent(crs, true);
        TemporalAccessor accessor = TemporalAccessor.of(crs, 0);
        if (horizontalCRS == null && verticalCRS == null && accessor == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)42, crs));
        }
        if (horizontalCRS != null) {
            target.getGeographicElements().add(this.setBounds(envelope, null, null));
        }
        if (verticalCRS != null) {
            extent = new DefaultVerticalExtent();
            ServicesForMetadata.setVerticalExtent(envelope, extent, crs, verticalCRS);
            target.getVerticalElements().add((VerticalExtent)((Object)extent));
        }
        if (accessor != null) {
            extent = new DefaultTemporalExtent();
            accessor.setTemporalExtent(envelope, (DefaultTemporalExtent)extent);
            target.getTemporalElements().add((TemporalExtent)((Object)extent));
        }
    }

    @Override
    public DirectPosition geographic(double \u03bb, double \u03c6) {
        return new DirectPosition2D(CommonCRS.defaultGeographic(), \u03bb, \u03c6);
    }

    @Override
    public String getPreferredIdentifier(IdentifiedObject object) throws FactoryException {
        Integer code = IdentifiedObjects.lookupEPSG(object);
        if (code != null) {
            return "EPSG:" + code;
        }
        for (ReferenceIdentifier id : object.getIdentifiers()) {
            if ("EPSG".equalsIgnoreCase(id.getCodeSpace())) continue;
            return IdentifiedObjects.toString(id);
        }
        return IdentifiedObjects.getSimpleNameOrIdentifier(object);
    }

    @Override
    public TypeName getValueType(ParameterDescriptor<?> parameter) {
        return parameter instanceof DefaultParameterDescriptor ? ((DefaultParameterDescriptor)parameter).getValueType() : null;
    }

    @Override
    public <T> ParameterDescriptor<T> toImplementation(ParameterDescriptor<T> parameter) {
        return DefaultParameterDescriptor.castOrCopy(parameter);
    }

    public static CoordinateSystem createParametricCS(Map<String, ?> properties, CoordinateSystemAxis axis, CSFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createParametricCS(properties, axis);
    }

    public static Datum createParametricDatum(Map<String, ?> properties, DatumFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        return ((GeodeticObjectFactory)factory).createParametricDatum(properties);
    }

    public static SingleCRS createParametricCRS(Map<String, ?> properties, Datum datum, CoordinateSystem cs, CRSFactory factory) throws FactoryException {
        if (!(factory instanceof GeodeticObjectFactory)) {
            factory = GeodeticObjectFactory.provider();
        }
        try {
            return ((GeodeticObjectFactory)factory).createParametricCRS(properties, (DefaultParametricDatum)datum, (DefaultParametricCS)cs);
        }
        catch (ClassCastException e2) {
            throw new InvalidGeodeticParameterException(e2.toString(), e2);
        }
    }

    @Override
    public Format createCoordinateFormat(Locale locale, TimeZone timezone2) {
        return new CoordinateFormat(locale, timezone2);
    }

    @Override
    public CoordinateOperationFactory getCoordinateOperationFactory() {
        return DefaultCoordinateOperationFactory.provider();
    }

    public static OperationMethod getOperationMethod(CoordinateOperationFactory opFactory, MathTransformFactory mtFactory, String identifier) throws FactoryException {
        OperationMethod method;
        if (opFactory instanceof DefaultCoordinateOperationFactory) {
            ((DefaultCoordinateOperationFactory)opFactory).getOperationMethod(identifier);
        }
        if ((method = ServicesForMetadata.getOperationMethod(mtFactory.getAvailableMethods(SingleOperation.class), identifier)) != null) {
            return method;
        }
        throw new NoSuchIdentifierException("No such operation method: " + identifier, identifier);
    }

    private static OperationMethod getOperationMethod(Iterable<? extends OperationMethod> methods, String identifier) {
        OperationMethod fallback = null;
        for (OperationMethod operationMethod : methods) {
            if (!IdentifiedObjects.isHeuristicMatchForName(operationMethod, identifier) && !NameToIdentifier.isHeuristicMatchForIdentifier(operationMethod.getIdentifiers(), identifier)) continue;
            if (!(operationMethod instanceof Deprecable) || !((Deprecable)((Object)operationMethod)).isDeprecated()) {
                return operationMethod;
            }
            if (fallback != null) continue;
            fallback = operationMethod;
        }
        return fallback;
    }

    @Override
    public String getInformation(String key, Locale locale) {
        switch (key) {
            case "EPSG": {
                Citation authority;
                try {
                    authority = CRS.getAuthorityFactory("EPSG").getAuthority();
                }
                catch (FactoryException e2) {
                    String msg = Exceptions.getLocalizedMessage(e2, locale);
                    return msg != null ? msg : e2.toString();
                }
                if (authority instanceof DefaultCitation) {
                    OnLineFunction f = OnLineFunction.valueOf(CONNECTION);
                    for (OnlineResource res : ((DefaultCitation)authority).getOnlineResources()) {
                        InternationalString i18n;
                        if (!f.equals(res.getFunction()) || (i18n = res.getDescription()) == null) continue;
                        return i18n.toString(locale);
                    }
                    InternationalString i18n = authority.getTitle();
                    if (i18n != null) {
                        return i18n.toString(locale);
                    }
                }
                return Vocabulary.getResources(locale).getString((short)210);
            }
        }
        return super.getInformation(key, locale);
    }
}

