/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.ConcatenatedConverter;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Errors;

class SexagesimalConverter
extends AbstractConverter {
    private static final long serialVersionUID = -2119974989555436361L;
    private static final double EPS = 1.0E-10;
    static final ConventionalUnit<Angle> DM;
    static final Unit<Angle> DMS;
    static final Unit<Angle> DMS_SCALED;
    final boolean hasSeconds;
    final double divider;
    private final SexagesimalConverter inverse;

    private SexagesimalConverter(boolean hasSeconds, double divider) {
        this.hasSeconds = hasSeconds;
        this.divider = divider;
        this.inverse = new Inverse(this);
    }

    private SexagesimalConverter(SexagesimalConverter inverse) {
        this.hasSeconds = inverse.hasSeconds;
        this.divider = inverse.divider;
        this.inverse = inverse;
    }

    @Override
    public final UnitConverter inverse() {
        return this.inverse;
    }

    @Override
    public double convert(double angle) {
        double deg = MathFunctions.truncate(angle);
        angle = (angle - deg) * 60.0;
        if (this.hasSeconds) {
            double min2 = MathFunctions.truncate(angle);
            angle = (angle - min2) * 60.0;
            angle += (deg * 100.0 + min2) * 100.0;
        } else {
            angle += deg * 100.0;
        }
        return angle / this.divider;
    }

    @Override
    public final double derivative(double value) {
        return Double.NaN;
    }

    public final boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && ((SexagesimalConverter)object).divider == this.divider;
    }

    public final int hashCode() {
        return (int)this.divider ^ this.getClass().hashCode();
    }

    static {
        SystemUnit rad = (SystemUnit)Units.RADIAN;
        UnitConverter toRadian = Units.DEGREE.getConverterTo(rad);
        DM = new ConventionalUnit(rad, new ConcatenatedConverter(new SexagesimalConverter(false, 100.0).inverse(), toRadian), "D.M", 32, 9111);
        DMS = new ConventionalUnit<Angle>(rad, new ConcatenatedConverter(new SexagesimalConverter(true, 10000.0).inverse(), toRadian), "D.MS", 32, 9110);
        DMS_SCALED = new ConventionalUnit<Angle>(rad, new ConcatenatedConverter(new SexagesimalConverter(true, 1.0).inverse(), toRadian), "DMS", 32, 9107);
    }

    private static final class Inverse
    extends SexagesimalConverter {
        private static final long serialVersionUID = -1928146841653975281L;

        public Inverse(SexagesimalConverter inverse) {
            super(inverse);
        }

        private static double fixRoundingError(double remainder, double magnitude) {
            int p = Math.getExponent(Math.ulp(magnitude));
            if (p < 0 && p >= -52) {
                p = Numerics.toExp10(-p);
                double scale = MathFunctions.pow10(p);
                remainder = Math.rint(remainder * scale) / scale;
            }
            return remainder;
        }

        @Override
        public double convert(double angle) throws IllegalArgumentException {
            double min2;
            double deg;
            double sec2;
            if (this.hasSeconds) {
                double mgn;
                sec2 = mgn = angle * this.divider;
                deg = MathFunctions.truncate(sec2 / 10000.0);
                min2 = MathFunctions.truncate((sec2 -= 10000.0 * deg) / 100.0);
                sec2 -= 100.0 * min2;
                sec2 = Inverse.fixRoundingError(sec2, mgn);
            } else {
                double mgn;
                sec2 = 0.0;
                min2 = mgn = angle * this.divider;
                deg = MathFunctions.truncate(min2 / 100.0);
                min2 -= deg * 100.0;
                min2 = Inverse.fixRoundingError(min2, mgn);
            }
            if (min2 <= -60.0 || min2 >= 60.0) {
                if (Math.abs(Math.abs(min2) - 100.0) <= 1.0E-8) {
                    deg = min2 >= 0.0 ? (deg += 1.0) : (deg -= 1.0);
                    min2 = 0.0;
                } else {
                    throw Inverse.illegalField(angle, min2, 0);
                }
            }
            if (sec2 <= -60.0 || sec2 >= 60.0) {
                if (Math.abs(Math.abs(sec2) - 100.0) <= 1.0E-8) {
                    min2 = sec2 >= 0.0 ? (min2 += 1.0) : (min2 -= 1.0);
                    sec2 = 0.0;
                } else {
                    throw Inverse.illegalField(angle, sec2, 1);
                }
            }
            return (sec2 / 60.0 + min2) / 60.0 + deg;
        }

        private static IllegalArgumentException illegalField(double value, double field, int unit) {
            return new IllegalArgumentException(Errors.format((short)44, value, unit, field));
        }
    }
}

