/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.ArrayUtil;

public final class LongHeap {
    private final int maxSize;
    private long[] heap;
    private int size = 0;

    public LongHeap(int maxSize) {
        if (maxSize < 1 || maxSize >= ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxSize must be > 0 and < " + (ArrayUtil.MAX_ARRAY_LENGTH - 1) + "; got: " + maxSize);
        }
        int heapSize = maxSize + 1;
        this.maxSize = maxSize;
        this.heap = new long[heapSize];
    }

    public final long push(long element) {
        ++this.size;
        if (this.size == this.heap.length) {
            this.heap = ArrayUtil.grow(this.heap, (this.size * 3 + 1) / 2);
        }
        this.heap[this.size] = element;
        this.upHeap(this.size);
        return this.heap[1];
    }

    public boolean insertWithOverflow(long value) {
        if (this.size >= this.maxSize) {
            if (value < this.heap[1]) {
                return false;
            }
            this.updateTop(value);
            return true;
        }
        this.push(value);
        return true;
    }

    public final long top() {
        return this.heap[1];
    }

    public final long pop() {
        if (this.size > 0) {
            long result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            --this.size;
            this.downHeap(1);
            return result;
        }
        throw new IllegalStateException("The heap is empty");
    }

    public final long updateTop(long value) {
        this.heap[1] = value;
        this.downHeap(1);
        return this.heap[1];
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        this.size = 0;
    }

    private void upHeap(int origPos) {
        int i = origPos;
        long value = this.heap[i];
        for (int j = i >>> 1; j > 0 && value < this.heap[j]; j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = value;
    }

    private void downHeap(int i) {
        long value = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.heap[k] < this.heap[j]) {
            j = k;
        }
        while (j <= this.size && this.heap[j] < value) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || this.heap[k] >= this.heap[j]) continue;
            j = k;
        }
        this.heap[i] = value;
    }

    public void pushAll(LongHeap other) {
        for (int i = 1; i <= other.size; ++i) {
            this.push(other.heap[i]);
        }
    }

    public long get(int i) {
        return this.heap[i];
    }

    final long[] getHeapArray() {
        return this.heap;
    }
}

