/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;

final class ConjunctionBulkScorer
extends BulkScorer {
    private final Scorer[] scoringScorers;
    private final DocIdSetIterator lead1;
    private final DocIdSetIterator lead2;
    private final List<DocIdSetIterator> others;
    private final Scorable scorable;

    ConjunctionBulkScorer(List<Scorer> requiredScoring, List<Scorer> requiredNoScoring) throws IOException {
        int numClauses = requiredScoring.size() + requiredNoScoring.size();
        if (numClauses <= 1) {
            throw new IllegalArgumentException("Expected 2 or more clauses, got " + numClauses);
        }
        final ArrayList<Scorer> allScorers = new ArrayList<Scorer>();
        allScorers.addAll(requiredScoring);
        allScorers.addAll(requiredNoScoring);
        this.scoringScorers = (Scorer[])requiredScoring.toArray(Scorer[]::new);
        ArrayList<DocIdSetIterator> iterators = new ArrayList<DocIdSetIterator>();
        for (Scorer scorer : allScorers) {
            iterators.add(scorer.iterator());
        }
        Collections.sort(iterators, Comparator.comparingLong(DocIdSetIterator::cost));
        this.lead1 = (DocIdSetIterator)iterators.get(0);
        this.lead2 = (DocIdSetIterator)iterators.get(1);
        this.others = List.copyOf(iterators.subList(2, iterators.size()));
        this.scorable = new Scorable(){

            @Override
            public float score() throws IOException {
                double score = 0.0;
                for (Scorer scorer : ConjunctionBulkScorer.this.scoringScorers) {
                    score += (double)scorer.score();
                }
                return (float)score;
            }

            @Override
            public Collection<Scorable.ChildScorable> getChildren() throws IOException {
                ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>();
                for (Scorer scorer : allScorers) {
                    children.add(new Scorable.ChildScorable(scorer, "MUST"));
                }
                return children;
            }

            @Override
            public int docID() {
                return ConjunctionBulkScorer.this.lead1.docID();
            }
        };
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
        int next;
        int doc;
        assert (this.lead1.docID() >= this.lead2.docID());
        if (this.lead1.docID() < min2) {
            this.lead1.advance(min2);
        }
        if (this.lead1.docID() >= max2) {
            return this.lead1.docID();
        }
        collector.setScorer(this.scorable);
        List<DocIdSetIterator> otherIterators = this.others;
        DocIdSetIterator collectorIterator = collector.competitiveIterator();
        if (collectorIterator != null) {
            otherIterators = new ArrayList<DocIdSetIterator>(otherIterators);
            otherIterators.add(collectorIterator);
        }
        DocIdSetIterator[] others = (DocIdSetIterator[])otherIterators.toArray(DocIdSetIterator[]::new);
        if (this.lead1.docID() == this.lead2.docID()) {
            doc = this.lead1.docID();
            if (acceptDocs == null || acceptDocs.get(doc)) {
                boolean match = true;
                for (DocIdSetIterator it : others) {
                    if (it.docID() < doc && (next = it.advance(doc)) != doc) {
                        this.lead1.advance(next);
                        match = false;
                        break;
                    }
                    assert (it.docID() == doc);
                }
                if (match) {
                    collector.collect(doc);
                    this.lead1.nextDoc();
                }
            } else {
                this.lead1.nextDoc();
            }
        }
        doc = this.lead1.docID();
        block1: while (doc < max2) {
            assert (this.lead2.docID() < doc);
            if (acceptDocs != null && !acceptDocs.get(doc)) {
                doc = this.lead1.nextDoc();
                continue;
            }
            int next2 = this.lead2.advance(doc);
            if (next2 != doc) {
                doc = this.lead1.advance(next2);
                if (doc != next2) continue;
                if (doc >= max2) break;
                if (acceptDocs != null && !acceptDocs.get(doc)) {
                    doc = this.lead1.nextDoc();
                    continue;
                }
            }
            assert (this.lead2.docID() == doc);
            for (DocIdSetIterator it : others) {
                if (it.docID() < doc && (next = it.advance(doc)) != doc) {
                    doc = this.lead1.advance(next);
                    continue block1;
                }
                assert (it.docID() == doc);
            }
            collector.collect(doc);
            doc = this.lead1.nextDoc();
        }
        return this.lead1.docID();
    }

    @Override
    public long cost() {
        return this.lead1.cost();
    }
}

