/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate.lib;

import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.lib.AccStatLib;
import org.apache.jena.sparql.function.FunctionEnv;

abstract class AccStatBase
extends AccumulatorExpr {
    private static final NodeValue noValuesToAvg = NodeValue.nvZERO;
    private static final NodeValue errorValue = null;
    protected long count = 0L;
    protected double K = 0.0;
    protected double sum = 0.0;
    protected double sumSquared = 0.0;

    public AccStatBase(Expr expr, boolean distinct) {
        super(expr, distinct);
    }

    @Override
    protected final NodeValue getAccValue() {
        if (this.errorCount != 0L) {
            return null;
        }
        if (this.count <= 0L) {
            return noValuesToAvg;
        }
        try {
            double x1 = this.calc();
            return NodeValue.makeDouble(x1);
        }
        catch (ExprEvalException ex) {
            return errorValue;
        }
    }

    protected abstract double calc();

    protected final double calcVarianceSample() {
        return AccStatLib.calcVarianceSample(this.sumSquared, this.sum, this.count);
    }

    protected final double calcVariancePop() {
        return AccStatLib.calcVariancePopulation(this.sumSquared, this.sum, this.count);
    }

    @Override
    protected void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
        if (nv.isNumber()) {
            double d = nv.getDouble();
            ++this.count;
            if (this.count == 1L) {
                this.K = d;
                this.sum = d - this.K;
                this.sumSquared = (d - this.K) * (d - this.K);
                return;
            }
            double dk = d - this.K;
            double dk2 = dk * dk;
            this.sum += dk;
            this.sumSquared += dk2;
        } else {
            throw new ExprEvalException("Not a number: " + String.valueOf(nv));
        }
    }

    @Override
    protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
    }
}

